// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 29 1.4.1.3 source/core/collect/icstr.h, collection, ioc.v400, 980918 
#ifndef _ICSTR_
#define _ICSTR_

#if ! defined(__INO_STREAMING__)
#include <iastr.h>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#pragma pack(push,4)
#pragma enum(4)

template < class Element >
class ICollectionStreamer : public IACollectionStreamer 
{
public:
  ICollectionStreamer () {};
  virtual ~ICollectionStreamer () {};

  virtual void streamOut (IDataStream& toWhere, void* element)
  { *(Element*)element >>= toWhere;
  };

  virtual void streamIn (IDataStream& fromWhere, void* element)
  { new (element) Element ();
    *(Element*)element <<= fromWhere;
  };

};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif

#endif // _ICSTR_
