// Revision: 63 1.5.1.3 source/ui/basectl/icslider.hpp, multimedia, ioc.v400, 980918 
#ifndef _ICSLIDER_
   #define _ICSLIDER_
/*******************************************************************************
* FILE NAME: icslider.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     ICircularSlider                                                          *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Material - Property of IBM                                        *
*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved.                   *
*                                                                              *
*******************************************************************************/
#include <itextctl.hpp>
#include <irect.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IRange;
class ISize;
class IResourceId;
class IWindowHandle;
class IBitmapHandle;
class ICircularSliderData;

#pragma enum(4)
#pragma pack(push,4)

#ifdef IC_PMWIN

class ICircularSlider : public ITextControl {
typedef ITextControl
  Inherited;
public:
class Style;

/*------------------------------ Constructors --------------------------------*/
  ICircularSlider  (unsigned long Identifier,
                    IWindow* parent,
                    IWindow* owner,
                    const IRectangle& initial = IRectangle(),
                    const Style& style = defaultStyle());

  ICircularSlider  (unsigned long Identifier,
                    IWindow* parentAndOwner);

  ICircularSlider  (const IWindowHandle& handle);

virtual
  ~ICircularSlider ();

/*---------------------------------- Styles ----------------------------------*/
INESTEDBITFLAGCLASSDEF2(Style, ICircularSlider, IWindow, IControl);

static const Style
  IC_IMPORTU buttons,
  IC_IMPORTU label,
  IC_IMPORTU displayValue,
  IC_IMPORTU jumpToPointer,
  IC_IMPORTU full360,
  IC_IMPORTU midpoint,
  IC_IMPORTU proportionalTicks,
  IC_IMPORTU noTicks,
  IC_IMPORTU circularArm,
  IC_IMPORTU classDefaultStyle;

static Style
  defaultStyle     ( );
static void
  setDefaultStyle  ( const Style& style );

virtual unsigned long
  convertToGUIStyle ( const IBitFlag& style,
                      bool         extendedOnly = false ) const;

/*------------------------------ Arm Operations ------------------------------*/
IRange
  armRange             () const;
long
  value                () const;
unsigned long
  radius               () const,
  rotationIncrement    () const,
  tickSpacing          () const;

ICircularSlider
  &setArmRange         (const IRange& range),
  &setValue            (long value),
  &setRotationIncrement(unsigned long increment),
  &setTickSpacing      (unsigned long tick),
  &setDecrementBitmaps (const IResourceId& leftUp,
                        const IResourceId& leftDown),
  &setDecrementBitmaps (const IBitmapHandle& leftUp,
                        const IBitmapHandle& leftDown),
  &setIncrementBitmaps (const IResourceId& rightUp,
                        const IResourceId& rightDown),
  &setIncrementBitmaps (const IBitmapHandle& rightUp,
                        const IBitmapHandle& rightDown);

/*----------------------- Notification Event Descriptions --------------------*/
static INotificationId const
  IC_IMPORTU valueId,
  IC_IMPORTU trackId;

/*--------------------------- Observer Notification --------------------------*/
virtual ICircularSlider
 &enableNotification ( bool enable=true );

protected:
/*------------------------------ Layout Support ------------------------------*/
virtual ISize
  calcMinimumSize() const;

private:
/*------------------------------ Hidden Members ------------------------------*/
  ICircularSlider       ( const ICircularSlider& slider );
ICircularSlider
 &operator=             ( const ICircularSlider& slider );

/*--------------------------------- Private ----------------------------------*/
/**** jad 6-4--97 (icl2_7576)
static bool
  IC_IMPORTU fRegistered;
****/
static Style
  IC_IMPORTU currentDefaultStyle;
void*
  fData;

ICircularSliderData
 *fCircularSliderData;
}; // ICircularSlider

INESTEDBITFLAGCLASSFUNCS(Style, ICircularSlider)

#endif /* IC_PMWIN  */

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif /* _ICSLIDER_ */
