/**
 * FILE NAME: icoordsy.hpp
 *
 * DESCRIPTION:
 *   Declaration of the class:
 *     ICoordinateSystem
 *
 *   IBM Open Class Library
 *   (C) Copyright International Business Machines Corporation,  1997
 *   Licensed Material - Program-Property of IBM - All Rights Reserved.
 */

// Revision: 02 1.9.1.5 source/albert/graph2d/icoordsy.hpp, 2d, ioc.v400, 980918 

#ifndef _ICOORDSY_
#define _ICOORDSY_

#include <ibase.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IRectangle;
class IPoint;
class ISize;
class ICoordinateSystemData;

#pragma enum(4)
#pragma pack(push,4)

class ICoordinateSystem
{
public:

	/*------------------------------- Orientation --------------------------------*/
	enum EOrientation
	{
		kOriginUpperLeft,
		kOriginLowerLeft
#if ( IC_OBSOLETE <= IC_OBSOLETE_3 )
		,
		originUpperLeft = kOriginUpperLeft,
		originLowerLeft = kOriginLowerLeft
#endif // IC_OBSOLETE
	};
#if ( IC_OBSOLETE <= IC_OBSOLETE_3 )
typedef EOrientation Orientation;
#endif // IC_OBSOLETE

	static EOrientation nativeOrientation();
	static EOrientation applicationOrientation();
	static EOrientation setApplicationOrientation(EOrientation coordsystem = kOriginUpperLeft);

	/*-------------------------------- Conversion --------------------------------*/
	static IRectangle convertToApplication(
		const IRectangle& nativeRectangle,
		const ISize& referenceSize);

	static IRectangle convertToNative(
        const IRectangle& applicationRectangle,
		const ISize& referenceSize);

	static IPoint convertToApplication(
        const IPoint& nativePoint,
		const ISize& referenceSize);

	static IPoint convertToNative(
        const IPoint& applicationPoint,
		const ISize& referenceSize);

	static bool isConversionNeeded();

private:
	/*------------------------------ Hidden Members ------------------------------*/
	ICoordinateSystem();

	/*--------------------------------- Private ----------------------------------*/
	static EOrientation fsapplication;
	static IRectangle convertRectangle(
        const IRectangle& rectangle,
		const ISize& referenceSize);

//	ICoordinateSystemData *fCoordinateSystemData;

	friend class SetupOrientation;
};

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#include <icoordsy.inl>

#endif // _ICOORDSY_
