// ----------------------------------------------------------------------------
// FILE NAME: iconditn.hpp
// 
// DESCRIPTION:
//
//  This header contains the declaration of the classes:
//      ICondition
//      IPrivateCondition
//      ISharedCondition
//
//  The condition classes are all based upon platform specific implementation
//  classes in the subdirectories under base. The fImpl member of ICondition
//  points to the implementation object.
//
// COPYRIGHT:
//   IBM Open Class Library
//   Licensed Materials - Property of IBM
//
//   5645-001
//   (C) Copyright IBM Corporation 1992, 1997  All Rights Reserved.
//
// Revision: 57 1.14.1.5 source/core/base/iconditn.hpp, oss, ioc.v400, 980918  
// ----------------------------------------------------------------------------

#ifndef _ICONDITN_
#define _ICONDITN_

#include <ibhandle.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IString;
class IResourceLock;
class IPrivCondImpl;
class ISharedCondImpl;
class IStartedThread;

#pragma pack(push,4)
#pragma enum(4)

class ICondition
{
public:
    static void         Relock(IResourceLock&, long times);
    static long         Unlock(IResourceLock&);

public:
    virtual bool        wait(long timeOut = -1) = 0;
    virtual bool        wait(IResourceLock& alock, long timeOut = -1) = 0;
    virtual void        signal() = 0;
    virtual void        broadcast() = 0;
    virtual             ~ICondition() {}

protected:
                        ICondition() {}

private:
                        ICondition(const ICondition& condition);
    ICondition &        operator=(const ICondition& condition);
};

class IPrivateCondition : public ICondition
{
public:
                        IPrivateCondition();
    virtual             ~IPrivateCondition();

    virtual bool        wait(long timeOut = -1);
    virtual bool        wait(IResourceLock& aLock, long timeOut = -1);

    virtual void        signal();

    virtual void        broadcast();

private:
                        IPrivateCondition(const IPrivateCondition& condition);
    IPrivateCondition&  operator=(const IPrivateCondition& condition);
    friend IStartedThread;
    IPrivCondImpl*      fImpl;
};

class ISharedCondition : public ICondition
{
public:
                        ISharedCondition();
                        ISharedCondition(const char* keyName);
    virtual             ~ISharedCondition();

    virtual bool        wait(long timeOut = -1);
    virtual bool        wait(IResourceLock& alock, long timeOut = -1);

    virtual void        signal();

    virtual void        broadcast();

    IString             keyName() const;

    static  bool        exists(const char* keyName);

private:
                        ISharedCondition ( const ISharedCondition& condition );
    ISharedCondition&   operator= ( const ISharedCondition& condition );
    friend IStartedThread;

    ISharedCondImpl*    fImpl;
};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif // _ICONDITN_
