// Revision: 49 1.4.1.4 source/ui/basectl/icolvwd.hpp, listctls, ioc.v400, 980918 
#ifndef _ICOLVWD_
  #define _ICOLVWD_
/*******************************************************************************
* FILE NAME: icolvwd.hpp                                                       *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     ICollectionViewData                                                      *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Material - Property of IBM                                        *
*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved.                   *
*                                                                              *
*******************************************************************************/
#include  <icolobsv.hpp>
#include  <istrgen.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#pragma enum(4)
#pragma pack(push,4)

template <class Element, class ViewClass, class Collection > class IVBContainerControlData;
template <class Element,  class Collection > class ICollectionViewListBoxData;
template <class Element,  class Collection > class ICollectionViewComboBoxData;


template <class Element, class ViewClass, class Collection>
  class ICollectionViewData  {

public:

  ICollectionViewData( )
  : fCollectionObserver( ICollectionObserver<Element,ViewClass,Collection>( ) )
  { }

  ICollectionViewData( const IStringGenerator<Element>& stringGenerator )
  : fCollectionObserver( ICollectionObserver<Element,ViewClass,Collection>( ) ),
    fGenerator( stringGenerator )
  { }

 ~ICollectionViewData ( ) { }

ICollectionObserver< Element, ViewClass, Collection >
  &collectionObserver() { return fCollectionObserver; }

IStringGenerator<Element>
  &generator() { return fGenerator; }

ICollectionViewData<Element,ViewClass,Collection>
  &setGenerator( const IStringGenerator<Element>&  newGenerator )
    { fGenerator = newGenerator;  return *this; }

private:

  ICollectionViewData ( const ICollectionViewData<Element,ViewClass,Collection>& source );

ICollectionViewData<Element,ViewClass,Collection>
 &operator=           ( const ICollectionViewData<Element,ViewClass,Collection>& source );



ICollectionObserver< Element, ViewClass, Collection >
  fCollectionObserver;

IStringGenerator<Element>
  fGenerator;

};

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif   /*  _ICOLVWD_  */
