// Revision: 99 1.8.1.4 source/ui/baseapp/icolor.hpp, datatype, ioc.v400, 980918 
#ifndef _ICOLOR_
#define _ICOLOR_
/*******************************************************************************
* FILE NAME: icolor.hpp                                                        *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IDeviceColor                                                             *
*     IGUIColor                                                                *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Material - Property of IBM                                        *
*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved                    *
*                                                                              *
*******************************************************************************/
#include <ibase.hpp>
#include <ibcolor.hpp>
#include <iuipl.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IDeviceColorData;
class IGUIColorData;

#pragma enum(4)
#pragma pack(push,4)

class IDeviceColor : public IColor {
typedef IColor
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
enum DeviceColor {
  defaultColor,
  background,
  neutral
  };

  IDeviceColor ( DeviceColor color );
virtual
 ~IDeviceColor ( );

/*--------------------------- Color Representation ---------------------------*/
DeviceColor
  deviceColor ( ) const;

private:
/*--------------------------------- Private ----------------------------------*/
DeviceColor
  dcClDeviceColor;

IDeviceColorData
 *fDeviceColorData;
}; // IDeviceColor


class IGUIColor : public IColor {
typedef IColor
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IGUIColor ( ESystemColor value );
virtual
 ~IGUIColor ( );

/*--------------------------- Color Representation ---------------------------*/
#ifndef IC_MOTIF
ESystemColor
  systemColor ( ) const;
#endif

/*-------------------------- Setting System Colors ---------------------------*/
#ifndef IC_MOTIF_FLAGNOP
IGUIColor
 &setColor ( const IColor& newColor );
#endif

private:
/*--------------------------------- Private ----------------------------------*/
ESystemColor
  scClSysColor;

IGUIColorData
 *fGUIColorData;

/*----------------------------- Obsolete Members -----------------------------*/
#if (IC_OBSOLETE <= IC_OBSOLETE_2)
public:
typedef SystemColor
  SysColor;
#endif
}; // IGUIColor

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#include <icolor.inl>

#endif // _ICOLOR_
