// Revision: 61 1.17 source/core/text/intl/compare/icolitr.hpp, text, ocdev
// icolitr.hpp
/**
 * This file contains the class ICollationIterator which the protocol for iterating through host or portable collation objects.
 *
 * @package     Text and International
 * @category International Components
 *
 * @copyright
 *              IBM Open Class Library
 *              (C) Copyright International Business Machines Corporation 1997
 *              Licensed Material - Program-Property of IBM - All Rights Reserved.
 *
 * @author              Helena Shih
 */

#ifndef _ICOLITR_
#define _ICOLITR_

#include <iprimtyp.hpp>
#include <itext.hpp>
#include <ilocale.hpp>
#include <itxtcoll.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IHostCollationIterator;
class IPortableCollationIterator;

#pragma enum(4)
#pragma pack(push,4)

//========================================================================================
// CLASS ICollationIterator
//========================================================================================
class ICollationIterator
{
        public:
                /**
                 *              typedefs and constant definitions
                 */

                enum ECollationType {
                        kHostCollationsOnly,
                        kPortableCollationsOnly,
                        kAllCollations
                };
                /**
                 *              Constructors and destructor
                 */

                ICollationIterator(ECollationType type = kAllCollations);

                ICollationIterator(const ICollationIterator& that);

                ~ICollationIterator();

                /**
                 *              Assignment
                 */

                ICollationIterator& operator=(const ICollationIterator& that);

        /**
         * Comparison operator
                 */

                bool                            operator==(const ICollationIterator& that) const;

                bool                            operator!=(const ICollationIterator& that) const;

        /**
         * Cursor actions
                 */

                void                            reset();

                ICollation*             create(ICollation::ECollationStrength
                                                                strength = ICollation::kTertiaryDifference) const;

                                                        operator bool() const;

                IText                           localePOSIXID() const;

                /**
                 * Increment operators
                 */

                ICollationIterator& operator++();
                ICollationIterator      operator++(int);
                /**
                 * Displayable Name
                 */

                IText                           displayName(
                                                        const ILocaleKey& desiredLanguage = ILocaleKey::defaultLocale(),
                                                        ILocaleKey::ELookupStrategy strategy = ILocaleKey::kAnyLanguage) const;

        private:
                enum ECollationScope {
                        kHostCollationSet,
                        kPortableCollationSet
                };

                IHostCollationIterator          *fHostCollations;
                IPortableCollationIterator      *fPortableCollations;
                ECollationType                          fCollType;
                ECollationScope                         fCollationScope;

};

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif // _ICOLITR_
