// Revision: 29 1.8.1.3 source/ui/cnr/icnrolst.hpp, container, ioc.v400, 980918 
#ifndef _ICNROLST_
#define _ICNROLST_
/*******************************************************************************
* FILE NAME: icnrolst.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     ICnrObjectSet                                                            *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Material - Property of IBM                                        *
*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved.                   *
*                                                                              *
*******************************************************************************/
#include <ilanglvl.hpp>
#include <iuipl.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#pragma enum(4)
#pragma pack(push,4)

class ICnrObjectSetImp;
class IContainerObject;

class ICnrObjectSet
{

public:



/*------------------------ Constructors --------------------------------------*/
  ICnrObjectSet( );
  ICnrObjectSet(const ICnrObjectSet&);
  ICnrObjectSet&
     operator= (const ICnrObjectSet&);

  ~ICnrObjectSet( );


     class Cursor
     {
     public:
       Cursor (const ICnrObjectSet& objectList);

       Cursor ( const Cursor& cursor);

       Cursor& operator=(const Cursor& cursor);

      ~Cursor ( );

       bool
         setToFirst    ( ),
         setToLast     ( ),
         setToNext     ( ),
         setToPrevious ( ),
         isValid       ( ) const;

       void
         invalidate ( );

       IContainerObject* const
         element    ( ) const;

       private:
         const ICnrObjectSetImp
          *fObjectListImp;
         void
          *fObjectCursorImp;

        friend class ICnrObjectSet;
     }; // Cursor


bool
  add       ( IContainerObject* const& object);

void
  addAllFrom ( const ICnrObjectSet& objectList),
  addAsLast ( IContainerObject* const& object),
  addAsFirst ( IContainerObject* const& object),
  addAsNext  ( IContainerObject* const& object, Cursor& cursor),
  addAtPosition ( unsigned long pos, IContainerObject* const& object),
  addAsPrevious  ( IContainerObject* const& object, Cursor& cursor);

bool
  allElementsDo   ( bool (*function) (IContainerObject* &, void*),
                    void* additionalArgument = 0),
  allElementsDo   ( bool (*function) (IContainerObject* const&, void*),
                    void* additionalArgument = 0) const;

long
  compare ( const ICnrObjectSet& objectList,
            long (*compFunction)(IContainerObject* const&,
                                 IContainerObject* const&)) const;

void
  sort    ( long (*comparisonFunction)(IContainerObject* const&,
                                 IContainerObject* const&));

IContainerObject*
  elementAt   ( const Cursor& cursor) const;

IContainerObject
*elementAtPosition ( unsigned long position) const,
*firstElement      ( ) const,
*lastElement       ( ) const;

bool
  isEmpty ( ) const;

unsigned long
  position ( Cursor const& cursor ) const,
  numberOfElements ( ) const,
  removeAll ( ),
  removeAll ( bool (*predicateFunction)(IContainerObject* const&,
                                        void*),
              void* data=0);

void
  removeAt           ( Cursor& cursor),
  removeAtPosition   ( unsigned long position),
  removeFirst        ( ),
  removeLast         ( ),
  replaceAt ( const Cursor& cursor, IContainerObject* const& object),
  setToPosition ( unsigned long pos, Cursor& cursor) const;

private:
friend class Cursor;
ICnrObjectSetImp
 *fObjectListImp;

};    // ICnrObjectSet

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif // _ICNROLST_
