// Revision: 16 1.10.1.6 source/ui/cnr/icnrobj.hpp, container, ioc.v400, 980918 
#ifndef _ICNROBJ_
#define _ICNROBJ_
/*******************************************************************************
* FILE NAME: icnrobj.hpp                                                       *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IContainerObject                                                         *
*     ICnrAllocator                                                            *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Material - Property of IBM                                        *
*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved.                   *
*                                                                              *
*******************************************************************************/
#include <ibase.hpp>
#include <ihandle.hpp>
#include <istring.hpp>

extern "C" {
  #include <stdlib.h>
  }

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class ICnrAllocator;
class ICnrControlData;
class ICnrObjPrivateData;
class ICnrRecord;
class IContainerControl;
class IMiniCnrRecord;
class IResourceId;
class ContainedInElement;
#ifdef IC_MOTIF
struct _RECORDCORE;
#endif

#pragma enum(4)
#pragma pack(push,4)

class IContainerObject  {
public:
/*------------------------------ Related Members -----------------------------*/
enum Emphasis { none=0, cursored=1, inuse=2, selected=4 };

/*------------------------------- Constructors -------------------------------*/
  IContainerObject ( );
  IContainerObject ( const IString&          string,
                     const IPointerHandle&   iconHandle = 0 );

  IContainerObject ( const IString&          string,
                     const IResourceId&      iconId );

  IContainerObject ( const IResourceId&      nameID,
                     const IResourceId&      iconId );

  IContainerObject ( const IContainerObject& object );

  IContainerObject ( const IString&          string,
                     unsigned long           iconId );

  IContainerObject
     &operator=    ( const IContainerObject& object );

virtual
 ~IContainerObject ( );

/*------------------------------ Characteristics -----------------------------*/
virtual IContainerObject
 &setIcon           ( const IPointerHandle& iconHandle ),
 &setIcon           ( const IResourceId&    iconId ),
 &setIcon           ( unsigned long         iconId ),

 &setInUseIcon      ( const IPointerHandle& iconHandle ),
 &setInUseIcon      ( const IResourceId&    iconId ),
 &setInUseIcon      ( unsigned long         iconId ),

 &setIconText       ( const char*           iconText ),
 &setIconText       ( const IString&        iconText ),
 &setIconText       ( const IResourceId&    iconTextId );

virtual IPointerHandle
  icon              ( ) const;
virtual IPointerHandle
  inUseIcon         ( ) const;
virtual IString
  iconText          ( ) const;

virtual IContainerObject
 &setInUse          ( bool            inUse = true,
                      IContainerControl* container = 0 ),
 &removeInUse       ( IContainerControl* container = 0 );

virtual IContainerObject
 &enableDataUpdate  ( bool            enable = true,
                      IContainerControl* container = 0 ),
 &disableDataUpdate ( IContainerControl* container = 0 );

#ifndef IC_MOTIF_FLAGNOP
virtual IContainerObject
 &enableDrop        ( bool            enable = true,
                      IContainerControl* container = 0 ),
 &disableDrop       ( IContainerControl* container = 0 );
#endif

virtual IContainerObject
 &show              ( bool            show = true,
                      IContainerControl* container = 0 ),
 &hide              ( IContainerControl* container = 0 );

virtual IContainerObject
 &refresh           ( IContainerControl* container = 0,
                      bool            immediate = false ),
 &setRefreshOn      ( bool            refreshOn = true ),
 &setRefreshOff     ( );

virtual bool
  isInUse           ( IContainerControl* container = 0 ) const;
virtual bool
  isWriteable       ( IContainerControl* container = 0 ) const;
#ifndef IC_MOTIF_FLAGNOP
virtual bool
  isDropOnAble      ( IContainerControl* container = 0 ) const;
#endif

virtual bool
  isVisible         ( IContainerControl* container = 0 ) const;

virtual bool
  isRefreshOn       ( ) const;

virtual IContainerObject
  &setOpen          ( bool open = true ),
  &setClosed        ( );
virtual bool
  isOpen            ( ) const;

/*---------------------------- Object Allocation -----------------------------*/
#ifdef __DEBUG_ALLOC__
void
 *operator new    ( size_t         size,
                    const char*    fileName,
                    size_t         lineNumber );
void
 *operator new    ( size_t         size,
                    const char*    fileName,
                    size_t         lineNumber,
                    ICnrAllocator& allocator );
void
  operator delete ( void*,
                    const char*    fileName,
                    size_t         lineNumber );
#else
void
 *operator new    ( size_t         size );
void
 *operator new    ( size_t         size,
                    ICnrAllocator& allocator );
void
  operator delete ( void* );
#endif

/*--------------------- Derived Class Provided Members -----------------------*/
virtual void
  handleOpen           ( IContainerControl* container ),
  handleInuseChange    ( IContainerControl* container,
                         bool            acquired ),
  handleCursoredChange ( IContainerControl* container,
                         bool            acquired ),
  handleSelectedChange ( IContainerControl* container,
                         bool            acquired ),
  handleTreeCollapse   ( IContainerControl* container ),
  handleTreeExpand     ( IContainerControl* container );

virtual unsigned long
  helpId               ( ) const;

virtual IContainerObject
 *objectCopy           ( );

bool
  operator==           ( const IContainerObject& object );

protected:
/*------------------------------ Attributes ----------------------------------*/
virtual IContainerObject
 &setEmphasis       ( unsigned long      emphasisAttribute,
                      bool            turnOn = true,
                      IContainerControl* container = 0 ),
 &setAttributes     ( unsigned long      attributeTurnedOff,
                      unsigned long      attributeTurnedOn,
                      IContainerControl* container = 0 ),
 &incrementUseCount ( ),
 &decrementUseCount ( ),
 &setBase           ( const IMiniCnrRecord* baseRecord ),
 &initialize        ( );

IMiniCnrRecord
 *baseRecord        ( );

unsigned long
  useCount          ( ) const;

virtual bool
  isAttribute       ( unsigned long      attribute,
                      IContainerControl* container ) const;

private:
/*--------------------------------- Private ----------------------------------*/
friend class ICnrObjPrivateData;
friend class IContainerControl;
friend class ICnrControlData;
friend class IMiniCnrRecord;
friend class ICnrAllocator;
friend IMiniCnrRecord* IRecFromObj       ( const IContainerObject* pcnrobj );
friend IWindowHandle IGadgetFromObj      ( IContainerObject*,
                                           IContainerControl*,
                                           bool );
friend ContainedInElement* IContainedInElementFromObj(IContainerObject*,
                                                      IContainerControl*) ; 
#ifdef IC_PM
friend bool _System pfnDeleteObjects  ( ICnrRecord* pRecord,
                                           void*       p );
friend bool _System pfnCleanUpObjects ( ICnrRecord* pRecord,
                                           void*       thisCnr );
#endif
#ifdef IC_WIN
friend bool __stdcall pfnDeleteObjects  ( ICnrRecord* pRecord,
                                             void*       p );
friend bool __stdcall pfnCleanUpObjects ( ICnrRecord* pRecord,
                                             void*       thisCnr );
friend class INativeContainerHandler;
#endif

enum State {
  ok=1,
  opened=2,
  noInvalidate=4,
  hasDescendents=8,
  noRefresh=16,
  invalid=32,
  subclassed=64,
  deleteInProcess=128,
  nestedDelete=256
  };

IContainerObject&
  setCnrObjIcon(const IPointerHandle& ptrh) ;
unsigned long
  iconTextLength ( ) const;
static void
 *newRecord      ( size_t size ),
  deleteRecord   ( void* precord );

int
  flClState;
unsigned long
  ulClUseCount;
IContainerObject
 *pcnrobjClParent;
IMiniCnrRecord
 *pbase;

#ifdef IC_PMWIN
void
  setDelayedFree ( bool delay = true );
bool
  isDelayedFree  ( ) const;
bool
  delayFree;
#endif

ICnrObjPrivateData
 *ppd;

#ifdef IC_MOTIF
static IMiniCnrRecord*
  allocateRecords(unsigned short numRecords, long size);
#endif

}; // IContainerObject

class ICnrAllocator  {
public:
/*------------------------------- Constructors -------------------------------*/
  ICnrAllocator ( unsigned long num,
                  unsigned long size );

virtual
  ~ICnrAllocator ( );

protected:
/*---------------------------- Object Information ----------------------------*/
void
  *first           ( ) const,
  *next            ( void* pRec ),
  *nextAvailable   ( );
unsigned long
  initialized     ( ) const;
ICnrAllocator
  &updateForInsert ( );

private:
/*----------------------------- Hidden Members -------------------------------*/
ICnrAllocator ( const ICnrAllocator& aCnrAllocator );
ICnrAllocator
  &operator=   ( const ICnrAllocator& cnrAllocator );

/*--------------------------------- Private ----------------------------------*/
friend class IContainerControl;
friend class IContainerObject;
void
  *pFirst,
  *pAvailable;
unsigned long
   numInitialized;
}; // ICnrAllocator

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#include <icnrobj.inl>
#include <icnrobjn.inl>

#endif  /* _ICNROBJ_ */
