// Revision: 14 1.5.1.3 source/ui/cnr/icnrmhdr.hpp, container, ioc.v400, 980918 
#ifndef _ICNRMHDR_
#define _ICNRMHDR_
/*******************************************************************************
* FILE NAME: icnrmhdr.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     ICnrMenuHandler                                                          *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Material - Property of IBM                                        *
*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved.                   *
*                                                                              *
*******************************************************************************/
#include <imenuhdr.hpp>
#include <ievent.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IContainerObject;
class IContainerControl;

#pragma enum(4)
#pragma pack(push,4)


class ICnrMenuHandler : public IMenuHandler {
typedef IMenuHandler
  Inherited;

public:
/*-------------------------- Constructors ------------------------------------*/
virtual
 ~ICnrMenuHandler      ( );


/*---------------------------- Event Information -----------------------------*/
IContainerObject
 *popupMenuObject     ( );

/*--------------------------- Event Dispatching ------------------------------*/
virtual ICnrMenuHandler
 &handleEventsFor       ( IContainerControl* container ),
 &stopHandlingEventsFor ( IContainerControl* container );

protected:
/*---------------------------- Constructors ----------------------------------*/
  ICnrMenuHandler      ( );


/*--------------------------- Event Dispatching ------------------------------*/
virtual bool
  dispatchHandlerEvent ( IEvent& event);

#ifndef IC_MOTIF_FLAGNOP
virtual void
  addSourceEmphasis( const IMenuEvent& menuEvent ),
  removeSourceEmphasis( const IMenuEvent& menuEvent );
#endif

virtual bool
  menuEnded     ( IMenuEvent& menuEvent );

private:
/*-------------------------------- Private -----------------------------------*/
/*----------------------------- Hidden Members -------------------------------*/
virtual IHandler
 &handleEventsFor       ( IWindow* window  ),
 &stopHandlingEventsFor ( IWindow* window  );

IContainerObject
 *pcnrobjClMenu;
};

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif
