// Revision: 11 1.5.1.3 source/ui/cnr/icnrhdr.hpp, container, ioc.v400, 980918 
#ifndef _ICNRHDR_
#define _ICNRHDR_
/*******************************************************************************
* FILE NAME: icnrhdr.hpp                                                       *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     ICnrHandler                                                              *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Material - Property of IBM                                        *
*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved.                   *
*                                                                              *
*******************************************************************************/
#include <ihandler.hpp>
#include <icnrevt.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#pragma enum(4)
#pragma pack(push,4)

class ICnrHandler : public IHandler {
typedef IHandler
   Inherited;

public:
/*-------------------------- Constructors ------------------------------------*/
ICnrHandler();

virtual
 ~ICnrHandler();

/*---------------------------- Event Processing ----------------------------------*/
#ifndef IC_MOTIF_FLAGNOP
virtual bool
  deltaReached(ICnrQueryDeltaEvent& event);
#endif

virtual bool
  treeCollapsed    (IContainerObject* collapsedObject,
                    IContainerControl* container),

  treeExpanded     (IContainerObject* expandedObject,
                    IContainerControl* container),

  enter            (ICnrEnterEvent& event),
  selectedChanged  (ICnrEmphasisEvent& event);

virtual bool
  inuseChanged(ICnrEmphasisEvent& event),
  cursoredChanged(ICnrEmphasisEvent& event),
  windowScrolled(ICnrScrollEvent& event);

virtual bool
  help(ICnrHelpEvent& event);

/*--------------------------- Event Dispatching ------------------------------*/
virtual ICnrHandler
 &handleEventsFor       ( IContainerControl* container ),
 &stopHandlingEventsFor ( IContainerControl* container );

protected:
/*--------------------------- Event Dispatching ------------------------------*/
virtual bool
  dispatchHandlerEvent(IEvent& event);

private:
/*----------------------------- Private --------------------------------------*/
virtual IHandler
 &handleEventsFor       ( IWindow* window  ),
 &stopHandlingEventsFor ( IWindow* window  );

};

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif
