// Revision: 08 1.5.1.3 source/ui/cnr/icnrevt.hpp, container, ioc.v400, 980918 
#ifndef _ICNREVT_
#define _ICNREVT_
/*******************************************************************************
* FILE NAME: icnrevt.hpp                                                       *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     ICnrEvent                                                                *
*     ICnrEnterEvent                                                           *
*     ICnrEmphasisEvent                                                        *
*     ICnrHelpEvent                                                            *
*     ICnrQueryDeltaEvent                                                      *
*     ICnrScrollEvent                                                          *
*     ICnrPaintBackground                                                      *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Material - Property of IBM                                        *
*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved.                   *
*                                                                              *
*******************************************************************************/

#include <ictlevt.hpp>
#include <icnrobj.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class ICnrEnterEvent;
class ICnrEvent;
class ICnrHelpEvent;
class ICnrQueryDeltaEvent;
class IContainerObject;
class IContainerControl;
class IContainerColumn;

#pragma enum(4)
#pragma pack(push,4)

class ICnrEvent : public IControlEvent {
typedef IControlEvent
   Inherited;

public:
/*------------------------ Constructors --------------------------------------*/
  ICnrEvent      ( const IControlEvent& event);

virtual
 ~ICnrEvent      ( );

   protected:
/*--------------------------- Event Information ------------------------------*/
unsigned long
  containerId    ( ) const;

};


class ICnrEnterEvent : public ICnrEvent {
typedef ICnrEvent
   Inherited;

public:
/*------------------------ Constructors --------------------------------------*/
  ICnrEnterEvent  ( const IControlEvent& event);

virtual
 ~ICnrEnterEvent ();

/*----------------------------- Event Information ----------------------------*/
IContainerObject
 *object          ( ) const;

bool
  enterPressed    ( ) const,
  validObject     ( ) const;
};


class ICnrEmphasisEvent : public ICnrEvent {
typedef ICnrEvent
   Inherited;

public:
/*------------------------ Constructors --------------------------------------*/
  ICnrEmphasisEvent  ( const IControlEvent& event);
#ifdef IC_MOTIF
  ICnrEmphasisEvent  ( IControlEvent& event,
                       IContainerObject* object,
                       bool acquiring,
                       IContainerObject::Emphasis emphasis) ;
#endif

virtual
 ~ICnrEmphasisEvent  ( );

/*----------------------------- Event Information ----------------------------*/
bool
  changed          ( IContainerObject::Emphasis  emphasis) const;

IContainerObject
 *object           ( )  const;

#ifdef IC_MOTIF
bool
  isAcquired() const;

private:
  IContainerObject*
     pObject;
  bool
     acquired;
  IContainerObject::Emphasis
     evtEmphasis ;
#endif
};


#ifndef IC_MOTIF_FLAGNOP
class ICnrQueryDeltaEvent : public ICnrEvent {
typedef ICnrEvent
   Inherited;

public:
/*------------------------ Constructors --------------------------------------*/
  ICnrQueryDeltaEvent ( const IControlEvent& event);

virtual
 ~ICnrQueryDeltaEvent ( );

/*------------------------------ Event Information ---------------------------*/
bool
  atTopDelta       ( ) const,
  atBottomDelta    ( ) const,
  atFirstObject    ( ) const,
  atLastObject     ( ) const;
};


class ICnrScrollEvent : public ICnrEvent {
typedef ICnrEvent
   Inherited;

public:

/*------------------------ Constructors --------------------------------------*/
  ICnrScrollEvent ( const IControlEvent& event );

virtual
 ~ICnrScrollEvent ( );

/*------------------------------- Event Information --------------------------*/
long
  amount            ( ) const;
bool
  isLeftDetails     ( ) const,
  isRightDetails    ( ) const,
  isHorizontal      ( ) const,
  isVertical        ( ) const;
};
#endif


class ICnrHelpEvent : public ICnrEvent {
typedef ICnrEvent
   Inherited;

public:

/*------------------------ Constructors --------------------------------------*/
  ICnrHelpEvent ( const IControlEvent& event );

virtual
 ~ICnrHelpEvent ( );

/*------------------------------- Event Information --------------------------*/
IContainerObject
 *object       ( ) const;
IContainerColumn
 *column       ( ) const;
};

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif /* _ICNREVT_ */
