// Revision: 05 1.4.1.3 source/ui/cnr/icnrehdr.hpp, container, ioc.v400, 980918 
#ifndef _ICNREHDR_
#define _ICNREHDR_
/*******************************************************************************
* FILE NAME: icnrehdr.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     ICnrEditHandler                                                          *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Material - Property of IBM                                        *
*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved.                   *
*                                                                              *
*******************************************************************************/

#include <ihandler.hpp>
#include <icnreevt.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IHandlerWindow;
class IWindowHandle;
class IMultiLineEdit;

#pragma enum(4)
#pragma pack(push,4)

class ICnrEditHandler : public IHandler {
typedef IHandler
   Inherited;

public:
/*----------------------- Related Members ------------------------------------*/
enum StringType {
  isIString,
  isCharacterPointer
  };


/*-------------------------- Constructors ------------------------------------*/
  ICnrEditHandler    (StringType   stringType = isIString);
virtual
 ~ICnrEditHandler    ( );

/*-------------------------- Event Processing --------------------------------*/
virtual bool
  beginEdit            ( ICnrBeginEditEvent&     event),
  reallocateString     ( ICnrReallocStringEvent& event),
  endEdit              ( ICnrEndEditEvent&       event);

bool
  isDataIString        ( )  const;

/*---------------------------- Event Dispatching -----------------------------*/
virtual ICnrEditHandler
 &handleEventsFor       ( IContainerControl* container ),
 &stopHandlingEventsFor ( IContainerControl* container );


/*---------------------------- Multiple-Line Edit Processing -----------------*/
virtual void
  setMLEHandler        ( IHandler*  anMLEHandler);

#ifndef IC_MOTIF_FLAGNOP
virtual IMultiLineEdit
 *multiLineEdit        ( const IWindowHandle& handleMultiLineEdit);
#endif

IHandler
 *mleHandler           ( ) const;

protected:
/*-------------------------- Event Dispatching -------------------------------*/
virtual bool
  dispatchHandlerEvent ( IEvent& event);


private:
IHandler
 *_phdrMLE;
int _stringType;

/*--------------------------- Hidden Members ---------------------------------*/
virtual IHandler
 &handleEventsFor       ( IWindow* window  ),
 &stopHandlingEventsFor ( IWindow* window  );
};

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#include <icnrehdr.inl>

#endif
