// Revision: 03 1.4.1.3 source/ui/cnr/icnreevt.hpp, container, ioc.v400, 980918 
#ifndef _ICNREEVT_
 #define _ICNREEVT_
/*******************************************************************************
* FILE NAME: icnreevt.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     ICnrEditEvent                                                            *
*     ICnrBeginEditEvent                                                       *
*     ICnrEndEditEvent                                                         *
*     ICnrReallocStringEvent                                                   *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Material - Property of IBM                                        *
*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved.                   *
*                                                                              *
*******************************************************************************/

#include <icnrevt.hpp>
#include <istring.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IContainerObject;
class IContainerControl;
class IContainerColumn;

#pragma enum(4)
#pragma pack(push,4)

class ICnrEditEvent : public ICnrEvent {
typedef ICnrEvent
   Inherited;

public:
/*------------------------ Constructors --------------------------------------*/
  ICnrEditEvent  ( const IControlEvent& event);

virtual
 ~ICnrEditEvent  ( );

/*----------------------------- Event Information ----------------------------*/
bool
  isTitleWindow() const;
bool
  isLeftDetailsHeading() const;
bool
  isRightDetailsHeading() const;
bool
  isDetailsData() const,
  isLeftDetails() const;
bool
  isRightDetails() const;

virtual IContainerObject
 *object()  const;

virtual IContainerColumn
 *column()  const;

virtual IContainerControl
 *container()  const;

protected:
/*--------------------------------- Text -------------------------------------*/
char
 **textRef()  const;

unsigned long
 textSize()   const;

};

class ICnrReallocStringEvent : public ICnrEditEvent {
typedef ICnrEditEvent
   Inherited;

public:
/*------------------------ Constructors --------------------------------------*/
  ICnrReallocStringEvent ( const IControlEvent& event);

virtual
 ~ICnrReallocStringEvent ( );

/*----------------------------- Event Information ----------------------------*/
virtual IString
  currentText()  const,
  newText()      const;

long
  newTextSize()  const;

/*------------------------------ Text Allocation -----------------------------*/
void
  reallocateString();
void
  reallocateText();
};


class ICnrBeginEditEvent : public ICnrEditEvent {
typedef ICnrEditEvent
   Inherited;

public:

/*------------------------ Constructors --------------------------------------*/
  ICnrBeginEditEvent ( const IControlEvent& event);

virtual
 ~ICnrBeginEditEvent ( );

/*----------------------------- Event Information ----------------------------*/
IString
  currentText();
};


class ICnrEndEditEvent : public ICnrEditEvent {
typedef ICnrEditEvent
   Inherited;

public:
/*------------------------ Constructors --------------------------------------*/
  ICnrEndEditEvent ( const IControlEvent& evt);

virtual
 ~ICnrEndEditEvent ( );

/*----------------------------- Event Information ----------------------------*/
IString
  newText(),
  currentText();

private:
/*-------------------------------- Private -----------------------------------*/
friend class ICnrEditHandler;
IString
  strNewText;
};

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif
