// Revision: 01 1.3.1.3 source/ui/cnr/icnrdihd.hpp, container, ioc.v400, 980918 
#ifndef _ICNRDIHD_
#define _ICNRDIHD_
/*******************************************************************************
* FILE NAME: icnrdihd.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     ICnrDrawHandler                                                          *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Material - Property of IBM                                        *
*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved.                   *
*                                                                              *
*******************************************************************************/
#include <ihandler.hpp>
#include <icnrdiev.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IControl;
class IContainerControl;

#pragma enum(4)
#pragma pack(push,4)

#ifndef IC_MOTIF_FLAGNOP
class ICnrDrawHandler : public IHandler {
typedef IHandler
  Inherited;

public:
/*-------------------------- Constructors ------------------------------------*/
virtual
 ~ICnrDrawHandler   ( );

/*------------------------ Event Processing ----------------------------------*/
virtual bool
  drawText          ( ICnrDrawItemEvent&       event),
  drawIcon          ( ICnrDrawItemEvent&       event),
  drawTreeIcon      ( ICnrDrawItemEvent&       event),
  drawDetailsItem   ( ICnrDrawItemEvent&       event),
  drawTitle         ( ICnrDrawItemEvent&       event),
  drawBackground    ( ICnrDrawBackgroundEvent& event);


/*---------------------------- Event Dispatching -----------------------------*/
virtual ICnrDrawHandler
 &handleEventsFor       ( IContainerControl* container ),
 &stopHandlingEventsFor ( IContainerControl* container );


protected:
/*------------------------- Constructors -------------------------------------*/
  ICnrDrawHandler   ( );

/*-------------------------- Event Dispatching -------------------------------*/
virtual bool
  dispatchHandlerEvent ( IEvent& event);

private:
/*------------------------- Hidden Members -----------------------------------*/
virtual IHandler
 &handleEventsFor       ( IWindow* window  ),
 &stopHandlingEventsFor ( IWindow* window  );

};
#endif

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif
