// Revision: 99 1.3.1.3 source/ui/cnr/icnrdiev.hpp, container, ioc.v400, 980918 
#ifndef _ICNRDIEV_
#define _ICNRDIEV_
/*******************************************************************************
* FILE NAME: icnrdiev.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     ICnrDrawItemEvent                                                        *
*     ICnrDrawBackgroundEvent                                                  *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Material - Property of IBM                                        *
*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved.                   *
*                                                                              *
*******************************************************************************/

#include <idievt.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IContainerObject;
class IContainerControl;
class IContainerColumn;

#pragma enum(4)
#pragma pack(push,4)

#ifndef IC_MOTIF_FLAGNOP
class ICnrDrawItemEvent : public IDrawItemEvent {
typedef IDrawItemEvent
  Inherited;

public:
/*------------------------ Constructors --------------------------------------*/
  ICnrDrawItemEvent    ( const IEvent& event);

virtual
 ~ICnrDrawItemEvent    ( );

/*----------------------- Related Members ------------------------------------*/
enum ItemType  {
  text,
  icon,
  treeIcon,
  detailsView,
  title
  };

/*-------------------------- Event Information -------------------------------*/
virtual IContainerObject
 *object               ( ) const;
virtual IContainerControl
 *container            ( ) const;
virtual IContainerColumn
 *column               ( ) const;
virtual ItemType
  itemType             ( ) const;

virtual IPresSpaceHandle
  itemPresSpaceHandle  ( ) const;

virtual IRectangle
  itemRect             ( ) const;

};

class ICnrDrawBackgroundEvent : public IEvent {
typedef IEvent
  Inherited;
public:
/*------------------------ Constructors --------------------------------------*/
  ICnrDrawBackgroundEvent  ( const IEvent& event);

virtual
 ~ICnrDrawBackgroundEvent  ( );

/*-------------------------- Event Information -------------------------------*/
virtual IContainerControl
 *container            ( ) const;

virtual IPresSpaceHandle
  itemPresSpaceHandle  ( ) const;

virtual unsigned long
  itemId               ( ) const;

virtual IRectangle
  itemRect             ( ) const;

};
#endif

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif // _ICNRDIEV_
