// Revision: 79 1.13.1.11 source/ui/cnr/icnrctl.hpp, container, ioc.v400, 980918 
#ifndef _ICNRCTL_
#define _ICNRCTL_
/*******************************************************************************
* FILE NAME: icnrctl.hpp                                                       *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IContainerControl                                                        *
*     IContainerControl::ObjectCursor                                          *
*     IContainerControl::TextCursor                                            *
*     IContainerControl::ColumnCursor                                          *
*     IContainerControl::FilterFn                                              *
*     IContainerControl::CompareFn                                             *
*     IContainerControl::Iterator                                              *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Material - Property of IBM                                        *
*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved.                   *
*                                                                              *
*******************************************************************************/

#include <icontrol.hpp>
#include <icnrobj.hpp>
#include <irect.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IContainerControl;
class IContainerColumn;
class IResourceId;
class IPrivateResource;
class IMultiLineEdit;
class IColor;
class ICnrControlList;
class ICnrObjectSet;
class ICnrControlData;
class ICnrObjCursorData;
class ICnrTextCursorData;
class ICnrColCursorData;
struct ICnrInfo;
class ICnrRecord;
class ICnrSortPackage;

#pragma enum(4)
#pragma pack(push,4)


class IContainerControl : public IControl {
typedef IControl
  Inherited;

public:

class Style;
class Attribute;

/*-------------------------- Related Types -----------------------------------*/
enum EnumerationOrder {
  itemOrder,
  zOrder
  };

enum TitleAlignment {
  left,
  right,
  centered
  };

/*------------------------ Constructors --------------------------------------*/
  IContainerControl ( unsigned long     id,
                      IWindow*          parent,
                      IWindow*          owner,
                      const IRectangle& location  = IRectangle(),
                      const Style&      style     = defaultStyle(),
                      const Attribute&  attribute = defaultAttribute());
#ifdef IC_PMWIN
  IContainerControl ( unsigned long id,
                      IWindow*      parentDialog);

  IContainerControl ( const IWindowHandle& handle);
#endif

virtual
 ~IContainerControl ( );

/*-------------------------------- Styles ------------------------------------*/
INESTEDBITFLAGCLASSDEF2( Style, IContainerControl, IWindow, IControl);

static const Style
  IC_IMPORTU classDefaultStyle,
  IC_IMPORTU readOnly,
  IC_IMPORTU autoPosition,
  IC_IMPORTU extendedSelection,
  IC_IMPORTU singleSelection,
  IC_IMPORTU multipleSelection,
  IC_IMPORTU verifyPointers,
#ifndef IC_MOTIF_FLAGNOP
  IC_IMPORTU pmCompatible,
#endif
  IC_IMPORTU noSharedObjects ;

static Style
  defaultStyle      ( );
static void
  setDefaultStyle   ( const Style&    style );

virtual unsigned long
  convertToGUIStyle ( const IBitFlag& style,
                      bool         extendedOnly = false ) const;

bool
  isPMCompatible    ( ) const;

/*-------------------------------- Attributes -------------------------------*/
INESTEDBITFLAGCLASSDEF0( Attribute, IContainerControl);

static const Attribute
  IC_IMPORTU textView,
  IC_IMPORTU iconView,
  IC_IMPORTU nameView,
  IC_IMPORTU detailsView,
  IC_IMPORTU treeView,
  IC_IMPORTU flowedView,
  IC_IMPORTU miniIcons,
  IC_IMPORTU readOnlyTitle,
  IC_IMPORTU titleSeparator,
  IC_IMPORTU detailsViewTitles,
  IC_IMPORTU visibleTitle,
  IC_IMPORTU alignTitleCentered,
  IC_IMPORTU alignTitleLeft,
  IC_IMPORTU alignTitleRight,
#ifndef IC_MOTIF_FLAGNOP
  IC_IMPORTU handleDrawItem,
  IC_IMPORTU handleDrawBackground,
#endif
  IC_IMPORTU orderedTargetEmphasis,
  IC_IMPORTU mixedTargetEmphasis,
  IC_IMPORTU visibleTreeLine,
  IC_IMPORTU classDefaultAttribute;

static Attribute
  defaultAttribute    ( );
static void
  setDefaultAttribute ( const  Attribute& attribute);

#ifdef IC_MOTIF
virtual IWindowHandle
  handleForChildCreation( ) const;
#endif


/*------------------------ Comparison ----------------------------------------*/
bool
  operator==( const IContainerControl& container);

/*------------------------ Initialization ------------------------------------*/
static void
     initialize ( );


class FilterFn {
public:
/*------------------------ Constructors -----------------------------------*/
  FilterFn ( );

virtual
 ~FilterFn ( );

/*------------------------ Object Filtering -------------------------------*/
virtual bool
  isMemberOf  ( IContainerObject* object,
                IContainerControl* container) const = 0;

};  /* end FilterFn */


class CompareFn  {
public:
/*------------------------ Constructors -----------------------------------*/
  CompareFn  ( );

virtual
 ~CompareFn  ( );

/*------------------------ Object Sorting ---------------------------------*/
virtual int
  isEqual     ( IContainerObject* object1,
                IContainerObject* object2,
                IContainerControl* container) const = 0;

};  /* end CompareFn */


class ObjectCursor  {
public:
/*------------------------ Constructors -----------------------------------*/
  ObjectCursor ( const IContainerControl&   container,
                 IContainerObject::Emphasis emphasis    = IContainerObject::none,
                 EnumerationOrder           enumeration = itemOrder);

  ObjectCursor ( const IContainerControl& container,
                 const IContainerObject*  parentObject,
                 bool                  allDescendents = false);

virtual
 ~ObjectCursor ( );

/*------------------------ Cursor Movement --------------------------------*/
virtual  bool
  setToFirst    ( ),
  setToNext     ( ),
  setToLast     ( ),
  setToPrevious ( );

/*------------------------ Object Retrieval -------------------------------*/
virtual IContainerObject
 *first       ( ),
 *next        ( ),
 *previous    ( ),
 *last        ( ),
 *current     ( ) const;

virtual ObjectCursor
 &setCurrent  ( const IContainerObject* currentObject);

/*------------------------ Cursor Validation ------------------------------*/
virtual  bool
  isValid       ( ) const;
virtual ObjectCursor
 &invalidate    ( );

private:

friend class INativeContainerHandler;

IContainerObject
 *object          ( const IContainerObject* objectAfter,
                    unsigned long           command),
 *selectedObject  ( const IContainerObject* objectAfter,
                    unsigned long           emphasis),
 *lastObject      ( const IContainerObject* objectAfter = 0),
 *previousObject  ( const IContainerObject* objectBefore),
 *nextObject      ( const IContainerObject* objectAfter),
 *nextBranchObject( const IContainerObject* objectAfter);

enum State {
  all=1,
  child=2,
  emphasis=4,
  allSubTree=8
  };


IContainerObject
 *pcnrobjClCurrent,
 *pcnrobjClParent;
unsigned long
  ulClChanges;
IContainerControl
 *pcnrctlClOwner;
unsigned long
  flClEmphasis;
unsigned long
  flClEnumeration;
unsigned long
  flClState;
#ifdef IC_PMWIN
unsigned long
  currentIndex;
#endif
ICnrObjCursorData
  *objectCursorData;
};  /* end ObjectCursor */


class TextCursor  {
public:
/*------------------------ Constructors -----------------------------------*/
  TextCursor ( const IContainerControl& container,
               const char*              text,
               bool                  isCaseSensitive = true,
               bool                  isFirstInRecord = false,
               bool                  isExactMatch = false );

virtual
 ~TextCursor ( );

/*------------------------ Cursor Movement --------------------------------*/
virtual  bool
  setToFirst    ( ),
  setToNext     ( ),
  setToLast     ( ),
  setToPrevious ( );

/*------------------------ Object Retrieval -------------------------------*/
virtual IContainerObject
  *first       ( ),
  *next        ( ),
  *previous    ( ),
  *last        ( ),
  *current     ( ) const;

virtual TextCursor
 &setCurrent   ( const IContainerObject* currentObject);

/*------------------------ Cursor Validation ------------------------------*/
virtual  bool
  isValid      ( ) const;
virtual TextCursor
 &invalidate   ( );

private:
IContainerObject
 *find( unsigned long     view,
        IContainerObject* objectAfter,
        const char*       text,
        bool           caseSensitive,
        bool           firstInRecord);
IContainerObject
 *pcnrobjClCurrent,
 *pcnrobjClParent;
unsigned long
  ulClView;
unsigned long
  ulClChanges;
IContainerControl
 *pcnrctlClOwner;
IString
  strClSearchString;
bool
  fClIsCaseSensitive,
  fClIsFirstInRecord,
  fClIsExactMatch;
ICnrTextCursorData
  *textCursorData;
};  /* end TextCursor */


class ColumnCursor {
public:
/*------------------------ Constructors -----------------------------------*/
  ColumnCursor  ( const IContainerControl& container,
                  bool                  visibleOnly = false );

virtual
 ~ColumnCursor  ( );

/*------------------------ Cursor Movement --------------------------------*/
virtual  bool
  setToFirst     ( ),
  setToNext      ( ),
  setToLast      ( ),
  setToPrevious  ( );

/*------------------------ Column Retrieval -------------------------------*/
virtual IContainerColumn
 *first        ( ),
 *next         ( ),
 *previous     ( ),
 *last         ( ),
 *current      ( ) const;

virtual ColumnCursor
 &setCurrent   ( const IContainerColumn* currentColumn);

/*------------------------ Cursor Validation ------------------------------*/
virtual  bool
  isValid     ( ) const;
virtual ColumnCursor
 &invalidate  ( );

private:
IContainerColumn
  *pcnrcolClCurrent;
unsigned long
  ulClChanges;
IContainerControl
  *pcnrctlClOwner;
bool
  fClVisible;
ICnrColCursorData
  *colCursorData;
};  /* end ColumnCursor */


class Iterator {
public:
/*------------------------ Constructors ------------------------------------*/
  Iterator    ( );

virtual
 ~Iterator    ( );

/*------------------------ Filter Behavior --------------------------------*/
virtual bool
  applyTo     ( IContainerObject* object ) = 0;

};  /* end Iterator */



/*-------------------------------- Appearance --------------------------------*/
virtual IContainerControl
 &setTitle                 ( const char*        title),
 &setTitle                 ( const IResourceId& resourceId),
 &setTitleAlignment        ( TitleAlignment     alignment = centered),
 &showTitle                ( bool            show = true),
 &hideTitle                ( );
virtual IContainerControl
 &enableTitleUpdate        ( bool            enable = true),
 &disableTitleUpdate       ( );
virtual IContainerControl
 &showTitleSeparator       ( bool            show = true),
 &hideTitleSeparator       ( );

virtual IContainerControl
 &showDetailsViewTitles    ( bool            show = true),
 &hideDetailsViewTitles    ( );

virtual IContainerControl
 &setLineSpacing           ( long               lineSpacing),
 &setIconSize              ( const ISize&       iconSize);

virtual IContainerControl
 &setSingleSelection       ( ),
 &setMultipleSelection     ( ),
 &setExtendedSelection     ( );

#ifndef IC_MOTIFWIN_FLAGNOP
virtual IContainerControl
 &setNormalTargetEmphasis  ( ),
 &setOrderedTargetEmphasis ( ),
 &setMixedTargetEmphasis   ( );
#endif

virtual IString
   title                   ( ) const;

bool
  isTitleVisible               ( ) const,
  isTitleSeparatorVisible      ( ) const,
  isTitleWriteable             ( ) const,
  areDetailsViewTitlesVisible  ( ) const,
  hasNormalTargetEmphasis      ( ) const,
  hasOrderedTargetEmphasis     ( ) const,
  hasMixedTargetEmphasis       ( ) const;

long
  lineSpacing              ( ) const;

ISize
  iconSize                 ( ) const;

IRectangle
  titleRectangle           ( ) const;

bool
  isSingleSelection        ( ) const,
  isMultipleSelection      ( ) const,
  isExtendedSelection      ( ) const;

/*-------------------------- Automatic Deletion Behavior --------------------*/
virtual IContainerControl
 &setDeleteObjectsOnClose  ( bool            destroy = true),
 &setDeleteColumnsOnClose  ( bool            destroy = true);

bool
  willDeleteObjectsOnClose ( ) const,
  willDeleteColumnsOnClose ( ) const;



/*-------------------- Changing Views ----------------------------------------*/
virtual IContainerControl
 &showTextView             ( ),
 &showFlowedTextView       ( ),
 &showNameView             ( ),
 &showFlowedNameView       ( ),
 &showDetailsView          ( ),
 &showTreeIconView         ( ),
 &showTreeTextView         ( ),
 &showTreeNameView         ( ),
 &showIconView             ( );
virtual IContainerControl
 &arrangeIconView          ( );
virtual IContainerControl
 &showMiniIcons            ( bool  mini=true );

/*-------------- Determining the View ----------------------------------------*/
bool
  isTextView       ( bool textOnly=false ) const,
  isNameView       ( bool nameOnly=false ) const,
  isIconView       ( bool iconOnly=false ) const,
  isDetailsView    ( ) const,
  isTreeView       ( ) const,
  isFlowedTextView ( ) const,
  isFlowedNameView ( ) const,
  isTreeIconView   ( ) const,
  isTreeTextView   ( ) const,
  isTreeNameView   ( ) const,
  isFlowed         ( ) const;

bool
  isShowingMiniIcons ( ) const;

/*-------------------- Container Refresh -------------------------------------*/
virtual IContainerControl
 &setRefreshOn           ( bool on = true),
 &setRefreshOff          ( ),
 &refresh                ( bool immediate=false );

static void
  refreshAllContainers   ( bool immediate=false );

bool
  isRefreshOn            ( ) const;

/*-------------- Querying the View Port Rectangle ----------------------------*/
IRectangle
  viewPortOnWorkspace         ( ) const,
  viewPortOnWindow            ( ) const,
  detailsViewPortOnWorkspace  ( bool rightSide = false) const,
  detailsViewPortOnWindow     ( bool rightSide = false) const;

/*------------------- Container Scrolling ------------------------------------*/
virtual IContainerControl
 &scrollVertically           ( long     pixels),
 &scrollHorizontally         ( long     pixels,
                               bool  rightSide = false),
 &scroll                     ( long     vericalPixels,
                               long     horizontalPixels,
                               bool  rightSide = false),
 &scrollDetailsHorizontally  ( long     horizontalPixels,
                               bool  rightSide = false),

 &scrollToObject             ( const IContainerObject* object),
 &scrollToObject             ( const IContainerObject* object,
                               const IContainerColumn* column,
                               bool                 leftJustify = true );

/*------------------- Tree View Functions ------------------------------------*/
virtual IContainerControl
 &showTreeLine            ( long   treeLinePixelWidth = -1),
 &hideTreeLine            ( ),
 &setTreeExpandIconSize   ( const  ISize&         sizeIcon),
 &setTreeViewIndent       ( long                  indentPixels = -1),
 &setTreeItemIcons        ( const IPointerHandle& expanded,
                            const IPointerHandle& collapsed),
 &setTreeItemIcons        ( const IResourceId&    expanded,
                            const IResourceId&    collapsed);

virtual IContainerControl
 &collapseTree            ( ),
 &expandTree              ( );

/*------------------- Details View Functions ---------------------------------*/
#ifndef IC_MOTIFWIN_FLAGNOP
virtual IContainerControl
 &showSplitBar        ( bool showSplitBar=true),
 &hideSplitBar        ( ),
 &setDetailsViewSplit ( const IContainerColumn* lastColumnBeforeSplit,
                        unsigned long           pixelsFromLeft=50);
#endif
bool
  isColumnRight      ( const IContainerColumn* column) const;

virtual IContainerControl
 &addColumn          ( const IContainerColumn*          column,
                       const IContainerColumn*          afterColumn=0),
 &removeColumn       ( const IContainerColumn*          column),
 &removeColumnAt     ( IContainerControl::ColumnCursor& cursor);

IContainerColumn
 *columnAt           ( unsigned long       index) const,
 *columnAt           ( const ColumnCursor& cursor) const;

#ifndef IC_MOTIFWIN_FLAGNOP
IContainerColumn
 *detailsViewSplit   ( ) const;
#endif

unsigned long
    columnCount      ( ) const;

#ifndef IC_MOTIF_FLAGNOP
unsigned long
    splitBarOffset   ( ) const;
#endif

IRectangle
  detailsTitleRectangle  ( bool rightSide = false ) const;

/*------------------- Adding and Removing Objects ----------------------------*/
virtual IContainerControl
 &addObjects            ( ICnrAllocator&          allocator,
                          IContainerObject*       parentObject = 0),
 &addObjectsAfter       ( ICnrAllocator&          allocator,
                          const IContainerObject* afterObject,
                          IContainerObject*       parentObject = 0);

virtual IContainerControl
 &addObject             ( const IContainerObject* newObject,
                          IContainerObject*       parentObject = 0),
 &addObjectAfter        ( const IContainerObject* newObject,
                          const IContainerObject* afterObject,
                                IContainerObject* parentObject = 0);

virtual IContainerControl
 &removeObject          ( IContainerObject*                object,
                          bool                          allContainers = false),
 &removeObjectAt        ( IContainerControl::ObjectCursor& cursor),
 &removeObjectAt        ( IContainerControl::TextCursor&   cursor),
 &removeSelectedObjects ( ),
 &removeAllObjects      ( ),
 &deleteSelectedObjects ( ),
 &deleteAllObjects      ( );

/*----------------- Moving and Copying Subtrees ------------------------------*/
virtual bool
  isMoveValid    ( IContainerObject*  moveObject,
                   IContainerObject*  newParentObject = 0,
                   IContainerControl* newContainer = 0,
                   IContainerObject*  afterObject = 0);
virtual bool
  moveObjectTo   ( IContainerObject*  moveObject,
                   IContainerObject*  newParentObject = 0,
                   IContainerControl* newContainer = 0,
                   IContainerObject*  afterObject = 0,
                   const IPoint&      iconViewLocation = IPoint(0,0));
virtual IContainerObject
 *copyObjectTo   ( IContainerObject*  copyObject,
                   IContainerObject*  parentObject = 0,
                   IContainerControl* newContainer = 0,
                   IContainerObject*  afterObject =0,
                   const IPoint&      iconViewLocation = IPoint(0,0));


/*-------------------- Retrieving Objects ------------------------------------*/
virtual IContainerObject
 *objectAt           ( unsigned long                          index) const,
 *objectAt           ( const IContainerControl::ObjectCursor& cursor) const,
 *objectAt           ( const IContainerControl::TextCursor&   cursor) const,
 *parentObject       ( const IContainerObject*                childObject) const;


ICnrObjectSet
  descendentsOf           ( IContainerObject* parentObject) const,
  immediateDescendentsOf  ( IContainerObject* parentObject) const,
  objectList              ( ) const;


unsigned long
  objectCount             ( ) const;

bool
   containsObject( const IContainerObject* object) const;

virtual IContainerObject
 *cursoredObject          ( ) const;

/*------------------ Setting Object Attributes -------------------------------*/
virtual IContainerControl
 &setSelected           ( IContainerObject* object,
                           bool          select = true),
 &removeSelected        ( IContainerObject* object);

#ifndef IC_MOTIF_FLAGNOP
virtual IContainerControl
 &showSourceEmphasis    ( bool           source = true),
 &showSourceEmphasis    ( IContainerObject* object,
                          bool           source = true),
 &hideSourceEmphasis    ( ),
 &hideSourceEmphasis    ( IContainerObject* object),
#endif
 &setInUse              ( IContainerObject* object,
                          bool           inUse = true),
 &removeInUse           ( IContainerObject* object),
 &setCursor             ( IContainerObject* object);
virtual IContainerControl
 &enableDataUpdate      ( IContainerObject* object,
                          bool           enable=true),
 &disableDataUpdate     ( IContainerObject* object),
 &expand                ( IContainerObject* object),
 &collapse              ( IContainerObject* object),
 &refresh               ( IContainerObject* object,
                          bool immediate=false) ;
#ifndef IC_MOTIF_FLAGNOP
virtual IContainerControl
 &enableDrop            ( IContainerObject* object,
                          bool           enable=true);
#endif

virtual IContainerControl
 &showObject            ( IContainerObject* object,
                          bool           visible=true),
 &hideObject            ( IContainerObject* object);

#ifndef IC_MOTIF_FLAGNOP
virtual IContainerControl
 &disableDrop           ( IContainerObject* object);
#endif

/*------------------ Querying Object Attributes ------------------------------*/
bool
  isTarget         ( const IContainerObject* object) const,
  isSource         ( const IContainerObject* object) const;

bool
  isSelected       ( const IContainerObject* object) const;

bool
  isInUse          ( const IContainerObject* object) const,
  isCursored       ( const IContainerObject* object) const,
  isVisible        ( const IContainerObject* object) const;
bool
  isExpanded       ( const IContainerObject* object) const,
  isCollapsed      ( const IContainerObject* object) const,
  isWriteable      ( const IContainerObject* object) const;
#ifndef IC_MOTIF_FLAGNOP
bool
  isDropOnAble     ( const IContainerObject* object) const;
#endif

/*------------------ Object Position -----------------------------------------*/
virtual IContainerControl
 &moveIconTo               ( IContainerObject* object,
                             const IPoint&     point);

IRectangle
  iconRectangle            ( const IContainerObject* object,
                             bool                 includeText = false) const,
  detailsObjectRectangle   ( const IContainerObject* object,
                             bool                 rightWindow = false ) const,
  detailsObjectRectangle   ( const IContainerObject* object,
                             const IContainerColumn* column) const,
  textRectangle            ( const IContainerObject* object) const,
  convertToWorkspace       ( const IRectangle&       windowRectangle,
                             bool                 rightWindow = false) const;

IContainerObject
 *objectUnderPoint         ( const IPoint& point) const;

IContainerColumn
 *columnUnderPoint         ( const IPoint& point) const;

/*------------------------ Sorting Objects -----------------------------------*/
virtual IContainerControl
 &sortByIconText    ( bool                             ascending = true),
 &sort              ( const IContainerControl::CompareFn& sortObject);

static long
  nlsCompare        ( const char* text1,
                      const char* text2) ;

/*------------------------ Filtering Objects ---------------------------------*/
virtual IContainerControl
 &filter            ( ),
 &filter            ( const IContainerControl::FilterFn& filterObject);

/*------------------------ Iterating Objects ---------------------------------*/
virtual IContainerControl
 &allObjectsDo      ( IContainerControl::Iterator& iteratorObject,
                      bool                      includeDescendents = false);

/*------------------------ Direct Editing ------------------------------------*/
virtual IContainerControl
 &editContainerTitle         ( );
virtual IContainerControl
 &editColumnTitle            ( IContainerColumn* column),
 &editObject                 ( IContainerObject* object,
                               IContainerColumn* column=0),
 &closeEdit                  ( );
virtual IContainerControl
 &setEditMLE                 ( IMultiLineEdit*   editField);
virtual IContainerControl
 &setEditColumn              ( IContainerColumn* column),
 &setEditObject              ( IContainerObject* object);

IMultiLineEdit
 *currentEditMLE             ( )  const;
IContainerColumn
 *currentEditColumn          ( )  const;
IContainerObject
 *currentEditObject          ( )  const;


/*------------------------ Miscellaneous -------------------------------------*/
#ifndef IC_MOTIF_FLAGNOP
virtual IContainerControl
 &enableCaching            ( unsigned long deltaValue = 30),
 &disableCaching           ( ),
 &enableDrawItem           ( bool enable=true),
 &disableDrawItem          ( ),
 &enableDrawBackground     ( bool enable=true),
 &disableDrawBackground    ( );
#endif

bool
  isCachingEnabled         ( ) const,
  isDrawItemEnabled        ( ) const,
  isDrawBackgroundEnabled  ( ) const;

static IContainerControl
 *containerFromHandle      ( const IWindowHandle& handle);

unsigned long
  numberOfObjectChanges    ( ) const,
  numberOfColumnChanges    ( ) const;

/*-------------------------------- Overrides ---------------------------------*/
virtual IContainerControl
 &refresh ( const IRectangle& invalidRectangle,
            bool           immediate ),
 &refresh ( IWindow::RefreshType type );

virtual bool
  isVisible               ( ) const;

#ifdef IC_WIN
virtual IColor
  foregroundColor              ( ) const,
  backgroundColor              ( ) const;

virtual IContainerControl
 &resetForegroundColor         ( ),
 &resetBackgroundColor         ( );

virtual IContainerControl
  &setForegroundColor    ( const IColor &color );
#endif  //IC_WIN

#ifdef IC_MOTIFWIN
virtual IContainerControl
  &setBackgroundColor    ( const IColor &color );
#endif  // IC_MOTIFWIN

#ifdef IC_MOTIF
virtual IEventResult
  sendEvent ( unsigned long           eventId,
              const IEventParameter1& parameter1 = 0,
              const IEventParameter2& parameter2 = 0 ) const,
  sendEvent ( const IEvent&           event )     const,
  sendEvent ( EventType               eventType,
              const IEventParameter1& parameter1 = 0,
              const IEventParameter2& parameter2 = 0 ) const;
#endif

/*----------------------- Notification Members -------------------------------*/
static INotificationId const
  IC_IMPORTU addId,
  IC_IMPORTU removeId,
  IC_IMPORTU selectId,
  IC_IMPORTU enterId,
  IC_IMPORTU titleId,
  IC_IMPORTU titleVisibleId,
  IC_IMPORTU detailsViewTitlesId;

virtual IContainerControl
 &enableNotification ( bool enable=true );


protected:
/*----------------------------- Implementation -------------------------------*/
virtual void
  setContainerAttributes    ( unsigned long     attributeToTurnOff,
                              unsigned long     attributeToTurnOn),
  setEmphasis               ( IContainerObject* object,
                              unsigned long     emphasisAttribute,
                              bool           setOn=true),
  setAttributes             ( IContainerObject* object,
                              unsigned long     attributeToTurnOn,
                              unsigned long     attributeToTurnOff);

unsigned long
  containerAttributes       ( ) const,
  attributes                ( const IContainerObject* object) const;

IContainerColumn
 *column                    ( IContainerColumn* column,
                              unsigned long     command,
                              bool           visible);

virtual unsigned long
  baseRecordSize            ( );

static IWindowHandle
  hwndAllocation            ( );
static ICnrControlList
 &containerList             ( );
static IPrivateResource
 &containerKey              ( );

virtual ISize
 calcMinimumSize            ( ) const;

#ifdef IC_WIN
/*------------------------- Drag and Drop ------------------------------------*/
virtual bool
  isDragStarting      ( IEvent& event );
#endif

#ifdef IC_MOTIFWIN
virtual IContainerControl
 &setColor         ( unsigned long colorArea,
                     const IColor& color );
#endif

private:
/*------------------------------- Hidden Functions ---------------------------*/
IContainerControl     ( const IContainerControl& container );
IContainerControl
 &operator=           ( const IContainerControl& container );

/*--------------------------------- Private ----------------------------------*/
enum State {
  ok=1,
  noRefresh=2,
  invalidFrame=4,
  autoDeleteObjects=8,
  autoDeleteColumns=16,
  needsRefresh=32
  };

friend class IContainerColumn;
friend class IContainerControl::ColumnCursor;
friend class IContainerControl::ObjectCursor;
friend class IContainerObject;
friend class ICnrEditHandler;
friend class ICnrDestroyHandler;
friend class IContainerControlNotifyHandler;
friend class ICnrControlData;
friend class ICnrObjPrivateData;
friend class ICnrAllocator;
#ifdef IC_MOTIF
friend class ICnrHandler;
friend class ICnrDirectEdit;
friend class IMultiLineEdit;
#endif
#ifdef IC_PM
friend long _System IContainerControl__compare(
                                         const IMiniCnrRecord* pcnrrec1,
                                         const IMiniCnrRecord* pcnrrec2,
                                         ICnrSortPackage*      pSortPackage);

friend bool _System pfnCleanUpObjects(ICnrRecord* pRecord,
                                         void* thisCnr);
#endif
#ifdef IC_WIN
friend class INativeContainerHandler;
friend class IDetailsEditHandler;
friend class IMessageHandler;
friend class IColumnSet;

friend long __stdcall IContainerControl__compare(
                                           const IMiniCnrRecord* pcnrrec1,
                                           const IMiniCnrRecord* pcnrrec2,
                                           ICnrSortPackage*      pSortPackage);

friend bool __stdcall pfnCleanUpObjects(ICnrRecord* pRecord,
                                           void* thisCnr);
#endif

void
  addContainer        ( ),
  showView            ( unsigned long     viewFlags),
  collectDescendents  ( ICnrObjectSet&    containerSet,
                        IContainerObject* object) const,
  addDefaultHandler   ( ),
  removeDefaultHandler( );

IContainerObject
 *findFirst           ( unsigned long view,
                        const char*   text,
                        bool       isCaseSensitive = false,
                        bool       isFirstInRecord = false ) const,
 *selectedObject      ( const IContainerObject* objectAfter,
                        unsigned long           emphasis ) const,
 *object              ( const IContainerObject* objectAfter,
                        unsigned long           command ) const;


IRectangle
  viewport            ( unsigned long coordinateSpace,
                        bool       rightSplitWindow) const;

static ICnrDestroyHandler
 &destroyHandler         ( );
static void
  setAllocationContainer ( unsigned long handle);

void
  cleanUp();

long
  removeRecords(void* prec, unsigned short number, unsigned short cmd);

void
#ifdef IC_MOTIF
     containerInfo       ( ) const,
#endif

     containerInfo       ( ICnrInfo* pCnrInfo ) const,
     setContainerInfo    ( ICnrInfo* pCnrInfo, unsigned long flags ),

     setDefaultContainer ( const Attribute& attribute );

#ifdef IC_MOTIF
ICnrInfo
  *pcnrinfoCl;
#endif

IString
  strContainerTitle;

IContainerColumn
 *pcnrcolClSplitbar;

IContainerColumn
 *pcnrcolClEdit;
IContainerObject
 *pcnrobjClEdit,
 *pcnrobjClSingleSelectionNotification;
IMultiLineEdit
 *pmleClEdit;

bool
  fClInvalidate;
int
  lClSplitbar,
  flClState;
unsigned long
  ulClDragEvent;
IBitmapHandle
  hbmClIconViewBackground;
unsigned long
  ulClObjectChanges;
unsigned long
  ulClColumnChanges;
#ifdef IC_MOTIF
static const Attribute
  miniView;
#endif

static Attribute
  currentDefaultAttribute;
static Style
  currentDefaultStyle;

ICnrControlData
 *ppd;

#ifdef IC_WIN
static int ListViewFindItem(const IWindowHandle& handle,
                            int start, void* lvFindInfo);
#endif
};  /* end IContainerControl */



INESTEDBITFLAGCLASSFUNCS(Style, IContainerControl);

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#include <icnrctl.inl>


#endif  /* _ICNRCTL_ */
