// Revision: 77 1.8.1.3 source/ui/cnr/icnrcol.hpp, container, ioc.v400, 980918 
#ifndef _ICNRCOL_
#define _ICNRCOL_
/*******************************************************************************
* FILE NAME: icnrcol.hpp                                                       *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IContainerColumn                                                         *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Material - Property of IBM                                        *
*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved.                   *
*                                                                              *
*******************************************************************************/

#include <ibase.hpp>
#include <ihandle.hpp>
#include <iuipl.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IContainerWindow;
class IContainerControl;
class IContainerObject;
class IResourceId;
class IString;
class IDate;
class ITime;
class ICnrColumnData;
class ICnrControlData;
struct _FIELDINFO;

#pragma enum(4)
#pragma pack(push,4)

#define ICONTAINERCOLUMN_OFFSETOF(s_name, s_member) (size_t)&(((s_name *)0)->s_member)

class IContainerColumn {
public:
/*---------------------------------- Styles ----------------------------------*/
typedef unsigned long
  Style;

static const Style
  IC_IMPORTU string,
  IC_IMPORTU icon,
  IC_IMPORTU alignTop,
  IC_IMPORTU alignBottom,
  IC_IMPORTU alignVerticallyCentered,
  IC_IMPORTU alignLeft,
  IC_IMPORTU alignRight,
  IC_IMPORTU alignCentered;

/*------------------------------ Heading Style -------------------------------*/
typedef unsigned long
  HeadingStyle;

static const HeadingStyle
  IC_IMPORTU readOnlyHeading,
  IC_IMPORTU classDefaultHeadingStyle;

static Style
  defaultHeadingStyle    ( );

static void
  setDefaultHeadingStyle ( const HeadingStyle& headingStyle );

/*-------------------------------- Data Style --------------------------------*/
typedef unsigned long
  DataStyle;

static const DataStyle
  IC_IMPORTU date,
  IC_IMPORTU time,
  IC_IMPORTU number,
  IC_IMPORTU horizontalSeparator,
  IC_IMPORTU verticalSeparator,
  IC_IMPORTU handleDrawItem,
  IC_IMPORTU readOnly,
  IC_IMPORTU invisible,
  IC_IMPORTU classDefaultDataStyle;

static Style
  defaultDataStyle    ( );
static void
  setDefaultDataStyle ( const DataStyle& dataStyle );

/*------------------------------ Related Members -----------------------------*/
enum DataSource {
  isIcon,
  isIconViewText
  };

enum VerticalAlignment {
  top,
  bottom,
  centeredVertically
  };

enum HorizontalAlignment {
  left,
  right,
  centered
  };

/*------------------------------- Constructors -------------------------------*/
  IContainerColumn ( unsigned long       dataOffset,
                     const HeadingStyle& title = defaultHeadingStyle(),
                     const DataStyle&    data = defaultDataStyle() );

  IContainerColumn ( DataSource          objectDataType,
                     const HeadingStyle& title = defaultHeadingStyle(),
                     const DataStyle&    data = defaultDataStyle() );

  IContainerColumn ( const IContainerColumn& column);

virtual
 ~IContainerColumn ( );

/*----------------------------- Object Information ---------------------------*/
virtual IContainerColumn
 &setHeadingText       ( const char*           text ),
 &setHeadingText       ( const IResourceId&    textId );

#ifndef IC_MOTIFWIN_FLAGNOP
virtual IContainerColumn
 &setHeadingIcon       ( const IPointerHandle& iconHandle ),
 &setHeadingIcon       ( const IResourceId&    iconId ),
 &setHeadingIcon       ( unsigned long         iconId );
#endif

virtual IString
  headingText          ( ) const;

virtual IPointerHandle
  headingIcon          ( ) const;

virtual IContainerColumn
 &enableHeadingUpdate  ( bool enable = true ),
 &disableHeadingUpdate ( ),
 &enableDataUpdate     ( bool enable = true ),
 &disableDataUpdate    ( );

virtual IContainerColumn
 &show                 ( bool visible = true ),
 &hide();

#ifndef IC_MOTIF_FLAGNOP
virtual IContainerColumn
 &showSeparators       ( const DataStyle& separatorStyles =
                           horizontalSeparator | verticalSeparator ),
 &hideSeparators       ( const DataStyle& separatorStyles =
                           horizontalSeparator | verticalSeparator );
#endif

virtual IContainerColumn
 &justifyData          ( VerticalAlignment   = centeredVertically,
                         HorizontalAlignment = centered ),
 &justifyHeading       ( VerticalAlignment   = centeredVertically,
                         HorizontalAlignment = centered );

virtual IContainerColumn
 &setDisplayWidth     ( unsigned long widthInPixels );

virtual unsigned long
  displayWidth        ( );

virtual IContainerColumn
 &setDataOffset       ( unsigned long dataOffset ),
 &setHelpId           ( unsigned long helpId );

unsigned long
  helpId              ( ) const;

bool
 isVisible              ( ) const,
 isDate                 ( ) const,
 isTime                 ( ) const,
 isNumber               ( ) const,
 isString               ( ) const,
 isIconHandle           ( ) const,
 isWriteable            ( ) const,
 isHeadingWriteable     ( ) const,
 isHeadingString        ( ) const,
 isHeadingIconHandle    ( ) const,
 hasHorizontalSeparator ( ) const,
 hasVerticalSeparator   ( ) const;


#ifndef IC_MOTIF_FLAGNOP
VerticalAlignment
  verticalDataAlignment      ( ) const,
  verticalHeadingAlignment   ( ) const;
#endif
HorizontalAlignment
  horizontalDataAlignment    ( ) const,
  horizontalHeadingAlignment ( ) const;

/*---------------------------Data Retrieval ----------------------------------*/
unsigned long
  dataAsNumber ( const IContainerObject* object ) const;
IString
  dataAsString ( const IContainerObject* object ) const;
IDate
  dataAsDate   ( const IContainerObject* object ) const;
ITime
  dataAsTime   ( const IContainerObject* object ) const;
IPointerHandle
  dataAsIcon   ( const IContainerObject* object ) const;

protected:
/*----------------------------- Object Attributes ----------------------------*/
virtual IContainerColumn
 &setTitleAttributes ( unsigned long  titleAttributes ),
 &setDataAttributes  ( unsigned long  dataAttributes );

virtual unsigned long
  titleAttributes    ( ) const,
  dataAttributes     ( ) const;

_FIELDINFO
 *columnInfo         ( ) const;

IContainerControl
 *container          ( ) const;

IContainerColumn
 &setContainer       ( IContainerControl* container ),
 &setColumnInfo      ( _FIELDINFO*        fieldinfo ),
 &invalidate         ( );

private:
/*--------------------------------- Private ----------------------------------*/
friend class IContainerControl;
friend class ICnrControlData;
#ifdef IC_WIN
friend class INativeContainerHandler;
friend class IColumnSet;
friend class IDetailsEditHandler;
#endif

const char*
  headingTextRef ( ) const;
_FIELDINFO
 *pfieldinfoCl;

IContainerControl
 *pcnrctlCl;
IPointerHandle
  ptrhCl;
static Style
  currentDefaultHeadingStyle,
  currentDefaultDataStyle;
unsigned long
  ulHelpId;
ICnrColumnData
 *columnData;

}; // IContainerColumn

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#include <icnrcol.inl>

#endif
