// Revision: 75 1.7.1.3 source/ui/cnr/icnrclst.hpp, container, ioc.v400, 980918 
#ifndef _ICNRCLST_
#define _ICNRCLST_
/*******************************************************************************
* FILE NAME: icnrclst.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     ICnrControlList                                                          *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Material - Property of IBM                                        *
*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved.                   *
*                                                                              *
*******************************************************************************/
#include <ilanglvl.hpp>
#include <iuipl.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IContainerControl;
class ICnrControlListImp;

#pragma enum(4)
#pragma pack(push,4)

class ICnrControlList
{
public:

/*------------------------ Constructors --------------------------------------*/
  ICnrControlList  ();
  ICnrControlList  (const ICnrControlList&);
  ~ICnrControlList( );


   class Cursor
   {
   public:
     Cursor (const ICnrControlList& controlList);
    ~Cursor ( );

     bool
       setToFirst    ( ),
       setToNext     ( ),
       isValid       ( ) const;

     void
       invalidate ( );

     IContainerControl* const
       element    ( ) const;

     private:
       const ICnrControlListImp
        *fControlListImp;
       void
        *fControlCursorImp;

      Cursor ( const Cursor& cursor);
      Cursor& operator=(const Cursor& cursor);

      friend class ICnrControlList;
   }; // Cursor


bool
  add       ( IContainerControl* const& control);

IContainerControl*
  elementAt   ( const Cursor& cursor) const;

bool
  isEmpty ( ) const;

unsigned long
  numberOfElements ( ) const,
  removeAll ( ),
  removeAll ( bool (*predicateFunction)(IContainerControl* const&,
                                        void*),
              void* data=0);

void
  removeAt           ( Cursor& cursor),
  replaceAt ( const Cursor& cursor, IContainerControl* const& control);

private:
friend class Cursor;
ICnrControlListImp
 *fControlListImp;

ICnrControlList& operator=(const ICnrControlList&);
};

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif // _ICNRCLST_
