// Revision: 97 1.5.1.3 source/ui/baseapp/icmdhdr.hpp, genhdr, ioc.v400, 980918 
#ifndef _ICMDHDR_
#define _ICMDHDR_
/*******************************************************************************
* FILE NAME: icmdhdr.hpp                                                       *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the class:                                                  *
*     ICommandHandler                                                          *
*     ICommandConnectionTo                                                     *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Material - Property of IBM                                        *
*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved.                   *
*                                                                              *
*******************************************************************************/
#include <ihandler.hpp>
#include <icmdevt.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IEvent;

#pragma enum(4)
#pragma pack(push,4)

class ICommandHandler : public IHandler {
typedef IHandler
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  ICommandHandler ( );
virtual
 ~ICommandHandler ( );

protected:
/*---------------------------- Event Dispatching -----------------------------*/
virtual bool
  dispatchHandlerEvent ( IEvent& event );

/*----------------------------- Event Processing -----------------------------*/
virtual bool
  command       ( ICommandEvent& event ),
  systemCommand ( ICommandEvent& event );
}; // ICommandHandler

#pragma info(nocpy)

template <class ATarget>
class ICommandConnectionTo : public ICommandHandler {
typedef ICommandHandler
  Inherited;
public:
/*----------------------------- Type Definitions -----------------------------*/
typedef bool  (ATarget::* MemberFunction)( ICommandEvent& );

/*------------------------------- Constructors -------------------------------*/
  ICommandConnectionTo ( ATarget&       target,
                         MemberFunction memberFunction );
virtual
 ~ICommandConnectionTo ( );

protected:
/*----------------------------- Event Processing -----------------------------*/
virtual bool
  command       ( ICommandEvent& event ),
  systemCommand ( ICommandEvent& event );

private:
/*--------------------------------- Private ----------------------------------*/
ATarget
 &fTarget;
MemberFunction
  fConnectedMember;
}; // ICommandConnectionTo

#include <icmdhdr.c>

#pragma info(restore)

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif /* _ICMDHDR_ */
