// Revision: 91 1.10.1.3 source/ui/baseapp/icmd.hpp, genhdr, ioc.v400, 980918 
#ifndef _ICMD_
  #define _ICMD_
/*******************************************************************************
* FILE NAME: icmd.hpp                                                          *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     ICommand                                                                 *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Material - Property of IBM                                        *
*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved.                   *
*                                                                              *
*******************************************************************************/
#include <ibase.hpp>
#include <iuipl.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#pragma enum(4)
#pragma pack(push,4)

class ICommand  {
public:
/*------------------------------- Action Type --------------------------------*/
enum ActionType {
  applicationCommand,
  systemCommand,
  help
  };

/*----------------------- Common Application Commands ------------------------*/
typedef unsigned long
  CommandId;
static const CommandId
  IC_IMPORTU kCancelOperationId,  // IC_ID_CANCELOPERATION
  IC_IMPORTU kOpenId,             // IC_ID_OPEN
  IC_IMPORTU kSaveId,             // IC_ID_SAVE
  IC_IMPORTU kPrintId,            // IC_ID_PRINT
  IC_IMPORTU kLocateId,           // IC_ID_LOCATE
  IC_IMPORTU kCutId,              // IC_ID_CUT
  IC_IMPORTU kCopyId,             // IC_ID_COPY
  IC_IMPORTU kPasteId,            // IC_ID_PASTE
  IC_IMPORTU kHelpId,             // IC_ID_HELP
  IC_IMPORTU kBoldId,             // IC_ID_BOLD
  IC_IMPORTU kItalicId,           // IC_ID_ITALIC
  IC_IMPORTU kUnderscoreId,       // IC_ID_UNDERSCORE
  IC_IMPORTU kDoubleUnderscoreId, // IC_ID_DOUBLEUNDERSCORE
  IC_IMPORTU kNormalId,           // IC_ID_NORMAL
  IC_IMPORTU kSettingsId,         // IC_ID_SETTINGS
#if (IC_OBSOLETE <= IC_OBSOLETE_3)
  // CopyTo "means" the same thing as SaveAs, "SaveAs" is the standard term.
  // For back compatibility, keep the old label but change the value to match SaveAs
  IC_IMPORTU kCopyToId,           // IC_ID_SAVE_AS
#endif
  IC_IMPORTU kPropertiesId,       // IC_ID_SETTINGS, using new terminology
//  IC_IMPORTU kPropertiesOfSelectedId,  // IC_ID_PROPERTIESOFSELECTED
  IC_IMPORTU kOkId,               // IC_ID_OK
  IC_IMPORTU kCancelId,           // IC_ID_CANCEL
  IC_IMPORTU kClearId,            // IC_ID_CLEAR
#ifdef IC_PMWIN
  IC_IMPORTU kFileOkId,           // IC_ID_FILEOK
  IC_IMPORTU kFileCancelId,       // IC_ID_FILECANCEL
  IC_IMPORTU kFileApplyId,        // IC_ID_FILEAPPLY
  IC_IMPORTU kFontOkId,           // IC_ID_FONTOK
  IC_IMPORTU kFontCancelId,       // IC_ID_FONTCANCEL
  IC_IMPORTU kFontApplyId,        // IC_ID_FONTAPPLY
#endif
  IC_IMPORTU kNewId,              // IC_ID_NEW
  IC_IMPORTU kSaveAsId,           // IC_ID_SAVE_AS
  IC_IMPORTU kExitId,             // IC_ID_EXIT
  IC_IMPORTU kUpdateId,           // IC_ID_UPDATE
  IC_IMPORTU kSaveCopyAsId,       // IC_ID_SAVE_COPY_AS
  IC_IMPORTU kUndoId,             // IC_ID_UNDO
  IC_IMPORTU kRedoId,             // IC_ID_REDO
  IC_IMPORTU kPasteSpecialId,     // IC_ID_PASTESPECIAL
  IC_IMPORTU kPasteLinkId,        // IC_ID_PASTELINK
  IC_IMPORTU kSelectAllId,        // IC_ID_SELECTALL
  IC_IMPORTU kInsertId,           // IC_ID_INSERT
  IC_IMPORTU kEditLinksId,        // IC_ID_EDITLINKS
  IC_IMPORTU kDeleteId,           // IC_ID_DELETE
  IC_IMPORTU kConvertId,          // IC_ID_CONVERT
  IC_IMPORTU kViewToolbarId,      // IC_ID_TOOLBAR
  IC_IMPORTU kAboutId,            // IC_ID_ABOUT
  IC_IMPORTU kJustifyId,          // IC_ID_JUSTIFY
  IC_IMPORTU kCenterId,           // IC_ID_CENTER
  IC_IMPORTU kLeftId,             // IC_ID_LEFT
  IC_IMPORTU kRightId,            // IC_ID_RIGHT
  IC_IMPORTU kCheckSpellingId,    // IC_ID_CHECKSPELLING
  IC_IMPORTU kDeselectAllId,      // IC_ID_DESELECTALL
  IC_IMPORTU kInsertColumnId,     // IC_ID_INSERTCOLUMN
  IC_IMPORTU kInsertRowId,        // IC_ID_INSERTROW
  IC_IMPORTU kDeleteColumnsId,    // IC_ID_DELETECOLUMNS
  IC_IMPORTU kDeleteRowsId,       // IC_ID_DELETEROWS
  IC_IMPORTU kLeftAlignObjectsId, // IC_ID_LEFTALIGNOBJ
  IC_IMPORTU kRightAlignObjectsId,     // IC_ID_RIGHTALIGNOBJ
  IC_IMPORTU kMailSendId,         // IC_ID_MAILSEND
  IC_IMPORTU kMovePagesId,        // IC_ID_MOVEPAGES
  IC_IMPORTU kPrintPreviewId,     // IC_ID_PRINTPREVIEW
  IC_IMPORTU kPrintSetupId,       // IC_ID_PRINTSETUP
  IC_IMPORTU kToolbarSetupId,     // IC_ID_TOOLBARSETUP
  IC_IMPORTU kSortAZId,           // IC_ID_SORTAZ
  IC_IMPORTU kSortZAId,           // IC_ID_SORTZA
  IC_IMPORTU kSortUpId,           // IC_ID_SORTUP
  IC_IMPORTU kSortDownId,         // IC_ID_SORTDOWN
  IC_IMPORTU kZoomId,             // IC_ID_ZOOM
  IC_IMPORTU kZoominId,           // IC_ID_ZOOMIN
  IC_IMPORTU kZoomOutId,          // IC_ID_ZOOMOUT
  IC_IMPORTU kTourId,             // IC_ID_TOUR
  IC_IMPORTU kGeneralHelpId,      // IC_ID_GENERALHELP
  IC_IMPORTU kHelpIndexId,        // IC_ID_HELPINDEX
  IC_IMPORTU kHelpTutorialId,     // IC_ID_HELPTUTORIAL
  IC_IMPORTU kUsingHelpId,        // IC_ID_USINGHELP
  IC_IMPORTU kLogonId,            // IC_ID_LOGON
  IC_IMPORTU kLogoffId,           // IC_ID_LOGOFF
  IC_IMPORTU kRunScriptId,        // IC_ID_RUNSCRIPT
  IC_IMPORTU kVPAPaletteId;       // IC_ID_VPAPALETTE

/*-------------------------- Common System Commands --------------------------*/
static const CommandId
  IC_IMPORTU kCloseId;            // IC_ID_CLOSE
#ifndef IC_MOTIF_FLAGNOP
static const CommandId
  IC_IMPORTU kMoveId,             // IC_ID_MOVE
  IC_IMPORTU kSizeId,             // IC_ID_SIZE
  IC_IMPORTU kMinimizeId,         // IC_ID_MINIMIZE
  IC_IMPORTU kMaximizeId,         // IC_ID_MAXIMIZE
  IC_IMPORTU kHideId,             // IC_ID_SYSHIDE
  IC_IMPORTU kRestoreId,          // IC_ID_RESTORE
  IC_IMPORTU kWindowListId;       // IC_ID_WINDOWLIST
#endif

private:
/*------------------------------ Hidden Members ------------------------------*/
  ICommand   ( );
  ICommand   ( const ICommand& command );
ICommand
 &operator = ( const ICommand& command );
};  // ICommand

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif /* _ICMD_ */
