// Revision: 27 1.5.1.3 source/ui/extapp/icliphdr.hpp, clipboard, ioc.v400, 980918  
#ifndef _ICLIPHDR_
#define _ICLIPHDR_
/*******************************************************************************
* FILE NAME: icliphdr.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IClipboardHandler                                                        *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1997       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*                                                                              *
*******************************************************************************/
#include <ihandler.hpp>
#include <ievent.hpp>
#include <iclipbrd.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#pragma enum(4)
#pragma pack(push,4)

class IClipboardHandler : public IHandler {
typedef IHandler
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IClipboardHandler ( );
virtual
 ~IClipboardHandler ( );

protected:
/*---------------------------- Event Dispatching -----------------------------*/
virtual bool
  dispatchHandlerEvent ( IEvent& event );

/*----------------------------- Event Processing -----------------------------*/
virtual bool
  clipboardEmptied ( IEvent&         event ) = 0,
  renderFormat     ( IEvent&         event,
                     const IString&  format ) = 0,
  renderAllFormats ( IEvent&         event ) = 0;
/*----------------------------- Clipboard Copying ----------------------------*/
void
  setDelayedData   ( IEvent&         event, 
                     const char*     format,
                     const void*     data,
                     unsigned long   dataLength );

}; // IClipboardHandler


#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif /* _ICLIPHDR_ */
