// Revision: 25 1.5.1.3 source/ui/extapp/iclipbrd.hpp, clipboard, ioc.v400, 980918  
#ifndef _ICLIPBRD_
#define _ICLIPBRD_
/*******************************************************************************
* FILE NAME: iclipbrd.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IClipboard                                                               *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1997       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*                                                                              *
*******************************************************************************/
#include <ibase.hpp>
#include <ihandle.hpp>
#include <iuipl.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IString;
class IClipboardImp;
class IClipboardCursorData;

#pragma enum(4)
#pragma pack(push,4)

class IClipboard {

public:
class Cursor;
/*------------------------------- Constructors -------------------------------*/
  IClipboard ( const IWindowHandle& clipboardWindow );
virtual
 ~IClipboard ( );

/*----------------------------- Clipboard Setup ------------------------------*/
virtual IClipboard
 &open                  ( ),
 &close                 ( ),
 &empty                 ( );

virtual bool
  isOpen                ( ) const;

/*------------------------- Clipboard Data Transfer --------------------------*/
virtual IClipboard
 &setText               ( const char*          text ),
 &setBitmap             ( const IBitmapHandle& bitmap ),
 &setData               ( const char*          format,
                          const void*          data,
                          unsigned long        dataLength ),
 &setHandle             ( const char*          format,
                          unsigned long        handle );
virtual bool
  hasText               ( ) const,
  hasBitmap             ( ) const,
  hasData               ( const char*          format ) const;

virtual IString
  text                  ( );
virtual IBitmapHandle
  bitmap                ( );
virtual void*
  data                  ( const char*          format );

/*---------------------------- Clipboard Formats -----------------------------*/
typedef unsigned long
  FormatHandle;

static IString
  primaryFormat         ( ),
  format                ( const Cursor&       cursor ),
  format                ( const FormatHandle& handle );

enum EElementSize
{
   k8Bit = 8
#ifdef IC_PMWIN_FLAGNOP
  ,k16Bit = 16
  ,k32Bit = 32
#endif
};

static FormatHandle
  registerFormat        ( const char*     privateFormat,
                          EElementSize    elementSize = k8Bit );

static FormatHandle
  formatAsHandle        ( const char*     format );

unsigned long
  formatCount           ( ) const;

/*----------------------- Clipboard Predefined Formats -----------------------*/

static const char
 IC_IMPORTU * const textFormat,
 IC_IMPORTU * const bitmapFormat;

#ifdef IC_PMWIN
static const char
 IC_IMPORTU * const metafileFormat,
 IC_IMPORTU * const displayTextFormat,
 IC_IMPORTU * const displayBitmapFormat,
 IC_IMPORTU * const displayMetafileFormat,
 IC_IMPORTU * const paletteFormat;
#endif

class Cursor {

public:
/*------------------------------- Constructors -------------------------------*/
  Cursor ( IClipboard&   clipboard );

virtual
 ~Cursor ( );

/*----------------------------- Cursor Movement ------------------------------*/
virtual bool
  setToFirst ( ),
  setToNext  ( );

/*---------------------------- Cursor Validation -----------------------------*/
virtual bool
  isValid    ( ) const;
virtual void
  invalidate ( );

private:
/*------------------------------ Hidden Members ------------------------------*/
  Cursor     ( const Cursor& cursor );
Cursor
 &operator=  ( const Cursor& cursor );

/*--------------------------------- Private ----------------------------------*/
friend class IClipboard;

IClipboard
 &fClipboard;

IClipboardCursorData
 *fClipboardCursorData;
};  // Cursor

/*--------------------------- Clipboard Ownership ----------------------------*/
IWindowHandle
  owner      ( ) const;

protected:

private:
/*------------------------------ Hidden Members ------------------------------*/
  IClipboard( const IClipboard& clipboard );
IClipboard
 &operator= ( const IClipboard& clipboard );

/*--------------------------------- Private ----------------------------------*/
friend class IClipboard::Cursor;
friend class IClipboardHandler;
  IClipboard ( );

IClipboardImp
 *fClipboardImp;

protected:

/*--------------------------- Clipboard Ownership ----------------------------*/
#if (IC_OBSOLETE <= IC_OBSOLETE_3)
  #ifdef IC_PM
    virtual IClipboard
     &setOwner   ( );
  #endif
#endif // IC_OBSOLETE

};  // IClipBoard


#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif /* _ICLIPBRD_ */
