/* Revision: 37 1.3.2.5 source/ui/cclnt/iclcsldw.h, cclcslid, ioc.v400, 980918  */
/* NOSHIP */
#ifndef _ICLCSLDW_
#define _ICLCSLDW_
/*******************************************************************************
* FILE NAME: iclcsldw.h                                                        *
*                                                                              *
* DESCRIPTION:                                                                 *
*   This file contains the header information for the 32-bit version of        *
*    the circular slider control.                                              *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1997       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*                                                                              *
*******************************************************************************/

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#pragma pack(4)

#ifndef CCL_MESSAGE_BASE
  #define CCL_MESSAGE_BASE ( 0xF000 )
#endif

#ifndef _ICLCLB_
	#include <iclclb.h>
#endif

/**********************************************************************/
/* Circular Slider Window Class                                       */
/**********************************************************************/
#define ICL_CIRCULARSLIDER     "ICL Circular Slider"

#if defined(CCL_SEPARATE_DLL)
#define ICL_SLIDER_DLL "ICLCSLDW.DLL"
#else
#define ICL_SLIDER_DLL ICL_DLL
#endif

/**********************************************************************/
/* Define messages for the circular slider control                    */
/**********************************************************************/
/**********************************************************************/
/* Note that these message are in a specific range.  When adding a    */
/* new message, be sure to add within the CCL message ranges defined  */
/* in iclccl.h.  For Circular Slider, limit the message to the range  */
/* CCL_MESSAGE_BASE+0x00b0 to CCL_MESSAGE_BASE+0x00bf.  Other CCL     */
/* controls use other sections of the entire range defined in         */
/* iclccl.h                                                           */
/**********************************************************************/
#define CSM_QUERYRANGE      (CCL_MESSAGE_BASE+0x00b0)  /* Query value range of control  */
#define CSM_SETRANGE        (CCL_MESSAGE_BASE+0x00b1)  /* Set the range of values       */
#define CSM_QUERYVALUE      (CCL_MESSAGE_BASE+0x00b2)  /* Query the current value       */
#define CSM_SETVALUE        (CCL_MESSAGE_BASE+0x00b3)  /* Set the value for the control */
#define CSM_QUERYRADIUS     (CCL_MESSAGE_BASE+0x00b4)  /* Query the current radious     */
#define CSM_SETINCREMENT    (CCL_MESSAGE_BASE+0x00b5)  /* Set scroll/tick mark increment*/
#define CSM_QUERYINCREMENT  (CCL_MESSAGE_BASE+0x00b6)  /* Query scroll/tick mark incr   */
#define CSM_SETBITMAPDATA   (CCL_MESSAGE_BASE+0x00b7)  /* Change bitmap for +/-         */
#define WM_CTLCOLORCSLIDER  (CCL_MESSAGE_BASE+0x00b8)  /* Query fore/background color   */


/**********************************************************************/
/* Note that these notification codes are in a specific range.  When  */
/* adding a new code, be sure to add within the CCL ranges defined    */
/* in iclccl.h.  For Circular Slider, limit the notification code to  */
/* 160 to 169.  Other CCL controls use other sections of the entire   */
/* range defined in iclccl.h.                                         */
/**********************************************************************/
#define CSN_SETFOCUS             160    /* Notify owner: gaining         */
#define CSN_KILLFOCUS            161    /* Notify owner: losing          */
#define CSN_CHANGED              162    /* Notify owner: value changed   */
#define CSN_TRACKING             163    /* Notify owner: mouse tracking  */
#define CSN_QUERYBACKGROUNDCOLOR 164    /* Notify owner: sets bckgrnd clr*/


/****************************************************************************/
/* Circular slider structure. Replaceable bit maps plus/minus buttons       */
/****************************************************************************/
typedef struct _CSBITMAPDATA   /* csbitmap */
{
   HBITMAP hbmLeftUp;
   HBITMAP hbmLeftDown;
   HBITMAP hbmRightUp;
   HBITMAP hbmRightDown;
} CSBITMAPDATA;
typedef CSBITMAPDATA *PCSBITMAPDATA;

/**********************************************************************/
/* Circular slider structure for notifying of position changes        */
/**********************************************************************/
typedef struct _CSDIALPPOS      /* csdialps */
{
   HWND         hwndCSlider;             /* Circular slider handle    */
   LONG         position;                /* Dial positional value     */
} CSDIALPOS;
typedef CSDIALPOS *PCSDIALPOS;

/**********************************************************************/
/* Circular Slider control style flag definition                      */
/**********************************************************************/
#define CSS_NOBUTTON             0x0001
#define CSS_NOTEXT               0x0002
#define CSS_NONUMBER             0x0004
#define CSS_POINTSELECT          0x0008
#define CSS_360                  0x0010
#define CSS_MIDPOINT             0x0020
#define CSS_PROPORTIONALTICKS    0x0040
#define CSS_NOTICKS              0x0080
#define CSS_CIRCULARVALUE        0x0100

#pragma pack()

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif // _ICLCSLDW_

