/* Revision: 36 1.5.1.4 source/ui/cclnt/iclcnrw.h, cclcnr, ioc.v400, 980918  */
#ifndef _ICLCNRW_
#define _ICLCNRW_
/*******************************************************************************
* FILE NAME: iclcnrw.h                                                         *
*                                                                              *
* DESCRIPTION:                                                                 *
*   This file contains the header information for the 32-bit version of        *
*    the container control.                                                    *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1997       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*                                                                              *
*******************************************************************************/

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#pragma pack(push,4)
#pragma enum(4)

#ifndef CCL_MESSAGE_BASE
  #define CCL_MESSAGE_BASE ( 0xF000 )
#endif

#ifndef _ICLCLB_
	#include <iclclb.h>
#endif

/**********************************************************************/
/* Container Window Class                                             */
/**********************************************************************/
#define ICL_CONTAINER     "ICL Container"
#if defined(CCL_SEPARATE_DLL)
#define ICL_CONTAINER_DLL "ICLCNRW.DLL"
#else
#define ICL_CONTAINER_DLL ICL_DLL
#endif

/**********************************************************************/
/* Ownerdraw id                                                       */
/**********************************************************************/
#define ODT_CONTAINER   100             /* ownerdraw id for Container */

/**********************************************************************/
/* Container control styles.                                          */
/**********************************************************************/
#define CNR_REQUIREDSTYLES        (WS_CHILD | WS_CLIPCHILDREN | WS_CLIPSIBLINGS)
#define CCS_EXTENDSEL             0x00000001L
#define CCS_MULTIPLESEL           0x00000002L
#define CCS_SINGLESEL             0x00000004L
#define CCS_AUTOPOSITION          0x00000008L
#define CCS_VERIFYPOINTERS        0x00000010L
#define CCS_READONLY              0x00000020L
#define CCS_MINIRECORDCORE        0x00000040L
#define CCS_MINIICONS             0x00000800L

/**********************************************************************/
/* view identifiers           (flWindowAttr)                          */
/**********************************************************************/
#define CV_TEXT                  0x00000001L  /* text view            */
#define CV_NAME                  0x00000002L  /* name view            */
#define CV_ICON                  0x00000004L  /* icon view            */
#define CV_DETAIL                0x00000008L  /* detail view          */
#define CV_FLOW                  0x00000010L  /* flow items           */
#define CV_MINI                  0x00000020L  /* use mini icon        */
#define CV_TREE                  0x00000040L  /* tree view            */
#define CV_EXACTMATCH            0x10000000L  
                                              
/**********************************************************************/
/* Container Attributes        (flWindowAttr)                         */
/**********************************************************************/
#define CA_CONTAINERTITLE        0x00000200L
#define CA_TITLESEPARATOR        0x00000400L
#define CA_TITLELEFT             0x00000800L
#define CA_TITLERIGHT            0x00001000L
#define CA_TITLECENTER           0x00002000L
#define CA_OWNERDRAW             0x00004000L
#define CA_DETAILSVIEWTITLES     0x00008000L
#define CA_ORDEREDTARGETEMPH     0x00010000L
#define CA_DRAWBITMAP            0x00020000L
#define CA_DRAWICON              0x00040000L
#define CA_TITLEREADONLY         0x00080000L
#define CA_OWNERPAINTBACKGROUND  0x00100000L
#define CA_MIXEDTARGETEMPH       0x00200000L
#define CA_TREELINE              0x00400000L

/**********************************************************************/
/* child window IDs                                                   */
/**********************************************************************/
#define CID_LEFTCOLTITLEWND     0x7FF0   /* column title (left)       */
#define CID_RIGHTCOLTITLEWND    0x7FF1   /* right column title        */
#define CID_BLANKBOX            0x7FF2   /* blank box at bottom right */
#define CID_HSCROLL             0x7FF3   /* horizontal scroll bar     */
#define CID_RIGHTHSCROLL        0x7FF4   /* right horz scroll bar     */
#define CID_CNRTITLEWND         0x7FF5   /* Container title window    */
#define CID_LEFTDVWND           0x7FF7   /* Left Details View window  */
#define CID_RIGHTDVWND          0x7FF8   /* Right Details View window */
#define CID_VSCROLL             0x7FF9   /* vertical scroll bar       */
#define CID_MLE                 0x7FFA   /* MLE window for direct edit*/

/**********************************************************************/
/* Bitmap descriptor array element.                                   */
/**********************************************************************/
typedef struct _TREEITEMDESC {  /* treend */
   HBITMAP    hbmExpanded;
   HBITMAP    hbmCollapsed;
   HICON      hptrExpanded;
   HICON      hptrCollapsed;
} TREEITEMDESC;
typedef TREEITEMDESC FAR *LPTREEITEMDESC;

/**********************************************************************/
/* Field Info data structure, attribute and data types, CV_DETAIL     */
/**********************************************************************/
typedef struct _FIELDINFO {   /* fldinfo */
    DWORD      cb;                  /* size of FIELDINFO struct       */
    DWORD      flData;              /* attributes of field's data     */
    DWORD      flTitle;             /* attributes of field's title    */
    LPVOID     pTitleData;          /* title data (default is string) */
    DWORD      offStruct;           /* offset from RECORDCORE to data */
    LPVOID     pUserData;           /* pointer to user data           */
    struct _FIELDINFO FAR *pNextFieldInfo; /* pointer to next linked  */
                                           /*   FIELDINFO structure   */
    WORD       cxWidth;             /* width of field in pels         */
} FIELDINFO;
typedef FIELDINFO FAR *LPFIELDINFO;

/**********************************************************************/
/* RECORDCORE data structure , attribute values                       */
/**********************************************************************/
typedef struct _RECORDCORE {  /* recc */
    DWORD       cb;
    DWORD       flRecordAttr;       /* record attributes              */
    POINT       ptlIcon;            /* Position of CV_ICON item       */
    struct _RECORDCORE FAR *preccNextRecord;    /* ptr to next record */
    LPSTR       pszIcon;            /* Text for CV_ICON view          */
    HICON       hptrIcon;           /* Icon to display for ~CV_MINI   */
    HICON       hptrMiniIcon;       /* Icon to display for CV_MINI    */
    HBITMAP     hbmBitmap;          /* Bitmap to show for ~CV_MINI    */
    HBITMAP     hbmMiniBitmap;      /* Bitmap to show for CV_MINI     */
    LPTREEITEMDESC pTreeItemDesc;   /* Icons for the tree view        */
    LPSTR       pszText;            /* Text for CV_TEXT view          */
    LPSTR       pszName;            /* Text for CV_NAME view          */
    LPSTR       pszTree;            /* Text for CV_TREE view          */
} RECORDCORE;
typedef RECORDCORE FAR *LPRECORDCORE;

/**********************************************************************/
/* MINIRECORDCORE data structure, attribute values                    */
/**********************************************************************/
typedef struct _MINIRECORDCORE {  /* minirec */
    DWORD      cb;
    DWORD      flRecordAttr;        /* record attributes              */
    POINT      ptlIcon;             /* Position of CV_ICON item       */
    struct _MINIRECORDCORE FAR *preccNextRecord; /*ptr to next record */
    LPSTR      pszIcon;             /* Text for CV_ICON view          */
    HICON      hptrIcon;            /* Icon to display for ~CV_MINI   */
} MINIRECORDCORE;
typedef MINIRECORDCORE FAR *LPMINIRECORDCORE;

/**********************************************************************/
/* CNRINFO data structure, describes the container control.           */
/**********************************************************************/
typedef struct _CNRINFO {  /* ccinfo */
    DWORD        cb;                 /* size of CNRINFO struct        */
    LPVOID       pSortRecord;        /* ptr to sort function,         */
                                     /*   RECORDCORE                  */
    LPFIELDINFO  pFieldInfoLast;     /* pointer to last column in     */
                                     /*   left pane of a split window.*/
    LPFIELDINFO  pFieldInfoObject;   /* Pointer to a column to        */
                                     /* represent an object.  This is */
                                     /* the column which will receive */
                                     /* IN-USE emphasis.              */
    LPSTR        pszCnrTitle;        /* text for container title. One */
                                     /*   string separated by line    */
                                     /*   separators for multi-lines  */
    DWORD        flWindowAttr;       /* container attrs - CV_*, CA_*  */
    POINT        ptlOrigin;          /* upper-left origin in virtual  */
                                     /*   coordinates. CV_ICON view   */
    DWORD        cDelta;             /* Application defined threshold */
                                     /*   or number of records from   */
                                     /*   either end of the list.     */
    DWORD        cRecords;           /* number of records in container*/
    POINT        slBitmapOrIcon;     /* size of bitmap in pels        */
    POINT        slTreeBitmapOrIcon; /* size of tree bitmaps in pels  */
    HBITMAP      hbmExpanded;        /* bitmap  for tree node         */
    HBITMAP      hbmCollapsed;       /* bitmap  for tree node         */
    HICON        hptrExpanded;       /* icon    for tree node         */
    HICON        hptrCollapsed;      /* icon    for tree node         */
    int          cyLineSpacing;      /* space between two rows        */
    int          cxTreeIndent;       /* indent for children           */
    int          cxTreeLine;         /* thickness of the Tree Line    */
    DWORD        cFields;            /* number of fields  in container*/
    int          xVertSplitbar;      /* position relative to the      */
                                     /*   container (CV_DETAIL); if   */
                                     /*   0xFFFF then unsplit         */
} CNRINFO;
typedef CNRINFO FAR *LPCNRINFO;

typedef struct _CDATE {  /* cdate */
    BYTE   day;                         /* current day                */
    BYTE   month;                       /* current month              */
    WORD   year;                        /* current year               */
} CDATE;
typedef CDATE FAR *LPCDATE;

typedef struct _CTIME {  /* ctime */
    BYTE   hours;                       /* current hour               */
    BYTE   minutes;                     /* current minute             */
    BYTE   seconds;                     /* current second             */
    BYTE   ucReserved;                  /* reserved                   */
} CTIME;
typedef CTIME FAR *LPCTIME;

/**********************************************************************/
/* attribute and type values for flData and flTitle members of        */
/* FIELDINFO, CFA_ (attributes), CFT_ (types)                         */
/**********************************************************************/
#define CFA_LEFT            0x00000001L /* left align text            */
#define CFA_RIGHT           0x00000002L /* right align text           */
#define CFA_CENTER          0x00000004L /* center text                */
#define CFA_TOP             0x00000008L /* top-align text             */
#define CFA_VCENTER         0x00000010L /* vertically center text     */
#define CFA_BOTTOM          0x00000020L /* bottom-align text          */
#define CFA_INVISIBLE       0x00000040L /* Specify invisible column.  */
#define CFA_BITMAPORICON    0x00000100L /* field title is bitmap      */
#define CFA_SEPARATOR       0x00000200L /* vert sep, right of fld     */
#define CFA_HORZSEPARATOR   0x00000400L /* horz sep, bottom of fld    */

#define CFA_STRING          0x00000800L /* string of characters       */
#define CFA_OWNER           0x00001000L /* ownerdraw field            */
#define CFA_DATE            0x00002000L /* date structure             */
#define CFA_TIME            0x00004000L /* time structure             */
#define CFA_FIREADONLY      0x00008000L /* Column is read-only.       */
#define CFA_FITITLEREADONLY 0x00010000L /* Column Title is read-only  */
#define CFA_ULONG           0x00020000L /* Column is number format    */

/**********************************************************************/
/* attribute values for flRecordAttr member of RECORDCORE             */
/**********************************************************************/
#define CRA_SELECTED        0x00000001L /* record is selected         */
#define CRA_TARGET          0x00000002L /* record has target emphasis */
#define CRA_CURSORED        0x00000004L /* cursor is on the record    */
#define CRA_INUSE           0x00000008L /* record has in-use emphasis */
#define CRA_FILTERED        0x00000010L /* record has been filtered   */
#define CRA_DROPONABLE      0x00000020L /* record can be dropped on   */
#define CRA_RECORDREADONLY  0x00000040L /* record is read-only        */
#define CRA_EXPANDED        0x00000080L /* record is expanded         */
#define CRA_COLLAPSED       0x00000100L /* record is collapsed        */
#define CRA_SOURCE          0x00004000L /*                            */

/**********************************************************************/
/* Container messages                                                 */
/**********************************************************************/
/* Note that these message are in a specific range.  When adding a    */
/* new message, be sure to add within the CCL message ranges defined  */
/* in iclccl.h.  For Container, limit the message to the range        */
/* CCL_MESSAGE_BASE+0x0005 to CCL_MESSAGE_BASE+0x006F.  Other CCL     */
/* controls use other sections of the entire range defined in         */
/* iclccl.h                                                           */
/**********************************************************************/
#define CM_ALLOCDETAILFIELDINFO       (CCL_MESSAGE_BASE+0x0030)
#define CM_ALLOCRECORD                (CCL_MESSAGE_BASE+0x0031)
#define CM_ARRANGE                    (CCL_MESSAGE_BASE+0x0032)
#define CM_ERASERECORD                (CCL_MESSAGE_BASE+0x0033)
#define CM_FILTER                     (CCL_MESSAGE_BASE+0x0034)
#define CM_FREEDETAILFIELDINFO        (CCL_MESSAGE_BASE+0x0035)
#define CM_FREERECORD                 (CCL_MESSAGE_BASE+0x0036)
#define CM_HORZSCROLLSPLITWINDOW      (CCL_MESSAGE_BASE+0x0037)
#define CM_INSERTDETAILFIELDINFO      (CCL_MESSAGE_BASE+0x0038)
#define CM_INSERTRECORD               (CCL_MESSAGE_BASE+0x0039)
#define CM_INVALIDATEDETAILFIELDINFO  (CCL_MESSAGE_BASE+0x003a)
#define CM_INVALIDATERECORD           (CCL_MESSAGE_BASE+0x003b)
#define CM_PAINTBACKGROUND            (CCL_MESSAGE_BASE+0x003c)
#define CM_QUERYCNRINFO               (CCL_MESSAGE_BASE+0x003d)
#define CM_QUERYDETAILFIELDINFO       (CCL_MESSAGE_BASE+0x003e)
#define CM_QUERYRECORD                (CCL_MESSAGE_BASE+0x0040)
#define CM_QUERYRECORDEMPHASIS        (CCL_MESSAGE_BASE+0x0041)
#define CM_QUERYRECORDFROMRECT        (CCL_MESSAGE_BASE+0x0042)
#define CM_QUERYRECORDRECT            (CCL_MESSAGE_BASE+0x0043)
#define CM_QUERYVIEWPORTRECT          (CCL_MESSAGE_BASE+0x0044)
#define CM_REMOVEDETAILFIELDINFO      (CCL_MESSAGE_BASE+0x0045)
#define CM_REMOVERECORD               (CCL_MESSAGE_BASE+0x0046)
#define CM_SCROLLWINDOW               (CCL_MESSAGE_BASE+0x0047)
#define CM_SEARCHSTRING               (CCL_MESSAGE_BASE+0x0048)
#define CM_SETCNRINFO                 (CCL_MESSAGE_BASE+0x0049)
#define CM_SETRECORDEMPHASIS          (CCL_MESSAGE_BASE+0x004a)
#define CM_SORTRECORD                 (CCL_MESSAGE_BASE+0x004b)
#define CM_OPENEDIT                   (CCL_MESSAGE_BASE+0x004c)
#define CM_CLOSEEDIT                  (CCL_MESSAGE_BASE+0x004d)
#define CM_COLLAPSETREE               (CCL_MESSAGE_BASE+0x004e)
#define CM_EXPANDTREE                 (CCL_MESSAGE_BASE+0x004f)
#define CM_QUERYRECORDINFO            (CCL_MESSAGE_BASE+0x0050)
/**********************************************************************/
/* New messages for Windows version                                   */
/**********************************************************************/
#define CM_SETCNRCOLORS               (CCL_MESSAGE_BASE+0x0051)
#define CM_SETREALLOCRESULT           (CCL_MESSAGE_BASE+0x0052)
#define CM_QUERYCNRCOLORS             (CCL_MESSAGE_BASE+0x0053)

/**********************************************************************/
/* Container notifications                                            */
/**********************************************************************/
/**********************************************************************/
/* Note that these notification codes are in a specific range.  When  */
/* adding a new code, be sure to add within the CCL ranges defined    */
/* in iclccl.h.  For CNR, limit the notification code to the range    */
/* 100 to 129.  Other CCL controls use other sections of the entire   */
/* range defined in iclccl.h.                                         */
/* The reason for this is due to a test for Win32s support to         */
/* determine if a WM_COMMAND message contains a CCL notification code */
/**********************************************************************/
#define CN_DRAGAFTER                  101
#define CN_DRAGLEAVE                  102
#define CN_DRAGOVER                   103
#define CN_DROP                       104
#define CN_DROPHELP                   105
#define CN_ENTER                      106
#define CN_INITDRAG                   107
#define CN_EMPHASIS                   108
#define CN_KILLFOCUS                  109
#define CN_SCROLL                     110
#define CN_QUERYDELTA                 111
#define CN_SETFOCUS                   112
#define CN_REALLOCPSZ                 113
#define CN_BEGINEDIT                  114
#define CN_ENDEDIT                    115
#define CN_COLLAPSETREE               116
#define CN_EXPANDTREE                 117
#define CN_HELP                       118
#define CN_CONTEXTMENU                119

/**********************************************************************/
/*   Data Structures for Message Parameters                           */
/**********************************************************************/

/**********************************************************************/
/* Container Direct Manipulation structures                           */
/**********************************************************************/
typedef struct _CNRDRAGINIT     /* cdrginit */
{
   HWND         hwndCnr;                 /* Container window handle   */
   LPRECORDCORE pRecord;                 /* record under mouse ptr    */
   int          x;                       /* x coordinate of mouse ptr */
   int          y;                       /* y coordinate of mouse ptr */
   int          cx;                      /* x offset from record      */
   int          cy;                      /* y offset from record      */
} CNRDRAGINIT;
typedef CNRDRAGINIT *PCNRDRAGINIT;

/**********************************************************************/
/* Data structure for CM_INSERTDETAILFIELDINFO                        */
/* This structure is used by the application to specify the position  */
/* of the FieldInfo structures they are inserting.                    */
/**********************************************************************/
typedef struct _FIELDINFOINSERT {  /* fiins */
   DWORD       cb;                  /* Size of structure.             */
   LPFIELDINFO pFieldInfoOrder;     /* Specifies the order of the     */
                                    /* FieldInfo structures.          */
   BOOL        fInvalidateFieldInfo;/* Invalidate on Insert.          */
   WORD        cFieldInfoInsert;    /* The number of FieldInfo        */
                                    /* structures to insert.          */
} FIELDINFOINSERT;
typedef FIELDINFOINSERT FAR *LPFIELDINFOINSERT;

/**********************************************************************/
/* Data structure for CM_INSERTRECORD                                 */
/**********************************************************************/
typedef struct _RECORDINSERT {  /* recins */
    DWORD        cb;
    LPRECORDCORE pRecordOrder;
    LPRECORDCORE pRecordParent;
    BOOL         fInvalidateRecord;
    WORD         zOrder;
    WORD         cRecordsInsert;
} RECORDINSERT;
typedef RECORDINSERT FAR *LPRECORDINSERT;

/**********************************************************************/
/* Data structure for CM_QUERYRECORDFROMRECT                          */
/**********************************************************************/
typedef struct _QUERYRECFROMRECT {  /* qrecfrct */
    DWORD        cb;
    RECT         rect;
    WORD         fsSearch;
} QUERYRECFROMRECT;
typedef QUERYRECFROMRECT FAR *LPQUERYRECFROMRECT;

/**********************************************************************/
/* Data structure for CM_QUERYRECORDRECT                              */
/**********************************************************************/
typedef struct _QUERYRECORDRECT {  /* qrecrct */
    DWORD        cb;
    LPRECORDCORE pRecord;
    BOOL         fRightSplitWindow;
    WORD         fsExtent;
} QUERYRECORDRECT;
typedef QUERYRECORDRECT FAR *LPQUERYRECORDRECT;

/**********************************************************************/
/* Data structure for CM_SEARCHSTRING                                 */
/**********************************************************************/
typedef struct _SEARCHSTRING {  /* srchstr */ 
    ULONG        cb;
    LPSTR        pszSearch;
    ULONG        fsPrefix;
    ULONG        fsCaseSensitive;
    ULONG        usView;
} SEARCHSTRING;
typedef SEARCHSTRING FAR *LPSEARCHSTRING;

/**********************************************************************/
/* Data structure for CN_EMPHASIS                                     */
/**********************************************************************/
typedef struct _NOTIFYRECORDEMPHASIS {  /* nrecemph */
    HWND          hwndCnr;
    LPRECORDCORE  pRecord;
    WORD          fEmphasisMask;
} NOTIFYRECORDEMPHASIS;
typedef NOTIFYRECORDEMPHASIS FAR *LPNOTIFYRECORDEMPHASIS;

/**********************************************************************/
/* Data structure for CN_ENTER                                        */
/**********************************************************************/
typedef struct _NOTIFYRECORDENTER {  /* notrecen */
    HWND          hwndCnr;
    BOOL          fKey;
    LPRECORDCORE  pRecord;
} NOTIFYRECORDENTER;
typedef NOTIFYRECORDENTER FAR *LPNOTIFYRECORDENTER;

/**********************************************************************/
/* Data structure for CN_QUERYDELTA                                   */
/**********************************************************************/
typedef struct _NOTIFYDELTA {  /* notdlt */
    HWND      hwndCnr;
    WORD      fDelta;
} NOTIFYDELTA;
typedef NOTIFYDELTA FAR *LPNOTIFYDELTA;

/**********************************************************************/
/* Data structure for CN_SCROLL                                       */
/**********************************************************************/
typedef struct _NOTIFYSCROLL {  /* notscr */
    HWND      hwndCnr;
    long      lScrollInc;
    WORD      fScroll;
} NOTIFYSCROLL;
typedef NOTIFYSCROLL FAR *LPNOTIFYSCROLL;

/**********************************************************************/
/* Data structure for CN_REALLOCPSZ                                   */
/**********************************************************************/
typedef struct _CNREDITDATA {  /* cnredat */
    DWORD         cb;
    HWND          hwndCnr;
    LPRECORDCORE  pRecord;
    LPFIELDINFO   pFieldInfo;
    LPSTR FAR     *ppszText;                 /* address of LPSTR      */
    WORD          cbText;                    /* size of the new text  */
    int           id;
} CNREDITDATA;
typedef CNREDITDATA FAR *LPCNREDITDATA;

/**********************************************************************/
/* Data structure for CM_PAINTBACKGROUND                              */
/**********************************************************************/
typedef struct _OWNERBACKGROUND {  /* ownbckg */
    HWND    hwnd;
    HDC     hps;
    RECT    rclBackground;
    int     idWindow;
} OWNERBACKGROUND;
typedef OWNERBACKGROUND FAR *LPOWNERBACKGROUND;

/**********************************************************************/
/* Data structure used as part of WM_DRAWITEM                         */
/**********************************************************************/
typedef struct _CNRDRAWITEMINFO {  /* cnrdrwii */
    LPRECORDCORE  pRecord;
    LPFIELDINFO   pFieldInfo;
} CNRDRAWITEMINFO;
typedef CNRDRAWITEMINFO FAR *LPCNRDRAWITEMINFO;

/**********************************************************************/
/* Container Context Menu structures                                  */
/**********************************************************************/
typedef struct _CNRMENUINIT     /* cmninit */
{
   HWND         hwndCnr;                 /* Container window handle   */
   LPRECORDCORE pRecord;                 /* record under mouse ptr    */
   int          x;                       /* x coordinate of mouse ptr */
   int          y;                       /* y coordinate of mouse ptr */
} CNRMENUINIT;
typedef CNRMENUINIT *PCNRMENUINIT;

/**********************************************************************/
/* Message parameter flags                                            */
/**********************************************************************/
#define CMA_TOP              0x0001       /* Place at top of zorder   */
#define CMA_BOTTOM           0x0002       /* Place at bottom of zorder*/
#define CMA_LEFT             0x0004
#define CMA_RIGHT            0x0008

#define CMA_FIRST            0x0010       /* Add record as first      */
#define CMA_LAST             0x0020
#define CMA_END              0x0040       /* Add record to end of list*/
#define CMA_PREV             0x0080
#define CMA_NEXT             0x0100
#define CMA_WIDTH            0x0200
#define CMA_DATAWIDTH        CMA_WIDTH

#define CMA_HORIZONTAL       0x0200
#define CMA_VERTICAL         0x0400
#define CMA_ICON             0x0800
#define CMA_TEXT             0x1000
#define CMA_PARTIAL          0x2000
#define CMA_COMPLETE         0x4000

#define CMA_PARENT           0x0001
#define CMA_FIRSTCHILD       0x0002
#define CMA_LASTCHILD        0x0004

#define CMA_CNRTITLE         0x0001       /* Container title          */
#define CMA_DELTA            0x0002       /* Application defined      */
#define CMA_FLWINDOWATTR     0x0004       /* Container attributes     */
#define CMA_LINESPACING      0x0008
#define CMA_PFIELDINFOLAST   0x0010       /* Ptr to last column in    */
                                          /* details view             */

#define CMA_PSORTRECORD      0x0020       /* Pointer to sort function */
#define CMA_PTLORIGIN        0x0040       /* Upper left origin        */
#define CMA_SLBITMAPORICON   0x0080       /* Size  of bitmap          */
#define CMA_XVERTSPLITBAR    0x0100       /* Splitbar position        */
#define CMA_PFIELDINFOOBJECT 0x0200       /* Pointer to IN-USE        */
                                          /*   emphasis column.       */

#define CMA_TREEICON           0x0400     /* Icon for tree node       */
#define CMA_TREEBITMAP         0x0800     /* bitmap for tree node     */
#define CMA_CXTREEINDENT       0x1000     /* indent for children      */
#define CMA_CXTREELINE         0x2000     /* thickness of tree line   */
#define CMA_SLTREEBITMAPORICON 0x4000     /* size of icon of tree node*/

#define CMA_ITEMORDER        0x0001       /* QueryRecord search flags */
#define CMA_WINDOW           0x0002
#define CMA_WORKSPACE        0x0004
#define CMA_ZORDER           0x0008

#define CMA_DELTATOP         0x0001       /* Industrial - top delta   */
#define CMA_DELTABOT         0x0002       /* Industrial - bottom delta*/
#define CMA_DELTAHOME        0x0004       /* Industrial - top of list */
#define CMA_DELTAEND         0x0008       /* Industrial - end of list */

#define CMA_NOREPOSITION     0x0001       /* InvalidateRecord flags   */
#define CMA_REPOSITION       0x0002
#define CMA_TEXTCHANGED      0x0004
#define CMA_ERASE            0x0008

#define CMA_FREE             0x0001
#define CMA_INVALIDATE       0x0002

/**********************************************************************/
/* Set color attributes                                               */
/**********************************************************************/
#define CMA_FOREGROUNDCOLOR        0  /* text color                   */
#define CMA_BACKGROUNDCOLOR        1  /* window background color      */
#define CMA_SELECTFOREGROUNDCOLOR  2  /* select emphasis text color   */
#define CMA_SELECTBACKGROUNDCOLOR  3  /* select emphasis backgnd color*/
#define CMA_SEPARATORCOLOR         4  /* separator color              */

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif // _ICLCNRW_

