// Revision: 41 1.5.1.4 source/ui/basectl/icheckbx.hpp, buttonctls, ioc.v400, 980918  
#ifndef _ICHECKBX_
  #define _ICHECKBX_
/*******************************************************************************
* FILE NAME: icheckbx.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*    ICheckBox                                                                 *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1997       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*                                                                              *
*******************************************************************************/
#include <isetbut.hpp>
#include <irect.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class ISize;
class IWindowHandle;
class ICheckBoxData;

#pragma enum(4)
#pragma pack(push,4)

class ICheckBox : public ISettingButton  {
typedef ISettingButton
  Inherited;
public:
class Style;
/*------------------------------- Constructors -------------------------------*/
  ICheckBox  (unsigned long id,
              IWindow* parent,
              IWindow* owner,
              const IRectangle& initial= IRectangle(),
              const Style& style = defaultStyle() );

  ICheckBox  (unsigned long id,
              IWindow*      parent);

  ICheckBox  (const IWindowHandle& handle);

virtual
  ~ICheckBox ( );

/*---------------------------------- Styles ----------------------------------*/
INESTEDBITFLAGCLASSDEF3(Style, ICheckBox, IWindow,
                        IControl, IButton);

static const Style
  IC_IMPORTU classDefaultStyle,
#ifndef IC_MOTIF_FLAGNOP
  IC_IMPORTU autoSelect;
#endif // IC_MOTIF_FLAGNOP

static Style
  defaultStyle      ( );
static void
  setDefaultStyle   ( const Style&    style );

virtual unsigned long
  convertToGUIStyle ( const IBitFlag& style,
                      bool         extendedOnly = false ) const;

#ifndef IC_MOTIF_FLAGNOP
/*------------------------------- Auto Select --------------------------------*/
virtual ICheckBox
  &enableAutoSelect  ( bool enable=true ),
  &disableAutoSelect ( );
virtual bool
  isAutoSelect       ( ) const;
#endif // IC_MOTIF_FLAGNOP

protected:
/*---------------------------------- Layout ----------------------------------*/
virtual ISize
  calcMinimumSize    ( ) const;

private:
/*--------------------------------- Private ----------------------------------*/
#ifdef IC_WIN
friend class ICheckHandler;
#endif // IC_WIN

static Style
  currentDefaultStyle;

ICheckBoxData
 *fCheckBoxData;

/*----------------------------- Hidden Functions -----------------------------*/
  ICheckBox       (const ICheckBox&);
  ICheckBox
     &operator=   (const ICheckBox&);
};  // class ICheckBox

INESTEDBITFLAGCLASSFUNCS(Style, ICheckBox)

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif  /* _ICHECKBX_ */
