#ifndef _ICCONSTA_
#define _ICCONSTA_
/*----------------------------------------------------------------------------*/
/* FILE NAME: icconsta.h                                                      */
/*                                                                            */
/* DESCRIPTION:                                                               */
/*   Application Support resource identifier macro constants                  */
/*                                                                            */
/* COPYRIGHT:                                                                 */
/*   IBM Open Class Library                                                   */
/*   Licensed Materials - Property of IBM                                     */
/*                                                                            */
/*   (C) Copyright IBM Corporation 1992, 1997  All Rights Reserved.           */
/*                                                                            */
/*----------------------------------------------------------------------------*/

#ifndef RC_INVOKED
#include <ibase.hpp>
#endif



#define IC_ASSERTPARM                          1
#define IC_HEAP_EXHAUSTED                      4

#define IC_INVALID_MBCS_STRING                25
#define IC_ERR_CONV_MBCS_TO_WCHAR             26
#define IC_ERR_CALLED_PROTECTED_FUNC          27
#define IC_DECIMAL_DATA_OVERFLOW              28





#define IC_INVALID_THREAD_ID                  46
#define IC_THREAD_STARTED                     47
#define IC_SEMAPHORES_EXHAUSTED               49
#define IC_ISTRING_OVERFLOW                   51
#define IC_ISTRING_INDEX_ERROR                52
#define IC_NULL_IREFERENCE                    58
#define IC_THREAD_VARIABLE_LIMIT_EXCEEDED     66
#define IC_THREAD_NOT_STARTED_WIN32S          71

#define IC_GUI_ERROR                         185
#define IC_SYSTEM_ERROR                      186

#define IC_CHILD_ALREADY_EXISTS              370
#define IC_COLLECTION_IS_EMPTY               371
#define IC_CURSOR_NOT_CONTAINED              372
#define IC_CURSOR_NOT_FOR_GIVEN              373
#define IC_CURSOR_NOT_FOR_THIS               374
#define IC_IDENTICAL_COLLECTION              375
#define IC_INVALID_CURSOR                    376
#define IC_INVALID_POSITION                  377
#define IC_INVALID_REPLACEMENT               378
#define IC_KEY_ALREADY_EXISTS                379
#define IC_KEY_NOT_CONTAINED                 380
#define IC_NOT_BOUNDED                       381
#define IC_OUT_OF_COLLECTION_MEMORY          382
#define IC_ROOT_ALREADY_EXISTS               383
#define IC_CYCLIC_CHILD_ATTACHMENT           384
#define IC_NO_MUTEX_AVAILABLE                385
#define IC_LOCK_FAILED                       386
#define IC_LOCK_TIMEOUT                      387
#define IC_UNLOCK_FAILED                     388
#define IC_STREAM_VERSION_ERROR              389
#define IC_STREAMER_INVALID                  390
#define IC_COLLECTION_IS_FULL                391
#define IC_COLLECTION_NOT_EMPTY              392

// IProcessHandle errors
#define IC_EXTP_ALREADYSTARTED               550
#define IC_EXTP_SETPATH                      551
#define IC_EXTP_SETENV                       552
#define IC_EXTP_INVALID_PRIORITY             553
#define IC_EXTP_START                        554
#define IC_EXTP_ENV_BUFFER_FULL              555
#define IC_EXTP_CANT_GET_PRIO                556
#define IC_EXTP_CANT_SET_PRIO                557
#define IC_EXTP_UNKNOWN_PRIO                 558
#define IC_EXTP_CANT_START                   559
#define IC_EXTP_CANT_KILL                    560
#define IC_EXTP_NOT_SUPPORTED                561
#define IC_EXTP_ERROR_WAITING_ON             562
#define IC_EXTP_EXE_NOT_FOUND                563
#define IC_EXTP_BAD_PATH                     564

#define IC_EXTP_FIRST                        550 // Keep these in sync!!
#define IC_EXTP_LAST                         564

// ICondition errors
#define IC_COND_NOT_FOUND                    565
#define IC_COND_TIMEOUT                      566
#define IC_COND_OWNER_DIED                   567
#define IC_COND_ALREADY_OWNED                568
#define IC_COND_TOOMANY                      569
#define IC_COND_HOSTERR                      570
#define IC_COND_INVALID                      571

#define IC_COND_FIRST                        565 // Keep these in sync!!
#define IC_COND_LAST                         571








































#endif // _ICCONSTA_
