/* Revision: 89 1.6.1.22 source/ui/baseapp/icconst.h, buildtools, ioc.v400, 980918  */
#ifndef _ICCONST_
#define _ICCONST_
/*----------------------------------------------------------------------------*/
/* FILE NAME: icconst.h                                                       */
/*                                                                            */
/* DESCRIPTION:                                                               */
/*   User Interface resource identifier macro constants.                      */
/*                                                                            */
/* COPYRIGHT:                                                                 */
/*   IBM Open Class Library                                                   */
/*   Licensed Materials - Property of IBM                                     */
/*                                                                            */
/*   5645-001                                                                 */
/*   (C) Copyright IBM Corporation 1992, 1996  All Rights Reserved.           */
/*                                                                            */
/*   US Government Users Restricted Rights - Use, duplication, or             */
/*   disclosure restricted by GSA ADP Schedule Contract with IBM Corp.        */
/*                                                                            */
/*----------------------------------------------------------------------------*/

/* Include a header for IC_OBSOLETE defines which are used in this file and   */
/* in dde4uir.rc, which includes this file.                                   */

#include <icconsta.h>
#include <iuipl.hpp>

#define IC_ASSERTPARM                       1
#define IC_MEMBER_ACCESS_ERROR              2
#define IC_UNEXPECTED_ERROR                 3
#define IC_HEAP_EXHAUSTED                   4
#define IC_WINDOW_DELETE_FROM_CALLBACK      5

#define IC_THIS_PLATFORM_NOT_SUPPORTED      10

#define IC_RELEASEPSFAIL                    30
#define IC_INVALIDCHARCODE                  31
#define IC_INVALIDSCANCODE                  32
#define IC_INVALIDVIRTUALKEY                33
#define IC_PRESPARAMNOTFOUND                34
#define IC_INVALIDCOLORINDEX                35
#define IC_INVALIDEVENT                     36
#define IC_DBCSCHARASSERT                   37
#define IC_DBCSSCANCODEASSERT               38
#define IC_INVALIDENUMVALUE                 39
#define IC_NOMARKEDTEXT                     40
#define IC_CLIPBOARDEMPTY                   41
#define IC_HANDLERNOTFOUND                  42
#define IC_INVALIDSTYLE                     43
#define IC_INVALIDSIZE                      44
#define IC_FRAME_EXTENSION_NOT_FOUND        45
#define IC_SUSPEND_PM_THREAD                48
#define IC_VIEWPORT_INVALID_SCROLL          50
#define IC_CNROBJ_INVALID_OBJECTCOPY        53
#define IC_CNROBJ_INVALID_CREATE            54
#define IC_MULTICELLCANVAS_CELL_OVERLAP     55
#define IC_DISPATCHTO_INVALID_HANDLER       56
#define IC_INVALIDSIZE_LIMIT                57
#define IC_NULL_IREFERENCE                  58
#define IC_XMCREATE_FAILURE                 59
#define IC_XMSTRING_INIT_FAILURE            60
#define IC_INVALIDHANDLE                    61
#define IC_NO_WINDOW_WITHID                 62
#define IC_PARENT_IS_NOT_IWINDOW            63
#define IC_CONTROL_NOT_FOUND                64
#define IC_WRONG_CONTROL_TYPE               65
#define IC_VECTOR_FONT_ONLY_FUNCTION        67
#define IC_CNRALLOCATOR_LIMIT_EXCEEDED      68
#define IC_CNRALLOCATOR_INVALIDNUMVALUE     69
#define IC_MUST_HAVE_TITLE_TEXT             70
#define IC_INVALID_STYLE_FOR_FUNCTION       71
#define IC_INVALID_BUTTON_PARENT            72
#define IC_TABPAGE_NOT_FOUND                73

#define IC_HELPERRORMSGBOX_TITLE            80
#define IC_HMERR_LOAD_DLL                   81
#define IC_HMERR_NO_FRAME_WND_IN_CHAIN      82
#define IC_HMERR_INVALID_ASSOC_APP_WND      83
#define IC_HMERR_INVALID_ASSOC_HELP_INST    84
#define IC_HMERR_INVALID_QUERY_APP_WND      85
#define IC_HMERR_HELPTABLE_UNDEFINE         86
#define IC_HMERR_HELP_INSTANCE_UNDEFINE     87
#define IC_HMERR_HELPITEM_NOT_FOUND         88
#define IC_HMERR_INDEX_NOT_FOUND            89
#define IC_HMERR_CONTENT_NOT_FOUND          90
#define IC_HMERR_OPEN_LIB_FILE              91
#define IC_HMERR_READ_LIB_FILE              92
#define IC_HMERR_CLOSE_LIB_FILE             93
#define IC_HMERR_INVALID_LIB_FILE           94
#define IC_HMERR_NO_MEMORY                  95
#define IC_HMERR_FREE_MEMORY                96
#define IC_HMERR_PANEL_NOT_FOUND            97
#define IC_HMERR_DATABASE_NOT_OPEN          98
#define IC_HMERR_UNKNOWN                    99
#define IC_THREAD_NOT_PROCESSING_MSGS       100
#define IC_FRAME_EXTENSION_IN_USE           101
#define IC_HMERR_FONT_ERROR                 102
#define IC_FONT_ACCESS_ERROR                103
#define IC_NOSTATUSTEXTLINE                 104

#define IC_DDE_SERVER_IN_CONVERSATION       121
#define IC_DDE_CLIENT_NOT_IN_CONVERSATION   122
#define IC_DDE_SERVER_NOT_IN_CONVERSATION   123
#define IC_DDE_WINDDEINITIATE               124
#define IC_DDE_WINDDEPOSTMESSAGE_USER       125
#define IC_DDE_HOTLINK_ACTIVE               128
#define IC_DDE_HOTLINK_PENDING              129
#define IC_DDE_NO_HOTLINK                   130
#define IC_DDE_NO_HOTLINKS                  131
#define IC_DDE_NO_HOTLINKS_ITEM             132
#define IC_DDE_END_HOTLINK_PENDING          133
#define IC_DDE_END_HOTLINKS_ITEM_PENDING    134
#define IC_DDE_END_HOTLINKS_PENDING         135
#define IC_DDE_SYNCHRONIZATION              136
#define IC_SLDR_RECT_TOO_SMALL              137
#define IC_INVALID_RANGE_OPERATION          138
#define IC_INVALID_TEXT_OPERATION           139
#define IC_SET_SPIN_ARRAY_FAIL              140
#define IC_SETMENUITEM_FAIL                 141
#define IC_INVALID_MENUITEM                 142
#define IC_NO_SYSTEMMENU                    143
#define IC_NO_FRAME_MENUBAR                 144
#define IC_NO_BITMAP_HANDLE                 145
#define IC_VALUE_OUT_OF_RANGE               146
#define IC_NO_MENU_SELECTED                 147
#define IC_ADD_SUBMENU_FAIL                 148
#define IC_NO_TITLEBAR                      149
#define IC_SLDR_SET_CTLDATA                 150
#define IC_SLDR_GET_CTLDATA                 151
#define IC_NO_SUBMENU                       152
#define IC_NO_HELP_COVERPAGE                153
#define IC_INVALID_INDEX                    154
#define IC_UNKNOWN_RENDERING_FORMAT         155
#define IC_UNKNOWN_RENDERING_MECHANISM      156
#define IC_RFPROCESS_FOR_SAME_PROCESS       157
#define IC_RENDER_AT_SOURCE_FAILED          158
#define IC_DRAGTRANSFER_INVALID             159
#define IC_NO_SOURCE_OBJECT_SUPPLIED        160
#define IC_INDEX_OUT_OF_RANGE               161
#define IC_TARGET_ITEM_PROVIDER_FAILED      162
#define IC_DRAGITEM_INVALID                 163
#define IC_CLIPBOARD_LOCKED                 164
#define IC_CLIPBOARD_TRUNCATE               165
#define IC_INVALID_FRAME_SHELL              166
#define IC_SLDR_INVALID_TICK_COUNT          167
#define IC_SLDR_INVALID_TICK_NUMBER         168
#define IC_SLDR_INVALID_PIXEL               169


#define IC_APPLICATION_INITIALIZE           170
#define IC_MODIFIER_MISMATCH                171
#define IC_INVALID_TIMER_ID                 172
#define IC_TIMER_STARTED                    173
#define IC_TIMER_ID_UNAVAILABLE             174

#define IC_INVALID_CLASS                    180
#define IC_INVALID_VISIBLECOUNT             181
#define IC_NAME_NOT_FOUND                   182
#define IC_TEXT_NOT_FOUND                   183
#define IC_EMPTY_LIST                       184
#define IC_GUI_ERROR                        185
#define IC_SYSTEM_ERROR                     186
#define IC_INVALID_SETTEXT                  187
#define IC_TOOLBAR_ADD_INVALID              188
#define IC_TOOLBAR_SETLOCATION_INVALID      189
#define IC_NUMSPIN_WRAP_INVALID             190
#define IC_TXTSPIN_WRAP_INVALID             191
#define IC_SPINTO_TEXT_INVALID              192
#define IC_NO_SELECTION                     193 /* IListBox and IComboBox */
#define IC_SINGLE_SELECT_LIST               194 /* IListBox and IComboBox */

#define IC_TOOLBARCNR_EXPLICITADDS          199
#define IC_BUTTON_ALREADY_ADDED             200

#define IC_LABEL_ABORT                      201
#define IC_LABEL_RETRY                      202
#define IC_LABEL_IGNORE                     203
#define IC_LABEL_ENTER                      204
#define IC_LABEL_HELP                       205
#define IC_LABEL_APPLY                      206
#define IC_LABEL_RESET                      207
#define IC_LABEL_OK                         208
#define IC_LABEL_CANCEL                     209
#define IC_INVALID_PICTURE_ID               210
#define IC_INVALID_PICTURE_QUOTE            211
#define IC_INVALID_PICTURE_RANGE            212
#define IC_FFBMP                            213
#define IC_REWBMP                           214
#define IC_RECBMP                           215
#define IC_PAUSEBMP                         216
#define IC_TRKRBMP                          217
#define IC_TRKABMP                          218
#define IC_STOPBMP                          219
#define IC_STEPFBMP                         220
#define IC_STEPBBMP                         221
#define IC_EJECTBMP                         222
#define IC_SCANFBMP1                        223
#define IC_SCANFBMP2                        224
#define IC_SCANFBMP3                        225
#define IC_SCANFBMP4                        226
#define IC_SCANFBMP5                        227
#define IC_SCANFBMP6                        228
#define IC_SCANBBMP1                        229
#define IC_SCANBBMP2                        230
#define IC_SCANBBMP3                        231
#define IC_SCANBBMP4                        232
#define IC_SCANBBMP5                        233
#define IC_SCANBBMP6                        234
#define IC_PLAYBMP1                         235
#define IC_PLAYBMP2                         236
#define IC_PLAYBMP3                         237
#define IC_PLAYBMP4                         238
#define IC_PLAYBMP5                         239
#define IC_MUTEBMP                          240
#define IC_VOLUPBMP                         241
#define IC_VOLDNBMP                         242

#define IC_LABEL_FILTER                     249 /* Motif IFileDialog */
#define IC_MAPPOINT_FAILED                  250
#define IC_LABEL_YES                        251
#define IC_LABEL_NO                         252
#define IC_LABEL_FONTDLG_SEL                253
#define IC_LABEL_FONTDLG_POINTSEL           254
#define IC_NOCLIPBOARDDATA                  255
#define IC_REGISTERCLIPBOARDFORMATFAILED    256
#define IC_CLIPBOARDFORMATNOTFOUND          257

// The following identifiers are used for exception handling in the GBM
// image handling code.

#define IC_GBM_UNKNOWN_ERROR                258
#define IC_GBM_OPEN_FAILED                  259
#define IC_GBM_CREATE_FAILED                260
#define IC_GBM_NO_SUPPORT                   261
#define IC_GBM_HDC_FAILED                   262
#define IC_GBM_HPS_FAILED                   263
#define IC_GBM_METAFILE_FAILED              264
#define IC_GBM_BITMAP_FAILED                265
#define IC_GBM_NEED_CLIPPED                 266
#define IC_GBM_NOT_SUPPORTED                267
#define IC_GBM_BAD_OPTION                   268
#define IC_GBM_NOT_FOUND                    269
#define IC_GBM_BAD_MAGIC                    270
#define IC_GBM_BAD_SIZE                     271
#define IC_GBM_READ_FAILED                  272
#define IC_GBM_WRITE_FAILED                 273
#define IC_GBM_BMP_PLANES                   274
#define IC_GBM_BMP_BITCOUNT                 275
#define IC_GBM_BMP_CBFIX                    276
#define IC_GBM_BMP_COMP                     277
#define IC_GBM_BMP_OFFSET                   278
#define IC_GBM_GIF_BPP                      279
#define IC_GBM_GIF_TERM                     280
#define IC_GBM_GIF_CODE_SIZE                281
#define IC_GBM_GIF_CORRUPT                  282
#define IC_GBM_IAX_SIZE                     283
#define IC_GBM_KPS_OPEN                     284
#define IC_GBM_KPS_CREATE                   285
#define IC_GBM_LBM_FORM                     286
#define IC_GBM_LBM_ILBM                     287
#define IC_GBM_LBM_BMHD_2                   288
#define IC_GBM_LBM_BMHD_0                   289
#define IC_GBM_LBM_BMHD_SIZE                290
#define IC_GBM_LBM_BPP                      291
#define IC_GBM_LBM_CMAP_SIZE                292
#define IC_GBM_LBM_COMP                     293
#define IC_GBM_LBM_CAMG_SIZE                294
#define IC_GBM_LBM_SHAM_VER                 295
#define IC_GBM_PCX_BAD_VERSION              296
#define IC_GBM_PCX_BAD_ENCMODE              297
#define IC_GBM_PCX_BAD_BITS                 298
#define IC_GBM_PCX_BAD_TRAILER              299
#define IC_GBM_PGM_BAD_M                    300
#define IC_GBM_PSEG_NOT_5A                  301
#define IC_GBM_PSEG_BAD_RECORD              302
#define IC_GBM_PSEG_SIZE                    303
#define IC_GBM_PSEG_INV_WIDTH               304
#define IC_GBM_PSEG_INV_DEFCEL              305
#define IC_GBM_PSEG_INV_CEL                 306
#define IC_GBM_PSEG_INV_CELPOS              307
#define IC_GBM_PSEG_UNEX_REC                308
#define IC_GBM_SPR_FIRST                    309
#define IC_GBM_SPR_MODE                     310
#define IC_GBM_SPR_OFFSET                   311
#define IC_GBM_SPR_PAL8                     312
#define IC_GBM_TGA_BAD_BPP                  313
#define IC_GBM_TGA_BAD_TYPE                 314
#define IC_GBM_TGA_BAD_PAL                  315
#define IC_GBM_TIF_VERSION                  316
#define IC_GBM_TIF_N_TAGS                   317
#define IC_GBM_TIF_TAG_TYPE                 318
#define IC_GBM_TIF_HEADER                   319
#define IC_GBM_TIF_MISSING_TAG              320
#define IC_GBM_TIF_SPP_BIT                  321
#define IC_GBM_TIF_BPS_BIT                  322
#define IC_GBM_TIF_SPP_RGB                  323
#define IC_GBM_TIF_BPS_RGB                  324
#define IC_GBM_TIF_SPP_PAL                  325
#define IC_GBM_TIF_BPS_PAL                  326
#define IC_GBM_TIF_SPP_CMYK                 327
#define IC_GBM_TIF_BPS_CMYK                 328
#define IC_GBM_TIF_COMP_1D_MH               329
#define IC_GBM_TIF_COMP_T4                  330
#define IC_GBM_TIF_COMP_T6                  331
#define IC_GBM_TIF_COMP                     332
#define IC_GBM_TIF_COLORMAP                 333
#define IC_GBM_TIF_CORRUPT                  334
#define IC_GBM_TIF_PREDICTOR                335
#define IC_GBM_TIF_PHOTO_TRANS              336
#define IC_GBM_TIF_PHOTO_Y_Cb_Cr            337
#define IC_GBM_TIF_PHOTO                    338
#define IC_GBM_TIF_FILLORDER                339
#define IC_GBM_TIF_PLANARCONFIG_1           340
#define IC_GBM_TIF_PLANARCONFIG_12          341
#define IC_GBM_TIF_INKSET                   342
#define IC_GBM_TIF_ORIENT                   343
#define IC_GBM_TIF_INDEX                    344
#define IC_GBM_VID_BAD_W                    345
#define IC_GBM_XBM_EXP_ID                   346
#define IC_GBM_XBM_UNEXP_EOF                347
#define IC_GBM_XBM_EXP_CHAR                 348
#define IC_GBM_XBM_EXP_LSQR                 349
#define IC_GBM_XBM_EXP_RSQR                 350
#define IC_GBM_XBM_EXP_EQUALS               351
#define IC_GBM_XBM_EXP_LCUR                 352
#define IC_GBM_XBM_EXP_RCUR                 353
#define IC_GBM_XBM_EXP_COMMA                354
#define IC_GBM_XBM_EXP_NUMBER               355
#define IC_GBM_XBM_EXP_SEMI                 356

#define IC_TOOLBAR_POINTER_TOP              357
#define IC_TOOLBAR_POINTER_BOTTOM           358
#define IC_TOOLBAR_POINTER_LEFT             359
#define IC_TOOLBAR_POINTER_RIGHT            360
#define IC_TOOLBAR_POINTER_TOP_2            361
#define IC_TOOLBAR_POINTER_BOTTOM_2         362
#define IC_TOOLBAR_POINTER_LEFT_2           363
#define IC_TOOLBAR_POINTER_RIGHT_2          364

#define IC_LABEL_FONTDLG_STYLESEL           365
#define IC_LABEL_FONTDLG_BOLD               366
#define IC_LABEL_FONTDLG_BOLDITALIC         367
#define IC_LABEL_FONTDLG_ITALIC             368
#define IC_LABEL_FONTDLG_REGULAR            369

// Note: 370 through 399 reserved for collections.
#define IC_CHILD_ALREADY_EXISTS             370
#define IC_COLLECTION_IS_EMPTY              371
#define IC_CURSOR_NOT_CONTAINED             372
#define IC_CURSOR_NOT_FOR_GIVEN             373
#define IC_CURSOR_NOT_FOR_THIS              374
#define IC_IDENTICAL_COLLECTION             375
#define IC_INVALID_CURSOR                   376
#define IC_INVALID_POSITION                 377
#define IC_INVALID_REPLACEMENT              378
#define IC_KEY_ALREADY_EXISTS               379
#define IC_KEY_NOT_CONTAINED                380
#define IC_NOT_BOUNDED                      381
#define IC_OUT_OF_COLLECTION_MEMORY         382
#define IC_ROOT_ALREADY_EXISTS              383
#define IC_CYCLIC_CHILD_ATTACHMENT          384
#define IC_NO_MUTEX_AVAILABLE               385
#define IC_LOCK_FAILED                      386
#define IC_LOCK_TIMEOUT                     387
#define IC_UNLOCK_FAILED                    388
#define IC_STREAM_VERSION_ERROR             389
#define IC_STREAMER_INVALID                 390
#define IC_COLLECTION_IS_FULL               391
#define IC_COLLECTION_NOT_EMPTY             392


// Note: 400 through 430 in icconsta.h and used by streams.
#define IC_CDF_UNTITLED_NAME                450
#define IC_CDF_INSERT_FAILED                451
#define IC_CDF_OPEN_FAILED                  452
#define IC_CDF_DISCARD                      453
#define IC_CDF_SAVE                         454
#define IC_CDF_SAVE_FAILED                  455
#define IC_CDF_EMBEDDED_TITLE               456
#define IC_CDF_ACTIVATE_FAILED              457
#define IC_CDF_IN_PLACE_FRAME_NAME          458

// Note: 550 through 650 in icconst.h and reserved for base

// IProcessHandle errors
#define IC_PRCH_ALREADYSTARTED              550
#define IC_PRCH_SETPATH                     551
#define IC_PRCH_SETENV                      552
#define IC_PRCH_INVALID_PRIORITY            553
#define IC_PRCH_START                       554
#define IC_PRCH_ENV_BUFFER_FULL             555
#define IC_PRCH_CANT_GET_PRIO               556
#define IC_PRCH_CANT_SET_PRIO               557
#define IC_PRCH_UNKNOWN_PRIO                558
#define IC_PRCH_CANT_START                  559
#define IC_PRCH_CANT_KILL                   560
#define IC_PRCH_NOT_SUPPORTED               561
#define IC_PRCH_ERROR_WAITING_ON            562
#define IC_PRCH_EXE_NOT_FOUND               563
#define IC_PRCH_BAD_PATH                    564

#define IC_PRCH_FIRST                       550 // Keep these in sync!!
#define IC_PRCH_LAST                        564

// ICondition errors
#define IC_COND_NOT_FOUND                   565
#define IC_COND_TIMEOUT                     566
#define IC_COND_OWNER_DIED                  567
#define IC_COND_ALREADY_OWNED               568
#define IC_COND_TOOMANY                     569
#define IC_COND_HOSTERR                     570
#define IC_COND_INVALID                     571

#define IC_COND_FIRST                       565 // Keep these in sync!!
#define IC_COND_LAST                        571

// Note: late additions; hoping this is a suitable place
#define IC_INVALID_MENU_WRAPPER             572

// Note: 651 through 700 in icconst.h are reserved for Visible Properties & Actions
#define IC_ACTION_HAS_NO_FUNCTOR            651
#define IC_ACTION_ALREADY_HAS_A_FUNCTOR     652
#define IC_UNIQUEID_LIMIT_EXCEEDED          653
#define IC_MATCHES_ANOTHER_KIND             654
#define IC_VPAKEY_ALREADY_EXISTS            655
#define IC_INTERNAL_VPA_ID_ALREADY_EXISTS   656
#define IC_ITEM_HAS_NO_CONTEXT              657
#define IC_OWNER_IS_NOT_A_ACTIONMENUBAR     658
#define IC_OWNER_IS_NOT_A_ACTIONPOPUPMENU   659
#define IC_NOT_VPA_REGISTERED               660
#define IC_DOES_NOT_HAVE_THIS_RESOURCE_ID   661
#define IC_INTERNAL_INVALID_STREAM_DELIMITER 662
#define IC_DOES_NOT_HAVE_THIS_APPEARANCE    663
#define IC_UNKNOWN_PROPERTY_TYPE            664
#define IC_ATTEMPT_TO_CHANGE_A_STANDARD_ITEM 665
#define IC_REQUIRED_RESOURCE_CANNOT_BE_ZERO 666
#define IC_OWNER_IS_NOT_A_ACTIONTOOLBAR     667
#define IC_INTERNAL_ORDER_OF_DESTRUCTION_ERROR 668
#define IC_ENVIRONMENT_VARIABLE_CPPLOCAL_NOT_DEFINED 669
#define IC_CANNOT_REGISTER_EXITHANDLER      670


#define IC_DEFAULT_FRAME_ID                 1000
#define IC_FRAME_MENU_ID                    0x8005
#define IC_FRAME_CLIENT_ID                  0x8008

// The following are standard identifiers for push buttons.
// Majority used in IMessageWindow.  IC_ID_HELP is used
// in that class but is defined below for IToolBarButtons
#define IC_ID_OK                            1
#define IC_ID_CANCEL                        2
#define IC_ID_ENTER                         3
#define IC_ID_ABORT                         4
#define IC_ID_RETRY                         5
#define IC_ID_IGNORE                        6
#define IC_ID_YES                           7
#define IC_ID_NO                            8
#define IC_ID_APPLY                         9
#define IC_ID_RESET                        10

// The following identifiers are defined for IFileDialog and IFontDialog
// portability.
#ifdef IC_WIN
#define IC_FILE_DIALOG                      1536
#define IC_FILE_DIALOG_MULTSELECT           1537
#define IC_ID_FILEOK                        IC_ID_OK
#define IC_ID_FILECANCEL                    IC_ID_CANCEL
#define IC_ID_FILEAPPLY                     0x0402
#define IC_FONT_DIALOG                      1542
#define IC_ID_FONTOK                        IC_ID_OK
#define IC_ID_FONTCANCEL                    IC_ID_CANCEL
#define IC_ID_FONTAPPLY                     0x0402
#endif
#ifdef IC_PM
#define IC_FILE_DIALOG                      256
#define IC_FILE_DIALOG_MULTSELECT           256
#define IC_FONT_DIALOG                      300
#define IC_ID_FILEOK                        IC_ID_OK
#define IC_ID_FILECANCEL                    IC_ID_CANCEL
#define IC_ID_FILEAPPLY                     268
#define IC_ID_FONTOK                        IC_ID_OK
#define IC_ID_FONTCANCEL                    IC_ID_CANCEL
#define IC_ID_FONTAPPLY                     311
#endif
#ifdef IC_MOTIF
#define IC_FILE_DIALOG                      256
#define IC_FILE_DIALOG_MULTSELECT           256
#define IC_FONT_DIALOG                      300
#endif

// The following identifiers represent common system commands.
#ifdef IC_MOTIF
#define IC_ID_CLOSE                         0x8004
#ifndef IC_MOTIF_FLAGNOP
#define IC_ID_MOVE                          0x8001
#define IC_ID_SIZE                          0x8000
#define IC_ID_MINIMIZE                      0x8002
#define IC_ID_MAXIMIZE                      0x8003
#define IC_ID_SYSHIDE                       0x802a
#define IC_ID_RESTORE                       0x8008
#define IC_ID_WINDOWLIST                    0x8011
#endif
#endif

#ifdef IC_PM
#define IC_ID_CLOSE                         0x8004
#define IC_ID_MOVE                          0x8001
#define IC_ID_SIZE                          0x8000
#define IC_ID_MINIMIZE                      0x8002
#define IC_ID_MAXIMIZE                      0x8003
#define IC_ID_SYSHIDE                       0x802a
#define IC_ID_RESTORE                       0x8008
#define IC_ID_WINDOWLIST                    0x8011
#endif

#ifdef IC_WIN
#define IC_ID_CLOSE                         0xF060
#define IC_ID_MOVE                          0xF010
#define IC_ID_SIZE                          0xF000
#define IC_ID_MINIMIZE                      0xF020
#define IC_ID_MAXIMIZE                      0xF030
#define IC_ID_SYSHIDE                       0xF020
#define IC_ID_RESTORE                       0xF120
#define IC_ID_WINDOWLIST                    0xF130
#endif


#ifndef IC_ID_BASE
  #define IC_ID_BASE                        (0x7000)
#endif

// The following identifiers are defined and may be used when constructing
// IToolBarButtons for standard operations.  The IDs are documented for
// use by the customer.  Please note that they are in numerical sequence,
// as required by a customer.  They are also ordered consistently with the
// IOC Samples and IOC documentation.  Any additions to this list should
// be placed at the end.
#define IC_ID_CANCELOPERATION               (IC_ID_BASE + 0x0001)
#define IC_ID_EXIT                          (IC_ID_BASE + 0x0002)
#define IC_ID_OPEN                          (IC_ID_BASE + 0x0003)
#define IC_ID_NEW                           (IC_ID_BASE + 0x0004)
#define IC_ID_SAVE                          (IC_ID_BASE + 0x0005)
#define IC_ID_SAVE_AS                       (IC_ID_BASE + 0x0006)
#define IC_ID_LOCATE                        (IC_ID_BASE + 0x0007)
#define IC_ID_CUT                           (IC_ID_BASE + 0x0008)
#define IC_ID_COPY                          (IC_ID_BASE + 0x0009)
#define IC_ID_PASTE                         (IC_ID_BASE + 0x000A)
#define IC_ID_PASTESPECIAL                  (IC_ID_BASE + 0x000B)
#define IC_ID_PASTELINK                     (IC_ID_BASE + 0x000C)
#define IC_ID_HELP                          (IC_ID_BASE + 0x000D)
#define IC_ID_GENERALHELP                   (IC_ID_BASE + 0x000E)
#define IC_ID_HELPINDEX                     (IC_ID_BASE + 0x000F)
#define IC_ID_HELPTUTORIAL                  (IC_ID_BASE + 0x0010)
#define IC_ID_USINGHELP                     (IC_ID_BASE + 0x0011)
#define IC_ID_DESELECTALL                   (IC_ID_BASE + 0x0012)
#define IC_ID_SELECTALL                     (IC_ID_BASE + 0x0013)
#define IC_ID_INSERTCOLUMN                  (IC_ID_BASE + 0x0014)
#define IC_ID_DELETECOLUMNS                 (IC_ID_BASE + 0x0015)
#define IC_ID_INSERTROW                     (IC_ID_BASE + 0x0016)
#define IC_ID_DELETEROWS                    (IC_ID_BASE + 0x0017)
#define IC_ID_UNDO                          (IC_ID_BASE + 0x0018)
#define IC_ID_REDO                          (IC_ID_BASE + 0x0019)
#define IC_ID_CHECKSPELLING                 (IC_ID_BASE + 0x001A)
#define IC_ID_NORMAL                        (IC_ID_BASE + 0x001B)
#define IC_ID_ABOUT                         (IC_ID_BASE + 0x001C)
#define IC_ID_UPDATE                        (IC_ID_BASE + 0x001D)
#define IC_ID_MAILSEND                      (IC_ID_BASE + 0x001E)
#define IC_ID_MOVEPAGES                     (IC_ID_BASE + 0x001F)
#define IC_ID_PRINT                         (IC_ID_BASE + 0x0020)
#define IC_ID_PRINTPREVIEW                  (IC_ID_BASE + 0x0021)
#define IC_ID_PRINTSETUP                    (IC_ID_BASE + 0x0022)
#define IC_ID_SORTAZ                        (IC_ID_BASE + 0x0023)
#define IC_ID_SORTZA                        (IC_ID_BASE + 0x0024)
#define IC_ID_SORTUP                        (IC_ID_BASE + 0x0025)
#define IC_ID_SORTDOWN                      (IC_ID_BASE + 0x0026)
#define IC_ID_SETTINGS                      (IC_ID_BASE + 0x0027)
#define IC_ID_TOOLBAR                       (IC_ID_BASE + 0x0028)
#define IC_ID_TOOLBARSETUP                  (IC_ID_BASE + 0x0029)
#define IC_ID_RUNSCRIPT                     (IC_ID_BASE + 0x002A)
#define IC_ID_VPAPALETTE                    (IC_ID_BASE + 0x002B)
#define IC_ID_TOUR                          (IC_ID_BASE + 0x002C)
#define IC_ID_LEFTALIGNOBJ                  (IC_ID_BASE + 0x002D)
#define IC_ID_RIGHTALIGNOBJ                 (IC_ID_BASE + 0x002E)
#define IC_ID_ZOOM                          (IC_ID_BASE + 0x002F)
#define IC_ID_ZOOMIN                        (IC_ID_BASE + 0x0030)
#define IC_ID_ZOOMOUT                       (IC_ID_BASE + 0x0031)
#define IC_ID_LOGON                         (IC_ID_BASE + 0x0032)
#define IC_ID_LOGOFF                        (IC_ID_BASE + 0x0033)
#define IC_ID_BOLD                          (IC_ID_BASE + 0x0034)
#define IC_ID_ITALIC                        (IC_ID_BASE + 0x0035)
#define IC_ID_UNDERSCORE                    (IC_ID_BASE + 0x0036)
#define IC_ID_DOUBLEUNDERSCORE              (IC_ID_BASE + 0x0037)
#define IC_ID_CENTER                        (IC_ID_BASE + 0x0038)
#define IC_ID_LEFT                          (IC_ID_BASE + 0x0039)
#define IC_ID_RIGHT                         (IC_ID_BASE + 0x003A)
#define IC_ID_JUSTIFY                       (IC_ID_BASE + 0x003B)
#define IC_ID_CLEAR                         (IC_ID_BASE + 0x003C)
#define IC_ID_DELETE                        (IC_ID_BASE + 0x003D)
#if (IC_OBSOLETE <= IC_OBSOLETE_3)
  // COPYTO "means" the same thing as SAVE_AS, "Save As" is the standard term.
  // For back compatibility, keep the old label but change the value to match
  // SAVE_AS.  The COPYTO ID should be obsoleted.
  #define IC_ID_COPYTO                      (IC_ID_SAVE_AS)
#endif

// The following identifiers represent the transparent versions of the
// toolbar button bitmaps.  These have been replaced by larger,
// non-transparent versions.  They are supported for compatability with
// previous releases.  They are obsoleted.
#if (IC_OBSOLETE <= IC_OBSOLETE_3)
  #define IC_ID_TRANS_NEW                   (IC_ID_BASE + 0x0060)
  #define IC_ID_TRANS_ABOUT                 (IC_ID_BASE + 0x0061)
  #define IC_ID_TRANS_OPEN                  (IC_ID_BASE + 0x0062)
  #define IC_ID_TRANS_SAVE                  (IC_ID_BASE + 0x0063)
  #define IC_ID_TRANS_PRINT                 (IC_ID_BASE + 0x0064)
  #define IC_ID_TRANS_LOCATE                (IC_ID_BASE + 0x0065)
  #define IC_ID_TRANS_CUT                   (IC_ID_BASE + 0x0066)
  #define IC_ID_TRANS_COPY                  (IC_ID_BASE + 0x0067)
  #define IC_ID_TRANS_PASTE                 (IC_ID_BASE + 0x0068)
  #define IC_ID_TRANS_HELP                  (IC_ID_BASE + 0x0069)
  #define IC_ID_TRANS_BOLD                  (IC_ID_BASE + 0x006A)
  #define IC_ID_TRANS_ITALIC                (IC_ID_BASE + 0x006B)
  #define IC_ID_TRANS_UNDERSCORE            (IC_ID_BASE + 0x006C)
  #define IC_ID_TRANS_DEFAULT               (IC_ID_BASE + 0x006D)
  #define IC_ID_TRANS_SETTINGS              (IC_ID_BASE + 0x006E)
  #define IC_ID_TRANS_COPYTO                (IC_ID_BASE + 0x0070)
#endif // IC_OBSOLETE

#define IC_ID_INFO                          (IC_ID_BASE + 0x0080)

#ifdef IC_WIN
// The following ids are defined for use in constructing the frame
// window scroll bars.
#define FID_VERTSCROLL                      (IC_ID_BASE + 0x0091)
#define FID_HORZSCROLL                      (IC_ID_BASE + 0x0092)
#endif // IC_WIN

// The following identifiers are defined and used by the class libary
// when constructing special IToolBarButtons.
#define IC_ID_DEFAULT                       (IC_ID_BASE + 0x0101)
#define IC_ID_OWNERMOVE                     (IC_ID_BASE + 0x0102)
#define IC_ID_NOOWNERMOVE                   (IC_ID_BASE + 0x0103)
#define IC_ID_SHOWHIDE                      (IC_ID_BASE + 0x0104)
#define IC_ID_SHOW                          (IC_ID_BASE + 0x0105)
#define IC_ID_HIDE                          (IC_ID_BASE + 0x0106)

#define IC_SMALLSYSTEMMENU                  (IC_ID_BASE + 0x0111)
#define IC_FADEICON                         (IC_ID_BASE + 0x0112)
#define IC_FF                               (IC_ID_BASE + 0x0113)
#define IC_REWIND                           (IC_ID_BASE + 0x0114)
#define IC_RECORD                           (IC_ID_BASE + 0x0115)
#define IC_PAUSE                            (IC_ID_BASE + 0x0116)
#define IC_TRKR                             (IC_ID_BASE + 0x0117)
#define IC_TRKA                             (IC_ID_BASE + 0x0118)
#define IC_STOP                             (IC_ID_BASE + 0x0119)
#define IC_STEPF                            (IC_ID_BASE + 0x011A)
#define IC_STEPB                            (IC_ID_BASE + 0x011B)
#define IC_EJECT                            (IC_ID_BASE + 0x011C)
#define IC_SCANF1                           (IC_ID_BASE + 0x011D)
#define IC_SCANF2                           (IC_ID_BASE + 0x011E)
#define IC_SCANF3                           (IC_ID_BASE + 0x011F)
#define IC_SCANF4                           (IC_ID_BASE + 0x0120)
#define IC_SCANF5                           (IC_ID_BASE + 0x0121)
#define IC_SCANF6                           (IC_ID_BASE + 0x0122)
#define IC_SCANB1                           (IC_ID_BASE + 0x0123)
#define IC_SCANB2                           (IC_ID_BASE + 0x0124)
#define IC_SCANB3                           (IC_ID_BASE + 0x0125)
#define IC_SCANB4                           (IC_ID_BASE + 0x0126)
#define IC_SCANB5                           (IC_ID_BASE + 0x0127)
#define IC_SCANB6                           (IC_ID_BASE + 0x0128)
#define IC_PLAY1                            (IC_ID_BASE + 0x0129)
#define IC_PLAY2                            (IC_ID_BASE + 0x012A)
#define IC_PLAY3                            (IC_ID_BASE + 0x012B)
#define IC_PLAY4                            (IC_ID_BASE + 0x012C)
#define IC_PLAY5                            (IC_ID_BASE + 0x012D)
#define IC_MUTE                             (IC_ID_BASE + 0x012E)
#define IC_VOLUP                            (IC_ID_BASE + 0x012F)
#define IC_VOLDN                            (IC_ID_BASE + 0x0130)
#define IC_COLLAPSEICON                     (IC_ID_BASE + 0x0131)
#define IC_EXPANDICON                       (IC_ID_BASE + 0x0132)
#define IC_INUSEICON                        (IC_ID_BASE + 0x0133)
#define IC_SMALLINUSEICON                   (IC_ID_BASE + 0x0134)
#define IC_BMPHALFTONE                      (IC_ID_BASE + 0x0135)
#define IC_BMPDENSE1                        (IC_ID_BASE + 0x0136)
#define IC_BMPDENSE2                        (IC_ID_BASE + 0x0137)
#define IC_BMPDENSE3                        (IC_ID_BASE + 0x0138)
#define IC_BMPDENSE4                        (IC_ID_BASE + 0x0139)
#define IC_BMPDENSE5                        (IC_ID_BASE + 0x013A)
#define IC_BMPDENSE6                        (IC_ID_BASE + 0x013B)
#define IC_BMPDENSE7                        (IC_ID_BASE + 0x013C)
#define IC_BMPDENSE8                        (IC_ID_BASE + 0x013D)
#define IC_BMPFDIAG2                        (IC_ID_BASE + 0x013E)
#define IC_BMPBDIAG2                        (IC_ID_BASE + 0x013F)

// The following are cursors used during drag and drop.
#define IC_DM_NO                            (IC_ID_BASE + 0x0141)
#define IC_DM_COPY                          (IC_ID_BASE + 0x0142)
#define IC_DM_SHORTCUT                      (IC_ID_BASE + 0x0143)

// The following are menu items used during non-default drag and drop.
#define IC_DM_MI_MOVE                       (IC_ID_BASE + 0x0144)
#define IC_DM_MI_COPY                       (IC_ID_BASE + 0x0145)
#define IC_DM_MI_SHORTCUT                   (IC_ID_BASE + 0x0146)
#define IC_DM_MI_CANCEL                     (IC_ID_BASE + 0x0147)

// The following are used by ISystemPointerHandle on AIX
#define IC_SYSPTR_INFORMATION               (IC_ID_BASE + 0x0150)
#define IC_SYSPTR_QUESTION                  (IC_ID_BASE + 0x0151)
#define IC_SYSPTR_ERROR                     (IC_ID_BASE + 0x0152)
#define IC_SYSPTR_WARNING_ILLEGAL           (IC_ID_BASE + 0x0153)
#define IC_SYSPTR_ARROW                     (IC_ID_BASE + 0x0154)
#define IC_SYSPTR_MOVE                      (IC_ID_BASE + 0x0155)
#define IC_SYSPTR_TEXT                      (IC_ID_BASE + 0x0156)
#define IC_SYSPTR_WAIT                      (IC_ID_BASE + 0x0157)
#define IC_SYSPTR_SIZEUPLEFT                (IC_ID_BASE + 0x0158)
#define IC_SYSPTR_SIZEUPRIGHT               (IC_ID_BASE + 0x0159)
#define IC_SYSPTR_SIZEDOWNRIGHT             (IC_ID_BASE + 0x015A)
#define IC_SYSPTR_SIZEDOWNLEFT              (IC_ID_BASE + 0x015B)
#define IC_SYSPTR_SIZELEFT                  (IC_ID_BASE + 0x015C)
#define IC_SYSPTR_SIZERIGHT                 (IC_ID_BASE + 0x015D)
#define IC_SYSPTR_SIZEUP                    (IC_ID_BASE + 0x015E)
#define IC_SYSPTR_SIZEDOWN                  (IC_ID_BASE + 0x015F)
#define IC_SYSPTR_SIZEHORIZONTAL            (IC_ID_BASE + 0x0160)
#define IC_SYSPTR_SIZEVERTICAL              (IC_ID_BASE + 0x0161)

// The following are used by ISystemBitmapHandle on AIX
#define IC_SYSBMP_SYSTEMMENU                (IC_ID_BASE + 0x0170)
#define IC_SYSBMP_MINIMIZE                  (IC_ID_BASE + 0x0171)
#define IC_SYSBMP_MAXIMIZE                  (IC_ID_BASE + 0x0172)
#define IC_SYSBMP_MENUCHECKMARK             (IC_ID_BASE + 0x0173)
#define IC_SYSBMP_RESTOREBUTTON             (IC_ID_BASE + 0x0174)
#define IC_SYSBMP_FILE                      (IC_ID_BASE + 0x0175)

// The following are IDs of child windows created by IViewPort.
#define IC_VIEWPORT_VERTSCROLLBAR           (IC_ID_BASE + 0x0201)
#define IC_VIEWPORT_HORZSCROLLBAR           (IC_ID_BASE + 0x0202)
#define IC_VIEWPORT_VIEWRECTANGLE           (IC_ID_BASE + 0x0203)

// The following are used by Compound Document Framework.
// Please note that Compound Document Framework also uses defines
// from the toolbarbutton list above, such as:  IC_ID_NEW, IC_ID_SAVE_AS,
// IC_ID_EXIT, IC_ID_UNDO, IC_ID_TOOLBAR, IC_ID_ABOUT, IC_ID_UPDATE,
// IC_ID_PASTESPECIAL, IC_ID_PASTELINK, IC_ID_DESELECTALL and IC_ID_DELETE
#define IC_ID_FILE                          (IC_ID_BASE + 0x0301)
#define IC_ID_EDIT                          (IC_ID_BASE + 0x0302)
#define IC_ID_VIEW                          (IC_ID_BASE + 0x0303)
#define IC_ID_INSERT                        (IC_ID_BASE + 0x0304)
#define IC_ID_SAVE_COPY_AS                  (IC_ID_BASE + 0x0312)
#define IC_ID_VERB0                         (IC_ID_BASE + 0x0315)
#define IC_ID_VERB1                         (IC_ID_BASE + 0x0316)
#define IC_ID_VERB2                         (IC_ID_BASE + 0x0317)
#define IC_ID_VERB3                         (IC_ID_BASE + 0x0318)
#define IC_ID_VERB4                         (IC_ID_BASE + 0x0319)
#define IC_ID_VERB5                         (IC_ID_BASE + 0x0320)
#define IC_ID_VERB6                         (IC_ID_BASE + 0x0321)
#define IC_ID_VERB7                         (IC_ID_BASE + 0x0322)
#define IC_ID_VERB8                         (IC_ID_BASE + 0x0323)
#define IC_ID_VERB9                         (IC_ID_BASE + 0x0324)
#define IC_ID_VERB10                        (IC_ID_BASE + 0x0325)
#define IC_ID_VERB11                        (IC_ID_BASE + 0x0326)
#define IC_ID_VERB12                        (IC_ID_BASE + 0x0327)
#define IC_ID_VERB13                        (IC_ID_BASE + 0x0328)
#define IC_ID_VERB14                        (IC_ID_BASE + 0x0329)
#define IC_ID_VERB15                        (IC_ID_BASE + 0x0330)
#define IC_ID_VERB16                        (IC_ID_BASE + 0x0331)
#define IC_ID_VERB17                        (IC_ID_BASE + 0x0332)
#define IC_ID_VERB18                        (IC_ID_BASE + 0x0333)
#define IC_ID_VERB19                        (IC_ID_BASE + 0x0334)
#define IC_ID_EDITLINKS                     (IC_ID_BASE + 0x0335)
#define IC_ID_CONVERT                       (IC_ID_BASE + 0x0336)

#define IC_CDF_DEFAULT_VIEW_ID              (IC_ID_BASE + 0x0401)
#define IC_CDF_STANDALONE_MENU_ID           (IC_ID_BASE + 0x0402)
#define IC_CDF_EMBEDDED_MENU_ID             (IC_ID_BASE + 0x0403)
#define IC_CDF_INPLACE_MENU_ID              (IC_ID_BASE + 0x0404)
#define IC_CDF_TOOLBAR_ID                   (IC_ID_BASE + 0x0405)
#define IC_CDF_POPUP_MENU_ID                (IC_ID_BASE + 0x0406)

#define IC_CDF_APP_START                    (IC_ID_BASE + 0x0800)
#define IC_CDF_APP_OFFSET                   (12 )

#define IC_CDF_FILE_EXT_OFFSET              (0)
#define IC_CDF_APP_SHORTNAME_OFFSET         (1)
#define IC_CDF_APP_LONGNAME_OFFSET          (2)
#define IC_CDF_PROT_EDIT_VERB_0_OFFSET      (3)
#define IC_CDF_CLSID_OFFSET                 (4)
#define IC_CDF_CLSID_AUX_3_OFFSET           (5)
#define IC_CDF_CLSID_AUX_2_OFFSET           (6)
#define IC_CDF_CLSID_VERB_1_OFFSET          (7)
#define IC_CDF_CLSID_VERB_0_OFFSET          (8)
#define IC_CDF_MAJOR_VERSION_OFFSET         (9)
#define IC_CDF_MINOR_VERSION_OFFSET         (10)

#define IC_CDF_TLID                         (IC_ID_BASE + 0x0420)

#define IC_CDF_FILE_EXT                     (IC_ID_BASE + 0x0421)
#define IC_CDF_APP_SHORTNAME                (IC_ID_BASE + 0x0422)
#define IC_CDF_APP_LONGNAME                 (IC_ID_BASE + 0x0423)
#define IC_CDF_PROT_EDIT_VERB_0             (IC_ID_BASE + 0x0424)
#define IC_CDF_CLSID                        (IC_ID_BASE + 0x0425)
#define IC_CDF_CLSID_AUX_3                  (IC_ID_BASE + 0x0426)
#define IC_CDF_CLSID_AUX_2                  (IC_ID_BASE + 0x0427)
#define IC_CDF_CLSID_VERB_1                 (IC_ID_BASE + 0x0428)
#define IC_CDF_CLSID_VERB_0                 (IC_ID_BASE + 0x0429)
#define IC_CDF_MAJOR_VERSION                (IC_ID_BASE + 0x0430)
#define IC_CDF_MINOR_VERSION                (IC_ID_BASE + 0x0431)

#define IC_CDF_MENU_TEXT_CUT                (IC_ID_BASE + 0x0440)
#define IC_CDF_MENU_TEXT_COPY               (IC_ID_BASE + 0x0441)
#define IC_CDF_MENU_TEXT_PASTE              (IC_ID_BASE + 0x0442)
#define IC_CDF_MENU_TEXT_PASTE_SPECIAL      (IC_ID_BASE + 0x0443)
#define IC_CDF_MENU_TEXT_PASTE_LINK         (IC_ID_BASE + 0x0444)
#define IC_CDF_MENU_TEXT_ALL                (IC_ID_BASE + 0x0445)
#define IC_CDF_MENU_TEXT_CTRLX              (IC_ID_BASE + 0x0446)
#define IC_CDF_MENU_TEXT_CTRLC              (IC_ID_BASE + 0x0447)
#define IC_CDF_MENU_TEXT_CTRLV              (IC_ID_BASE + 0x0448)
#define IC_CDF_MENU_TEXT_RETURN             (IC_ID_BASE + 0x0449)
#define IC_CDF_MENU_TEXT_DELETE             (IC_ID_BASE + 0x0450)

// The following are used by Visible Properties & Actions Framework.
// (so are many others in here, incl. the "standard operations"
// IC_ID_BASE+0-0FF)
#define IC_ID_ENABLEFLYOVERHELP             (IC_ID_BASE + 0x0501)
#define IC_ID_FONT                          (IC_ID_BASE + 0x0502)
#define IC_ID_FONTSIZE                      (IC_ID_BASE + 0x0503)
//#define IC_ID_FILE         already defined above
#define IC_ID_BOLDLOCK                      (IC_ID_BASE + 0x0505)
#define IC_ID_ITALICLOCK                    (IC_ID_BASE + 0x0506)
#define IC_ID_UNDERLINELOCK                 (IC_ID_BASE + 0x0507)
#define IC_ID_STRIKETHROUGHLOCK             (IC_ID_BASE + 0x0508)
#define IC_ID_SUPERSCRIPTLOCK               (IC_ID_BASE + 0x0509)
#define IC_ID_SUBSCRIPTLOCK                 (IC_ID_BASE + 0x050A)
#define IC_ID_JUSTIFYLOCK                   (IC_ID_BASE + 0x050B)
#define IC_ID_VPA_SHOWOUTOFCONTEXTITEMS     (IC_ID_BASE + 0x050C)

#define IC_ID_UNIVERSAL_LIST                (IC_ID_BASE + 0x0581)
#define IC_ID_CHART_LIST                    (IC_ID_BASE + 0x0582)
#define IC_ID_COMMENTTOOLS_LIST             (IC_ID_BASE + 0x0583)
#define IC_ID_DRAWINGACTIONS_LIST           (IC_ID_BASE + 0x0584)
#define IC_ID_DRAWINGTOOLS_LIST             (IC_ID_BASE + 0x0585)
#define IC_ID_EQUATION_LIST                 (IC_ID_BASE + 0x0586)
#define IC_ID_EQUATIONSYMBOLS_LIST          (IC_ID_BASE + 0x0587)
#define IC_ID_FOOTER_LIST                   (IC_ID_BASE + 0x0588)
#define IC_ID_FRAME_LIST                    (IC_ID_BASE + 0x0589)
#define IC_ID_HEADER_LIST                   (IC_ID_BASE + 0x058A)
#define IC_ID_INTERNET_LIST                 (IC_ID_BASE + 0x058B)
#define IC_ID_OLE2SERVERUNIVERSAL_LIST      (IC_ID_BASE + 0x058C)
#define IC_ID_TABLECELL_LIST                (IC_ID_BASE + 0x058D)
#define IC_ID_TEXT_LIST                     (IC_ID_BASE + 0x058E)
#define IC_ID_TEXTINAFRAME_LIST             (IC_ID_BASE + 0x058F)
#define IC_ID_TEXTINATABLECELL_LIST         (IC_ID_BASE + 0x0590)
#define IC_ID_TEXTINCOLUMNS_LIST            (IC_ID_BASE + 0x0591)
#define IC_ID_CLIPBOARD_LIST                (IC_ID_BASE + 0x0592)

// The following are used only internally by Visible Properties & Actions Framework.
#define IC_ID_ACTION_DUMMYACTIONTEXT        (IC_ID_BASE + 0x0651)

// The following are the IDs for secondary strings
#define IC_FLYTEXTOFFSET                    (0x2000)
#define IC_LONGTEXTOFFSET                   (0x2800)

#define IC_ID_FLYTEXT_CANCELOPERATION       (IC_ID_CANCELOPERATION + IC_FLYTEXTOFFSET)
#define IC_ID_LONGTEXT_CANCELOPERATION      (IC_ID_CANCELOPERATION + IC_LONGTEXTOFFSET)
#define IC_ID_FLYTEXT_OPEN                  (IC_ID_OPEN + IC_FLYTEXTOFFSET)
#define IC_ID_LONGTEXT_OPEN                 (IC_ID_OPEN + IC_LONGTEXTOFFSET)
#define IC_ID_FLYTEXT_SAVE                  (IC_ID_SAVE + IC_FLYTEXTOFFSET)
#define IC_ID_LONGTEXT_SAVE                 (IC_ID_SAVE + IC_LONGTEXTOFFSET)
#define IC_ID_FLYTEXT_PRINT                 (IC_ID_PRINT + IC_FLYTEXTOFFSET)
#define IC_ID_LONGTEXT_PRINT                (IC_ID_PRINT + IC_LONGTEXTOFFSET)
#define IC_ID_FLYTEXT_LOCATE                (IC_ID_LOCATE + IC_FLYTEXTOFFSET)
#define IC_ID_LONGTEXT_LOCATE               (IC_ID_LOCATE + IC_LONGTEXTOFFSET)
#define IC_ID_FLYTEXT_CUT                   (IC_ID_CUT + IC_FLYTEXTOFFSET)
#define IC_ID_LONGTEXT_CUT                  (IC_ID_CUT + IC_LONGTEXTOFFSET)
#define IC_ID_FLYTEXT_COPY                  (IC_ID_COPY + IC_FLYTEXTOFFSET)
#define IC_ID_LONGTEXT_COPY                 (IC_ID_COPY + IC_LONGTEXTOFFSET)
#define IC_ID_FLYTEXT_PASTE                 (IC_ID_PASTE + IC_FLYTEXTOFFSET)
#define IC_ID_LONGTEXT_PASTE                (IC_ID_PASTE + IC_LONGTEXTOFFSET)
#define IC_ID_FLYTEXT_HELP                  (IC_ID_HELP + IC_FLYTEXTOFFSET)
#define IC_ID_LONGTEXT_HELP                 (IC_ID_HELP + IC_LONGTEXTOFFSET)
#define IC_ID_FLYTEXT_BOLD                  (IC_ID_BOLD + IC_FLYTEXTOFFSET)
#define IC_ID_LONGTEXT_BOLD                 (IC_ID_BOLD + IC_LONGTEXTOFFSET)
#define IC_ID_FLYTEXT_ITALIC                (IC_ID_ITALIC + IC_FLYTEXTOFFSET)
#define IC_ID_LONGTEXT_ITALIC               (IC_ID_ITALIC + IC_LONGTEXTOFFSET)
#define IC_ID_FLYTEXT_UNDERSCORE            (IC_ID_UNDERSCORE + IC_FLYTEXTOFFSET)
#define IC_ID_LONGTEXT_UNDERSCORE           (IC_ID_UNDERSCORE + IC_LONGTEXTOFFSET)
#define IC_ID_FLYTEXT_SETTINGS              (IC_ID_SETTINGS + IC_FLYTEXTOFFSET)
#define IC_ID_LONGTEXT_SETTINGS             (IC_ID_SETTINGS + IC_LONGTEXTOFFSET)
#define IC_ID_FLYTEXT_CLEAR                 (IC_ID_CLEAR + IC_FLYTEXTOFFSET)
#define IC_ID_LONGTEXT_CLEAR                (IC_ID_CLEAR + IC_LONGTEXTOFFSET)
#define IC_ID_FLYTEXT_DELETE                (IC_ID_DELETE + IC_FLYTEXTOFFSET)
#define IC_ID_LONGTEXT_DELETE               (IC_ID_DELETE + IC_LONGTEXTOFFSET)

#define IC_ID_FLYTEXT_JUSTIFY               (IC_ID_JUSTIFY + IC_FLYTEXTOFFSET)
#define IC_ID_LONGTEXT_JUSTIFY              (IC_ID_JUSTIFY + IC_LONGTEXTOFFSET)
#define IC_ID_FLYTEXT_CENTER                (IC_ID_CENTER + IC_FLYTEXTOFFSET)
#define IC_ID_LONGTEXT_CENTER               (IC_ID_CENTER + IC_LONGTEXTOFFSET)
#define IC_ID_FLYTEXT_LEFT                  (IC_ID_LEFT + IC_FLYTEXTOFFSET)
#define IC_ID_LONGTEXT_LEFT                 (IC_ID_LEFT + IC_LONGTEXTOFFSET)
#define IC_ID_FLYTEXT_RIGHT                 (IC_ID_RIGHT + IC_FLYTEXTOFFSET)
#define IC_ID_LONGTEXT_RIGHT                (IC_ID_RIGHT + IC_LONGTEXTOFFSET)

#define IC_ID_FLYTEXT_CHECKSPELLING         (IC_ID_CHECKSPELLING + IC_FLYTEXTOFFSET)
#define IC_ID_LONGTEXT_CHECKSPELLING        (IC_ID_CHECKSPELLING + IC_LONGTEXTOFFSET)
#define IC_ID_FLYTEXT_DESELECTALL           (IC_ID_DESELECTALL + IC_FLYTEXTOFFSET)
#define IC_ID_LONGTEXT_DESELECTALL          (IC_ID_DESELECTALL + IC_LONGTEXTOFFSET)
#define IC_ID_FLYTEXT_INSERTCOLUMN          (IC_ID_INSERTCOLUMN + IC_FLYTEXTOFFSET)
#define IC_ID_LONGTEXT_INSERTCOLUMN         (IC_ID_INSERTCOLUMN + IC_LONGTEXTOFFSET)
#define IC_ID_FLYTEXT_INSERTROW             (IC_ID_INSERTROW + IC_FLYTEXTOFFSET)
#define IC_ID_LONGTEXT_INSERTROW            (IC_ID_INSERTROW + IC_LONGTEXTOFFSET)
#define IC_ID_FLYTEXT_DELETECOLUMNS         (IC_ID_DELETECOLUMNS + IC_FLYTEXTOFFSET)
#define IC_ID_LONGTEXT_DELETECOLUMNS        (IC_ID_DELETECOLUMNS + IC_LONGTEXTOFFSET)
#define IC_ID_FLYTEXT_DELETEROWS            (IC_ID_DELETEROWS + IC_FLYTEXTOFFSET)
#define IC_ID_LONGTEXT_DELETEROWS           (IC_ID_DELETEROWS + IC_LONGTEXTOFFSET)
#define IC_ID_FLYTEXT_NORMAL                (IC_ID_NORMAL + IC_FLYTEXTOFFSET)
#define IC_ID_LONGTEXT_NORMAL               (IC_ID_NORMAL + IC_LONGTEXTOFFSET)

#define IC_ID_FLYTEXT_NEW                   (IC_ID_NEW + IC_FLYTEXTOFFSET)
#define IC_ID_LONGTEXT_NEW                  (IC_ID_NEW + IC_LONGTEXTOFFSET)
#define IC_ID_FLYTEXT_SAVE_AS               (IC_ID_SAVE_AS + IC_FLYTEXTOFFSET)
#define IC_ID_LONGTEXT_SAVE_AS              (IC_ID_SAVE_AS + IC_LONGTEXTOFFSET)
#define IC_ID_FLYTEXT_EXIT                  (IC_ID_EXIT + IC_FLYTEXTOFFSET)
#define IC_ID_LONGTEXT_EXIT                 (IC_ID_EXIT + IC_LONGTEXTOFFSET)
#define IC_ID_FLYTEXT_UNDO                  (IC_ID_UNDO + IC_FLYTEXTOFFSET)
#define IC_ID_LONGTEXT_UNDO                 (IC_ID_UNDO + IC_LONGTEXTOFFSET)
#define IC_ID_FLYTEXT_TOOLBAR               (IC_ID_TOOLBAR + IC_FLYTEXTOFFSET)
#define IC_ID_LONGTEXT_TOOLBAR              (IC_ID_TOOLBAR + IC_LONGTEXTOFFSET)
#define IC_ID_FLYTEXT_ABOUT                 (IC_ID_ABOUT + IC_FLYTEXTOFFSET)
#define IC_ID_LONGTEXT_ABOUT                (IC_ID_ABOUT + IC_LONGTEXTOFFSET)
#define IC_ID_FLYTEXT_UPDATE                (IC_ID_UPDATE + IC_FLYTEXTOFFSET)
#define IC_ID_LONGTEXT_UPDATE               (IC_ID_UPDATE + IC_LONGTEXTOFFSET)
#define IC_ID_FLYTEXT_PASTESPECIAL          (IC_ID_PASTESPECIAL + IC_FLYTEXTOFFSET)
#define IC_ID_LONGTEXT_PASTESPECIAL         (IC_ID_PASTESPECIAL + IC_LONGTEXTOFFSET)
#define IC_ID_FLYTEXT_PASTELINK             (IC_ID_PASTELINK + IC_FLYTEXTOFFSET)
#define IC_ID_LONGTEXT_PASTELINK            (IC_ID_PASTELINK + IC_LONGTEXTOFFSET)
#define IC_ID_FLYTEXT_SELECTALL             (IC_ID_SELECTALL + IC_FLYTEXTOFFSET)
#define IC_ID_LONGTEXT_SELECTALL            (IC_ID_SELECTALL + IC_LONGTEXTOFFSET)

#define IC_ID_FLYTEXT_DOUBLEUNDERSCORE      (IC_ID_DOUBLEUNDERSCORE + IC_FLYTEXTOFFSET)
#define IC_ID_LONGTEXT_DOUBLEUNDERSCORE     (IC_ID_DOUBLEUNDERSCORE + IC_LONGTEXTOFFSET)
#define IC_ID_FLYTEXT_LEFTALIGNOBJ          (IC_ID_LEFTALIGNOBJ + IC_FLYTEXTOFFSET)
#define IC_ID_LONGTEXT_LEFTALIGNOBJ         (IC_ID_LEFTALIGNOBJ + IC_LONGTEXTOFFSET)
#define IC_ID_FLYTEXT_RIGHTALIGNOBJ         (IC_ID_RIGHTALIGNOBJ + IC_FLYTEXTOFFSET)
#define IC_ID_LONGTEXT_RIGHTALIGNOBJ        (IC_ID_RIGHTALIGNOBJ + IC_LONGTEXTOFFSET)
#define IC_ID_FLYTEXT_MAILSEND              (IC_ID_MAILSEND + IC_FLYTEXTOFFSET)
#define IC_ID_LONGTEXT_MAILSEND             (IC_ID_MAILSEND + IC_LONGTEXTOFFSET)
#define IC_ID_FLYTEXT_MOVEPAGES             (IC_ID_MOVEPAGES + IC_FLYTEXTOFFSET)
#define IC_ID_LONGTEXT_MOVEPAGES            (IC_ID_MOVEPAGES + IC_LONGTEXTOFFSET)
#define IC_ID_FLYTEXT_PRINTPREVIEW          (IC_ID_PRINTPREVIEW + IC_FLYTEXTOFFSET)
#define IC_ID_LONGTEXT_PRINTPREVIEW         (IC_ID_PRINTPREVIEW + IC_LONGTEXTOFFSET)
#define IC_ID_FLYTEXT_PRINTSETUP            (IC_ID_PRINTSETUP + IC_FLYTEXTOFFSET)
#define IC_ID_LONGTEXT_PRINTSETUP           (IC_ID_PRINTSETUP + IC_LONGTEXTOFFSET)
#define IC_ID_FLYTEXT_REDO                  (IC_ID_REDO + IC_FLYTEXTOFFSET)
#define IC_ID_LONGTEXT_REDO                 (IC_ID_REDO + IC_LONGTEXTOFFSET)
#define IC_ID_FLYTEXT_TOOLBARSETUP          (IC_ID_TOOLBARSETUP + IC_FLYTEXTOFFSET)
#define IC_ID_LONGTEXT_TOOLBARSETUP         (IC_ID_TOOLBARSETUP + IC_LONGTEXTOFFSET)
#define IC_ID_FLYTEXT_SORTAZ                (IC_ID_SORTAZ + IC_FLYTEXTOFFSET)
#define IC_ID_LONGTEXT_SORTAZ               (IC_ID_SORTAZ + IC_LONGTEXTOFFSET)
#define IC_ID_FLYTEXT_SORTZA                (IC_ID_SORTZA + IC_FLYTEXTOFFSET)
#define IC_ID_LONGTEXT_SORTZA               (IC_ID_SORTZA + IC_LONGTEXTOFFSET)
#define IC_ID_FLYTEXT_SORTUP                (IC_ID_SORTUP + IC_FLYTEXTOFFSET)
#define IC_ID_LONGTEXT_SORTUP               (IC_ID_SORTUP + IC_LONGTEXTOFFSET)
#define IC_ID_FLYTEXT_SORTDOWN              (IC_ID_SORTDOWN + IC_FLYTEXTOFFSET)
#define IC_ID_LONGTEXT_SORTDOWN             (IC_ID_SORTDOWN + IC_LONGTEXTOFFSET)
#define IC_ID_FLYTEXT_TOUR                  (IC_ID_TOUR + IC_FLYTEXTOFFSET)
#define IC_ID_LONGTEXT_TOUR                 (IC_ID_TOUR + IC_LONGTEXTOFFSET)
#define IC_ID_FLYTEXT_ZOOM                  (IC_ID_ZOOM + IC_FLYTEXTOFFSET)
#define IC_ID_LONGTEXT_ZOOM                 (IC_ID_ZOOM + IC_LONGTEXTOFFSET)
#define IC_ID_FLYTEXT_ZOOMIN                (IC_ID_ZOOMIN + IC_FLYTEXTOFFSET)
#define IC_ID_LONGTEXT_ZOOMIN               (IC_ID_ZOOMIN + IC_LONGTEXTOFFSET)
#define IC_ID_FLYTEXT_ZOOMOUT               (IC_ID_ZOOMOUT + IC_FLYTEXTOFFSET)
#define IC_ID_LONGTEXT_ZOOMOUT              (IC_ID_ZOOMOUT + IC_LONGTEXTOFFSET)
#define IC_ID_FLYTEXT_GENERALHELP           (IC_ID_GENERALHELP + IC_FLYTEXTOFFSET)
#define IC_ID_LONGTEXT_GENERALHELP          (IC_ID_GENERALHELP + IC_LONGTEXTOFFSET)
#define IC_ID_FLYTEXT_HELPINDEX             (IC_ID_HELPINDEX + IC_FLYTEXTOFFSET)
#define IC_ID_LONGTEXT_HELPINDEX            (IC_ID_HELPINDEX + IC_LONGTEXTOFFSET)
#define IC_ID_FLYTEXT_HELPTUTORIAL          (IC_ID_HELPTUTORIAL + IC_FLYTEXTOFFSET)
#define IC_ID_LONGTEXT_HELPTUTORIAL         (IC_ID_HELPTUTORIAL + IC_LONGTEXTOFFSET)
#define IC_ID_FLYTEXT_USINGHELP             (IC_ID_USINGHELP + IC_FLYTEXTOFFSET)
#define IC_ID_LONGTEXT_USINGHELP            (IC_ID_USINGHELP + IC_LONGTEXTOFFSET)
#define IC_ID_FLYTEXT_LOGON                 (IC_ID_LOGON + IC_FLYTEXTOFFSET)
#define IC_ID_LONGTEXT_LOGON                (IC_ID_LOGON + IC_LONGTEXTOFFSET)
#define IC_ID_FLYTEXT_LOGOFF                (IC_ID_LOGOFF + IC_FLYTEXTOFFSET)
#define IC_ID_LONGTEXT_LOGOFF               (IC_ID_LOGOFF + IC_LONGTEXTOFFSET)
#define IC_ID_FLYTEXT_RUNSCRIPT             (IC_ID_RUNSCRIPT + IC_FLYTEXTOFFSET)
#define IC_ID_LONGTEXT_RUNSCRIPT            (IC_ID_RUNSCRIPT + IC_LONGTEXTOFFSET)
#define IC_ID_FLYTEXT_VPAPALETTE            (IC_ID_VPAPALETTE + IC_FLYTEXTOFFSET)
#define IC_ID_LONGTEXT_VPAPALETTE           (IC_ID_VPAPALETTE + IC_LONGTEXTOFFSET)

/*-------------------------- Notification Delay Ids --------------------------*/
#define IC_NOTDEL_SETBT_SELECT              (IC_ID_BASE + 0x0F00)
#define IC_NOTDEL_PUSHBT_SELECT             (IC_ID_BASE + 0x0F01)
#define IC_NOTDEL_EF_DATAUPD                (IC_ID_BASE + 0x0F02)
#define IC_NOTDEL_EF_LIMIT                  (IC_ID_BASE + 0x0F03)
#define IC_NOTDEL_MLE_DATAUPD               (IC_ID_BASE + 0x0F04)
#define IC_NOTDEL_MLE_LIMIT                 (IC_ID_BASE + 0x0F05)
#define IC_NOTDEL_SCRL_POS                  (IC_ID_BASE + 0x0F06)
#define IC_NOTDEL_BOOK_COLOR                (IC_ID_BASE + 0x0F07)
#define IC_NOTDEL_TITLE_COLOR               (IC_ID_BASE + 0x0F08)
#define IC_NOTDEL_MENU_COLOR                (IC_ID_BASE + 0x0F09)
#define IC_NOTDEL_CNR_TITLE                 (IC_ID_BASE + 0x0F0A)
#define IC_NOTDEL_FRAME_ACTIVE              (IC_ID_BASE + 0x0F0B)
#define IC_NOTDEL_WINDOW_FONT               (IC_ID_BASE + 0x0F0C)
#define IC_NOTDEL_SHOW_WINDOW               (IC_ID_BASE + 0x0F0D)
#define IC_NOTDEL_WINDOW_COLOR              (IC_ID_BASE + 0x0F0E)

#ifdef IC_PMWIN
// The following are window class name and style constants for private
// canvas window class.

#define IC_WC_IOC_CANVAS                    "IOC_CANVAS"    //Private class name
#define IC_WC_IOC_CANVAS_AP                 "IOC_CANVAS_AP" //Private class name

#define IC_CVS_CANVAS                       0x0001          //Base Canvas
#define IC_CVS_DRAWINGCANVAS                0x0002          //Drawing Canvas
#define IC_CVS_MULTICELLCANVAS              0x0003          //MultiCell Canvas
#define IC_CVS_SETCANVAS                    0x0004          //Set Canvas
#define IC_CVS_SPLITCANVAS                  0x0005          //Split Canvas
#define IC_CVS_VIEWPORT                     0x0006          //Viewport
#define IC_CVS_USERSTART                    0x0015          //Start user canvas styles
#define IC_CVS_USEREND                      0x001F          //End user canvas styles
#endif

#ifdef IC_WIN
// The following ids are used by ITabControl.
#define ID_TABPAGECLIP                      0x1F40
#define ID_TABBUTTONS                       0x1F41
#endif // IC_WIN

#define IC_RESERVED_TIMERS                  1000

/***********************************************************/
/* The User's Guide documents the private message range as */
/* 0xF000 and above.  IC_UM_BASE still defined as 0xFF00   */
/* so as not to change the value of existing messages      */
/* for compatability with existing applications.           */
/***********************************************************/
/* CCL messages are in the range (0xF000) to (0xF0BF) */
#define IC_UM_BASE            ( 0xFE00 )
#ifdef IC_WIN
/*----------------Begin Drag and Drop Support---------------------------------*/
#define DM_RENDERPREPARE                    (IC_UM_BASE + 0x00B0)
#define DM_RENDERCOMPLETE                   (IC_UM_BASE + 0x00B1)
#define DM_RENDER                           (IC_UM_BASE + 0x00B2)
#define DM_ENDCONVERSATION                  (IC_UM_BASE + 0x00B3)
#define DM_DISCARDOBJECT                    (IC_UM_BASE + 0x00B4)
#define DM_PRINTOBJECT                      (IC_UM_BASE + 0x00B5)
#define DM_DRAGOVER                         (IC_UM_BASE + 0x00B6)
#define DM_DROPHELP                         (IC_UM_BASE + 0x00B7)
#define DM_DRAGLEAVE                        (IC_UM_BASE + 0x00B8)
#define DM_DROP                             (IC_UM_BASE + 0x00B9)
#define DM_REGISTER                         (IC_UM_BASE + 0x00BA)
/*----------------End Drag and Drop Support-----------------------------------*/
#define WM_CHORD                            (IC_UM_BASE + 0x00C6)
#define IC_UM_CONTEXT_HELP                  (IC_UM_BASE + 0x00C7)
#define IC_UM_LN_SELECT                     (IC_UM_BASE + 0x00C8)
#define IC_UM_QUERY_HELP_WINDOW             (IC_UM_BASE + 0x00C9)
#define IC_UM_REQUEST_CANVASFONT            (IC_UM_BASE + 0x00CA)
#define IC_UM_LBUTTONDBLCLK                 (IC_UM_BASE + 0x00CB)
#define HM_HELPSUBITEM_NOT_FOUND            (IC_UM_BASE + 0x00CC)
#define WM_MENUEND                          (IC_UM_BASE + 0x00CD)
#define IC_UM_COMMAND                       (IC_UM_BASE + 0x00CE)
#define IC_UM_SYSCOMMAND                    (IC_UM_BASE + 0x00CF)
#define WM_CONTROL                          (IC_UM_BASE + 0x00D0)
#define WM_MATCHMNEMONIC                    (IC_UM_BASE + 0x00D1)
#define IC_UM_QUERYFRAMECTLCOUNT            (IC_UM_BASE + 0x00D2)
#define IC_UM_FORMATFRAME                   (IC_UM_BASE + 0x00D3)
#define IC_UM_UPDATEFRAME                   (IC_UM_BASE + 0x00D4)
#define IC_UM_CALCFRAMERECT                 (IC_UM_BASE + 0x00D5)
#define WM_QUERYFOCUSCHAIN                  (IC_UM_BASE + 0x00D6)
#define IC_UM_32TO16                        (IC_UM_BASE + 0x00D7)
#define WM_BUTTON1CLICK                     (IC_UM_BASE + 0x00D8)
#define WM_BUTTON2CLICK                     (IC_UM_BASE + 0x00D9)
#define WM_BUTTON3CLICK                     (IC_UM_BASE + 0x00DA)
#define WM_TRACKFRAME                       (IC_UM_BASE + 0x00DB)
#define IC_UM_SLIDER_SCROLL                 (IC_UM_BASE + 0x00DC)
#define WM_BEGINDRAG                        (IC_UM_BASE + 0x00DD)
#define IC_UM_VSCROLL                       (IC_UM_BASE + 0x00DE)
#define IC_UM_QUIT                          (IC_UM_BASE + 0x00DF)
#endif
#define IC_UM_DRAGDROP_RENDER               (IC_UM_BASE + 0x00E0)
#define IC_UM_CANVAS_SETFOCUS               (IC_UM_BASE + 0x00E1)
#define IC_UM_CANVAS_PAINT                  (IC_UM_BASE + 0x00E2)
#define IC_UM_CREATED                       (IC_UM_BASE + 0x00E3)
#define IC_UM_DESTROY_MENU                  (IC_UM_BASE + 0x00E4)
#define IC_UM_UNLATCH                       (IC_UM_BASE + 0x00E5)
#define IC_UM_QRY_BMP_VISIBLE               (IC_UM_BASE + 0x00E9)
#define IC_UM_QRY_TXT_VISIBLE               (IC_UM_BASE + 0x00EA)
#define IC_UM_FLY_PAINT                     (IC_UM_BASE + 0x00EB)
#define IC_UM_TOOLBAR                       (IC_UM_BASE + 0x00EC)
#define IC_UM_DRAW_DOWN                     (IC_UM_BASE + 0x00ED)
#define IC_UM_QRY_PREVENTUPDATE             (IC_UM_BASE + 0x00EE)
#define IC_UM_WINDOWPOSCHANGED              (IC_UM_BASE + 0x00EF)
#define IC_UM_DELAYNOTIFY                   (IC_UM_BASE + 0x00F0)
#define IC_UM_CLOSE                         (IC_UM_BASE + 0x00F1)
#define IC_UM_BIDI_CHANGE                   (IC_UM_BASE + 0x00F2)
#define IC_UM_DLG_APPLY_PRESSED             (IC_UM_BASE + 0x00F3)
#define IC_UM_MEDIA_LOADED                  (IC_UM_BASE + 0x00F4)
#define IC_UM_MEDIA_UNLOADED                (IC_UM_BASE + 0x00F5)
#define IC_UM_MM_MCI_CMDNOTIFY              (IC_UM_BASE + 0x00F6)
#define IC_UM_CBN_ENTER                     (IC_UM_BASE + 0x00F7)
#define IC_UM_CBN_EFCHANGE                  (IC_UM_BASE + 0x00F8)
#define IC_UM_DESTROY_FRAME                 (IC_UM_BASE + 0x00F9)
#define IC_UM_MM_MCI_POSITIONCHANGE         (IC_UM_BASE + 0x00FA)
#define IC_UM_IS_AGGREGATE_CTRL             (IC_UM_BASE + 0x00FB)
#define IC_UM_TCM_SIZE                      (IC_UM_BASE + 0x00FC)
#define IC_UM_DEFAULT_BUTTON                (IC_UM_BASE + 0x00FD)
#define IC_UM_DEFAULT_EMPHASIS              (IC_UM_BASE + 0x00FE)
#define IC_UM_MOTIF_CUST_BUT_PAINT          (IC_UM_BASE + 0x00FF)
#ifdef IC_WIN
#define WM_MOUSEENTER                       (IC_UM_BASE + 0x00FF)
#define WM_MOUSELEAVE                       (IC_UM_BASE + 0x0100)
#endif
#define IC_UM_PAINT                         (IC_UM_BASE + 0x0102)
#ifdef IC_WIN
/*----------------Begin text change handler support---------------------------*/
#define IC_UM_EM_PASTE                      (IC_UM_BASE + 0x0103)
#define IC_UM_WM_CHAR                       (IC_UM_BASE + 0x0104)
#define IC_UM_EDIT_SETTEXT                  (IC_UM_BASE + 0x0105)
/*----------------End text change handler support-----------------------------*/
#endif //IC_WIN
#ifdef IC_MOTIF
#define IC_UM_MEASUREITEM                   (IC_UM_BASE + 0x0106)
#define IC_UM_DRAWITEM                      (IC_UM_BASE + 0x0107)
#endif
#define IC_UM_SIZE                          (IC_UM_BASE + 0x0108)
#define IC_UM_GENERATE_PAINT                (IC_UM_BASE + 0x0109)
#define IC_UM_FLUSH_POSTS                   (IC_UM_BASE + 0x010A)
/*--------------------Begin tab control support-------------------------------*/
#define IC_UM_TCN_PAGEDELETED               ( IC_UM_BASE + 0x10B )
#define IC_UM_TCN_BTNDELETED                ( IC_UM_BASE + 0x10C )
#define IC_UM_TCM_LAYOUT                    ( IC_UM_BASE + 0x10D )
/*---------------------End tab control support--------------------------------*/
/*--------------------Begin view port support---------------------------------*/
#define IC_UM_CR_DECREMENT                  ( IC_UM_BASE + 0x10E )     
#define IC_UM_CR_INCREMENT                  ( IC_UM_BASE + 0x10F )     
#define IC_UM_CRPAGE_DECREMENT              ( IC_UM_BASE + 0x110 )     
#define IC_UM_CRPAGE_INCREMENT              ( IC_UM_BASE + 0x111 )     
/*---------------------End view port support----------------------------------*/

/*
 * Following added from winuser.h as part of 24948 - JAD 10/07/97
 */
#ifdef IC_WIN
// Just in case an app is including both windows.h and icconst.h
#ifndef SC_HELPKEYS
#define SC_HELPKEYS         0x8012
#define SC_HELPINDEX        0x8013
#define SC_HELPEXTENDED     0x8014
#endif
#endif

#ifdef IC_MOTIF
/* Values for mapping events */
#define xEventOffset     0x20000
#define motifEventOffset 0x30000

/* The macros to add values to event ids. Used by IEvent and handlers. */
#define xEvent(id) ( id + xEventOffset)
#define motifEvent( id ) ( id + motifEventOffset)

#endif

#endif // _ICCONST_
