// Revision: 32 1.5.1.3 source/ui/basectl/ibutton.hpp, buttonctls, ioc.v400, 980918  
#ifndef _IBUTTON_
  #define _IBUTTON_
/*******************************************************************************
* FILE NAME: ibutton.hpp                                                       *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*    IButton                                                                   *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1997       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*                                                                              *
*******************************************************************************/
#include <itextctl.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IColor;
class IButtonData;

#pragma enum(4)
#pragma pack(push,4)

class IButton : public ITextControl {
typedef ITextControl
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
virtual
 ~IButton ( );

/*---------------------------------- Styles ----------------------------------*/
INESTEDBITFLAGCLASSDEF2(Style, IButton, IWindow, IControl);

static const Style
  IC_IMPORTU noPointerFocus;

/*------------------------------- Mouse Focus --------------------------------*/
virtual IButton
 &enableMouseClickFocus  ( bool enable = true ),
 &disableMouseClickFocus ( );
bool
  allowsMouseClickFocus  ( ) const;

/*-------------------------------- Highlight ---------------------------------*/
#ifndef IC_MOTIF_FLAGNOP
bool
  isHighlighted ( ) const;

virtual IButton
 &highlight     ( bool highlight = true ),
 &unhighlight   ( );
#endif  // end of IC_MOTIF_FLAGNOP

/*-------------------------------- Selection ---------------------------------*/
virtual IButton
 &click         ( );

/*---------------------------------- Color -----------------------------------*/
#ifndef IC_WINMOTIF_FLAGNOP
virtual IColor
  disabledForegroundColor ( ) const,
  hiliteForegroundColor   ( ) const,
  hiliteBackgroundColor   ( ) const;
#endif //!IC_WIN_FLAGNOP
virtual IColor
  foregroundColor         ( ) const,
  backgroundColor         ( ) const;

/*--------------------- Notification Event Descriptions ----------------------*/
static INotificationId const
  IC_IMPORTU buttonClickId;

/*-------------------------- Observer Notification ---------------------------*/
virtual IButton
  &enableNotification (bool enable = true);

/*----------------------------------- Text -----------------------------------*/
virtual IButton
 &setText       ( const char* text ),
 &setText       ( const IResourceId& text );

protected:

/*-------------------------- Protected Constructors --------------------------*/
  IButton ( );

private:
/*----------------------------- Hidden Functions -----------------------------*/
  IButton       ( const IButton& );
IButton
 &operator=     ( const IButton& );

/*--------------------------------- Private ----------------------------------*/
friend class IButtonHandler;
IButtonData
 *fButtonData;

};  // class IButton

INESTEDBITFLAGCLASSFUNCS(Style, IButton)

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif  /* _IBUTTON_ */
