// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 16 1.5.1.3 source/core/collect/ibtree.h, collection, ioc.v400, 980918 
#ifndef _IBTREE_
#define _IBTREE_

#include <imtree.h>
#include <iglobals.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)















#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#pragma pack(push,4)
#pragma enum(4)

class IC_EXPORTC ITreeCursor
{

  typedef  ITreeCursorImpl Implementation;

public:

  virtual ~ITreeCursor      ();

  void     copy             (ITreeCursor const&);

  void     invalidate       ();

  bool isValid          () const;

  bool setToChild       (IPosition);

  bool setToFirstExistingChild
                            ();

  bool setToLastExistingChild
                            ();

  bool setToNextExistingChild
                            ();

  bool setToParent      ();

  bool setToPreviousExistingChild
                            ();

  bool setToRoot        ();

  void     operator=        (ITreeCursor const&);

  bool operator==       (ITreeCursor const&) const;

  bool operator!=       (ITreeCursor const&) const;

protected:

           ITreeCursor      (Implementation*);

           ITreeCursor      (ITreeCursor const&);

  static
  inline
  Implementation&
           ImplOf           (ITreeCursor const&);

private:

  Implementation*
           ivImpl;

  friend
  class    IATreeBase;
























};

class IC_EXPORTC IATreeBase : protected IMetaTree {
public:

protected:

           IATreeBase       ();

           IATreeBase       (IATreeBase const&);

          ~IATreeBase       ();

  static
  ITreeCursorImpl&
           CrsrImplOf       (ITreeCursor& cursor);

  static
  ITreeCursorImpl const&
           CrsrImplOf       (ITreeCursor const& cursor);

  static
  ITreeCursor*
           InterfaceFor     (ITreeCursorImpl* cursor);
 









};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif





#include <ibtree.inl>


#pragma info (restore)


#endif // _IBTREE_
