// Revision: 29 1.4.1.6 source/ui/basectl/ibmpctl.hpp, staticctls, ioc.v400, 980918 
#ifndef _IBMPCTL_
  #define _IBMPCTL_
/*******************************************************************************
* FILE NAME: ibmpctl.hpp                                                       *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IBitmapControl                                                           *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Material - Property of IBM                                        *
*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved.                   *
*                                                                              *
*******************************************************************************/
#include <istattxt.hpp>
#include <irect.hpp>
#include <ihandle.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IResourceId;
class ISize;
class IBitmapControlData;

#pragma enum(4)
#pragma pack(push,4)

class IBitmapControl : public IStaticText {
typedef IStaticText
  Inherited;
public:
class Style;
/*------------------------ Constructors --------------------------------------*/
IBitmapControl ( unsigned long      id,
                 IWindow*           parent,
                 IWindow*           owner,
                 const IResourceId& bitmapId,
                 const IRectangle&  initial= IRectangle(),
                 const Style&       style = defaultStyle() );

IBitmapControl ( unsigned long     id,
                 IWindow*          parent,
                 IWindow*          owner,
                 unsigned long     bitmapId,
                 const IRectangle& initial= IRectangle(),
                 const Style&      style = defaultStyle() );

IBitmapControl ( unsigned long        id,
                 IWindow*             parent,
                 IWindow*             owner,
                 const IBitmapHandle& bitmapId = IBitmapHandle(),
                 const IRectangle&    initial= IRectangle(),
                 const Style&         style = defaultStyle() );

IBitmapControl ( unsigned long                   id,
                 IWindow*                        parent,
                 IWindow*                        owner,
                 ISystemBitmapHandle::Identifier bitmapId,
                 const IRectangle&               initial= IRectangle(),
                 const Style&                    style = defaultStyle() );

IBitmapControl ( unsigned long id,
                 IWindow*      parentDialog );

IBitmapControl ( const IWindowHandle& handle );

virtual
  ~IBitmapControl();

/*---------------------------------- Styles ----------------------------------*/
INESTEDBITFLAGCLASSDEF3(Style, IBitmapControl, IWindow, IControl, IStaticText);

static const Style
  IC_IMPORTU classDefaultStyle,
  IC_IMPORTU sizeImageToWindow,
  IC_IMPORTU sizeWindowToImage;

static Style
  defaultStyle      ( );

static void
  setDefaultStyle   ( const Style&    style );

virtual unsigned long
  convertToGUIStyle ( const IBitFlag& style,
                      bool         extendedOnly = false ) const;

/*-------------------------------- Bitmaps -----------------------------------*/
virtual IBitmapControl
  &setBitmap ( unsigned long        bitmapId ),
  &setBitmap ( const IResourceId&   bitmapId ),
  &setBitmap ( const IBitmapHandle& handle );

virtual IBitmapControl
  &setBitmap ( ISystemBitmapHandle::Identifier bitmap );

IBitmapHandle
  bitmap    ( ) const;

/*----------------------------- Layout Support -------------------------------*/
virtual IBitmapControl
 &setLayoutDistorted ( unsigned long layoutAttributesOn,
                       unsigned long layoutAttributesOff );

/*----------------------------- Graphic Size ---------------------------------*/
virtual IBitmapControl
  &enableSizeImageToWindow  ( bool enable = true ),
  &disableSizeImageToWindow ( );
virtual bool
  isSizeImageToWindowEnabled( ) const;

virtual IBitmapControl
  &enableSizeWindowToImage  ( bool enable = true ),
  &disableSizeWindowToImage ( );
virtual bool
  isSizeWindowToImageEnabled( ) const;

/*-------------------------------- Window Positioning ------------------------*/
#ifdef IC_MOTIF
virtual IBitmapControl
 &moveSizeTo ( const IRectangle& rectangle );

#endif  //IC_MOTIF

/*-------------------------------- Attributes --------------------------------*/
#ifdef IC_MOTIF
virtual IWindow
 &enable                    ( bool           enableWindow = true );
#endif //IC_MOTIF

protected:
/*----------------------------- Layout Support -------------------------------*/
virtual ISize
  calcMinimumSize() const;

private:
/*--------------------------------- Private ----------------------------------*/
IBitmapControl
  &initialize(const Style& style);

static Style
  currentDefaultStyle;

IBitmapControlData
 *fBitmapControlData;

IBitmapHandle
  bmpHandle;
bool
  returnback;

/*---------------------------- Hidden Members --------------------------------*/
  IBitmapControl(const IBitmapControl&);
IBitmapControl
  &operator=(const IBitmapControl);

/*----------------------- Obsolete Data and Functions ------------------------*/
#if (IC_OBSOLETE <= IC_OBSOLETE_3)
public:
static const Style
  IC_IMPORTU sizeToBitmap;
#endif // IC_OBSOLETE

};  // class IBitmapControl

INESTEDBITFLAGCLASSFUNCS(Style, IBitmapControl)
                                  // global style functions

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif  /* _IBMPCTL_ */
