// Revision: 83 1.7.1.3 source/ui/baseapp/ibitflag.hpp, datatype, ioc.v400, 980918 
#ifndef _IBITFLAG_
  #define _IBITFLAG_
/*******************************************************************************
* FILE NAME: ibitflag.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IBitFlag                                                                 *
*                                                                              *
*   Definition of the macros:                                                  *
*     INESTEDBITFLAGCLASSDEF0                                                  *
*     INESTEDBITFLAGCLASSDEF1                                                  *
*     INESTEDBITFLAGCLASSDEF2                                                  *
*     INESTEDBITFLAGCLASSDEF3                                                  *
*     INESTEDBITFLAGCLASSDEF4                                                  *
*     INESTEDBITFLAGCLASSFUNCS                                                 *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Material - Property of IBM                                        *
*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved                    *
*                                                                              *
*******************************************************************************/
#include <ibase.hpp>
#include <iuipl.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#pragma enum(4)
#pragma pack(push,4)

class IBitFlag {
public:
/*---------------------------------- Queries ---------------------------------*/
static unsigned long
  maxNumberOfBits ( );

/*-------------------------------- Comparisons -------------------------------*/
bool
  operator ==    ( const IBitFlag& rhs ) const,
  operator !=    ( const IBitFlag& rhs ) const;

IString
  asString       ( ) const,
  asDebugInfo    ( ) const;


protected:
/*------------------------------- Constructors -------------------------------*/
  IBitFlag ( unsigned long count,
             const unsigned long bitIndex[] );

  IBitFlag ( const IBitFlag& bitFlag );

  IBitFlag ( );

IBitFlag
  bitwiseOr  ( const IBitFlag& rhs ) const,
  bitwiseAnd ( const IBitFlag& rhs ) const,
  negate     ( ) const;

bool
  comparisonAnd ( const IBitFlag &rhs ) const;

IBitFlag
 &setValue ( const IBitFlag& bitFlag );

private:
/*--------------------------------- Private ----------------------------------*/
unsigned long
  fBitValue[ 3 ];

static unsigned long
  fMaxBitNumber;

#if ( IC_OBSOLETE <= IC_OBSOLETE_3 )
public:
/*---------------------------------- Queries ---------------------------------*/
unsigned long
  asUnsignedLong         ( ) const,
  asExtendedUnsignedLong ( ) const;

protected:
/*------------------------------- Constructors -------------------------------*/
  IBitFlag ( unsigned long value,
             unsigned long extendedValue );
  IBitFlag ( unsigned long value );

/*-------------------------------- Assignment --------------------------------*/
IBitFlag
 &setValue ( unsigned long value,
             unsigned long extendedValue = 0 );
private:

#endif
}; // IBitFlag


/*---------------------------- Macro Definitions -----------------------------*/
#define INESTEDBITFLAGCLASSDEF0( className, assoc )\
class className : public IBitFlag\
{\
friend class assoc;\
public:\
  class Negated##className : public IBitFlag\
  {\
  friend class className;\
  public:\
    COMMONNEGBITPUBLIC0( className )\
  protected:\
    COMMONNEGBITPROTECTED( className )\
  };\
  COMMONBITPUBLIC( className )\
  COMMONBITPUBLIC0( className )\
protected:\
  COMMONBITPROTECTED( className )\
}


#define INESTEDBITFLAGCLASSDEF1( className, assoc, base1 )\
class className : public IBitFlag\
{\
friend class assoc;\
public:\
  class Negated##className : public IBitFlag\
  {\
  friend class className;\
  public:\
    COMMONNEGBITPUBLIC1( className, base1 )\
  protected:\
    COMMONNEGBITPROTECTED( className )\
  };\
  COMMONBITPUBLIC( className )\
  COMMONBITPUBLIC1( className, base1 )\
protected:\
  COMMONBITPROTECTED( className )\
}

#define INESTEDBITFLAGCLASSDEF2( className, assoc, base1, base2 )\
class className : public IBitFlag\
{\
friend class assoc;\
public:\
  class Negated##className : public IBitFlag\
  {\
  friend class className;\
  public:\
    COMMONNEGBITPUBLIC1( className, base1 )\
    COMMONNEGBITPUBLICn( className, base2 )\
  protected:\
    COMMONNEGBITPROTECTED( className )\
  };\
  COMMONBITPUBLIC( className )\
  COMMONBITPUBLIC1( className, base1 )\
  COMMONBITPUBLICn( className, base2 )\
protected:\
  COMMONBITPROTECTED( className )\
}

#define INESTEDBITFLAGCLASSDEF3( className, assoc, base1, base2, base3 )\
class className : public IBitFlag\
{\
friend class assoc;\
public:\
  class Negated##className : public IBitFlag\
  {\
  friend class className;\
  public:\
    COMMONNEGBITPUBLIC1( className, base1 )\
    COMMONNEGBITPUBLICn( className, base2 )\
    COMMONNEGBITPUBLICn( className, base3 )\
  protected:\
    COMMONNEGBITPROTECTED( className )\
  };\
  COMMONBITPUBLIC( className )\
  COMMONBITPUBLIC1( className, base1 )\
  COMMONBITPUBLICn( className, base2 )\
  COMMONBITPUBLICn( className, base3 )\
protected:\
  COMMONBITPROTECTED( className )\
}

#define INESTEDBITFLAGCLASSDEF4( className, assoc, base1, base2, base3, base4 )\
class className : public IBitFlag\
{\
friend class assoc;\
public:\
  class Negated##className : public IBitFlag\
  {\
  friend class className;\
  public:\
    COMMONNEGBITPUBLIC1( className, base1 )\
    COMMONNEGBITPUBLICn( className, base2 )\
    COMMONNEGBITPUBLICn( className, base3 )\
    COMMONNEGBITPUBLICn( className, base4 )\
  protected:\
    COMMONNEGBITPROTECTED( className )\
  };\
  COMMONBITPUBLIC( className )\
  COMMONBITPUBLIC1( className, base1 )\
  COMMONBITPUBLICn( className, base2 )\
  COMMONBITPUBLICn( className, base3 )\
  COMMONBITPUBLICn( className, base4 )\
protected:\
  COMMONBITPROTECTED( className )\
}

#define INESTEDBITFLAGCLASSFUNCS( className, assoc )\
inline assoc##::##className\
  operator & ( const assoc##::##className##::Negated##className &lhs,\
               const assoc##::##className &rhs )\
{\
  assoc##::##className aResult;\
  aResult.setValue( lhs.bitwiseAnd( rhs ) );\
  return aResult;\
}\
inline assoc##::##className\
  operator | ( const assoc##::##className &lhs,\
               const assoc##::##className &rhs )\
{\
  assoc##::##className aResult;\
  aResult.setValue( lhs.bitwiseOr( rhs ) );\
  return aResult;\
}\
inline bool\
  operator & ( const assoc##::##className &lhs,\
               const assoc##::##className &rhs )\
{\
  bool aResult( lhs.comparisonAnd( rhs ) );\
  return aResult;\
}
#define COMMONBITPUBLIC( className )\
Negated##className operator ~ ( ) const\
{\
  Negated##className aResult;\
  aResult.setValue( this->negate() );\
  return aResult;\
}\
className##& operator |= ( const className &aFlag )\
{\
  this->setValue ( this->bitwiseOr( aFlag) );\
  return *this;\
}\
className##& operator &= ( const Negated##className &aFlag )\
{\
  this->setValue ( this->bitwiseAnd( aFlag) );\
  return *this;\
}
#define COMMONBITPUBLIC0( className )\
className operator & ( const Negated##className &aFlag ) const\
{\
  className aResult;\
  aResult.setValue( this->bitwiseAnd( aFlag) );\
  return aResult;\
}\
className operator | ( const className &rhs) const\
{\
  className aResult;\
  aResult.setValue( this->bitwiseOr( rhs ) );\
  return aResult;\
}\
bool operator & ( const className &rhs) const\
{\
  bool aResult( this->comparisonAnd( rhs ) );\
  return aResult;\
}
#define COMMONBITPUBLIC1( className, baseName )\
COMMONBITPUBLICn ( className, baseName )\
className operator & ( const Negated##className &rhs ) const\
{\
  className aResult;\
  aResult.setValue( this->bitwiseAnd( rhs ) );\
    return aResult;\
}
#define COMMONBITPUBLICn( className, baseName )\
className ( const baseName##::##className &aFlag )\
  : IBitFlag ( )\
{\
  setValue( aFlag);\
}\
friend inline bool operator & ( const baseName##::##className &lhs,\
                                const className &rhs )\
{\
  bool aResult( rhs.comparisonAnd( lhs ) );\
  return aResult;\
}\
friend inline className\
  operator & ( const Negated##className &lhs,\
               const className &rhs );\
friend inline className\
  operator | ( const className &lhs,\
               const className &rhs );\
friend inline bool\
  operator & ( const className &lhs,\
               const className &rhs );
#define COMMONNEGBITPUBLIC0( className )\
Negated##className operator & ( const Negated##className &aFlag ) const\
{\
  Negated##className aResult;\
  aResult.setValue( this->bitwiseAnd( aFlag) );\
  return aResult;\
}
#define COMMONNEGBITPUBLIC1( className, baseName )\
COMMONNEGBITPUBLICn( className, baseName )\
Negated##className operator & ( const Negated##className &aFlag ) const\
{\
  Negated##className aResult;\
  aResult.setValue( this->bitwiseAnd( aFlag) );\
  return aResult;\
}\
friend inline className operator & ( const Negated##className &lhs,\
                                     const className &rhs );
#define COMMONNEGBITPUBLICn( className, baseName )\
Negated##className ( const baseName##::##className##::Negated##className &aFlag )\
: IBitFlag ( )\
{\
  setValue( aFlag );\
}
#if ( IC_OBSOLETE <= IC_OBSOLETE_3 )
#define COMMONBITPROTECTED( className )\
className ( unsigned long count, const unsigned long bitIndex[] )\
: IBitFlag ( count, bitIndex ) { }\
className ( unsigned long val, unsigned long extVal )\
: IBitFlag ( val, extVal ) { }\
className ( unsigned long val)\
: IBitFlag ( val ) { }\
className ( )\
: IBitFlag ( ) { }
#define COMMONNEGBITPROTECTED( className )\
Negated##className ( unsigned long count, const unsigned long bitIndex[] )\
: IBitFlag ( count, bitIndex ) { }\
Negated##className ( unsigned long val, unsigned long extVal )/* */\
: IBitFlag ( val, extVal ) { }\
Negated##className ( unsigned long val )\
: IBitFlag ( val ) { } \
Negated##className ( )\
: IBitFlag ( ) { }
#else // ! IC_OBSOLETE
#define COMMONBITPROTECTED( className )\
className ( unsigned long count, const unsigned long bitIndex[] )\
: IBitFlag ( count, bitIndex ) { }\
className ( )\
: IBitFlag ( ) { }
#define COMMONNEGBITPROTECTED( className )\
Negated##className ( unsigned long count, const unsigned long bitIndex[] )\
: IBitFlag ( count, bitIndex ) { }\
Negated##className ( )\
: IBitFlag ( ) { }
#endif // ! IC_OBSOLETE

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

/*----------------------------- Inline Functions -----------------------------*/
#include <ibitflag.inl>

#endif /* _IBITFLAG_ */
