// Revision: 82 1.9.1.8 source/ui/baseapp/ibidiset.hpp, nls, ioc.v400, 980918 
#ifndef _IBIDISET_
#define _IBIDISET_
/*******************************************************************************
* FILE NAME: ibidiset.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IBidiSettings                                                            *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   Licensed Material - Property of IBM                                        *
*   (C) Copyright IBM Corp. 1992, 1997  All Rights Reserved.                   *
*                                                                              *
*******************************************************************************/

#include <ibase.hpp>
#include <iuipl.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

class IArgList;
class IBidiSettingsData;
class IGrafPort;
class IPresSpaceHandle;
class IWindow;
class IWindowHandle;

class IGraphicContext;  // Needed for IC_OBSOLETE_3 functions.

#pragma enum(4)
#pragma pack(push,4)

class IBidiSettings {

public:
/*------------------------------- Constructors -------------------------------*/
  IBidiSettings ( const IWindow&          window );
  IBidiSettings ( const IWindowHandle&    windowHandle );
#ifndef IC_MOTIFWIN_FLAGNOP
  IBidiSettings ( const IGrafPort&        port );
  IBidiSettings ( const IPresSpaceHandle& presSpace );
#endif
  IBidiSettings ( const IBidiSettings&    settings );
IBidiSettings
 &operator=     ( const IBidiSettings&    settings );

virtual
 ~IBidiSettings ( );

/*-------------------------- Bidirectional Support ---------------------------*/
static bool
  isBidiSupported ( );

#ifndef IC_MOTIF_FLAGNOP
virtual void
  apply ( IWindow&                window,
          bool                    childInherit = true,
          bool                    refresh      = true ) const,
  apply ( const IWindowHandle&    windowHandle,
          bool                    childInherit = true,
          bool                    refresh      = true ) const;
#endif
#ifndef IC_MOTIFWIN_FLAGNOP
virtual void
  apply ( IGrafPort&              port ) const,
  apply ( const IPresSpaceHandle& presSpace ) const;
#endif

/*---------------------------- Application Support ---------------------------*/
static void
  setApplicationDefaults ( const IBidiSettings& applicationSettings );
static IBidiSettings
  applicationDefaults    ( );

/*-------------------------------- Attributes --------------------------------*/
enum BidiTextType {
  visual,
  implicit
  };

enum BidiTextOrientation {
  textLeftToRight,
  textRightToLeft,
  textContextual
  };

enum BidiLayout {
  layoutLeftToRight,
  layoutRightToLeft
  };

enum BidiNumeralType {
  arabic,
  asStored,
  national,
  contextual
  };

enum BidiTextShape {
  displayShaped,
  saveShaped,
  nominalShape,
  initialShape,
  middleShape,
  finalShape,
  isolatedShape
  };

#ifndef IC_WIN_FLAGNOP
virtual IBidiSettings
 &setTextType                   ( BidiTextType        textType );
#endif
virtual IBidiSettings
 &setTextOrientation            ( BidiTextOrientation textOrientation ),
 &setWindowLayout               ( BidiLayout          windowLayout );
#ifndef IC_WIN_FLAGNOP
virtual IBidiSettings
 &setNumeralDisplay             ( BidiNumeralType     numeralDisplay ),
 &enableSymmetricSwapping       ( bool                enable = true ),
 &disableSymmetricSwapping      ( ),
 &enableWordByWordReordering    ( bool                enable = true ),
 &disableWordByWordReordering   ( ),
 &setTextShape                  ( BidiTextShape       textShape );
#endif

BidiTextType
  textType                      ( ) const;
BidiTextOrientation
  textOrientation               ( ) const;
BidiLayout
  windowLayout                  ( ) const;
BidiNumeralType
  numeralDisplay                ( ) const;
bool
  isSymmetricSwappingEnabled    ( ) const;
bool
  isWordByWordReorderingEnabled ( ) const;
BidiTextShape
  textShape                     ( ) const;

#ifdef IC_MOTIF
/*-------------------------------- Conversions -------------------------------*/
IArgList
  asArgList          ( ) const;
#endif

/*-------------------------------- Comparisons -------------------------------*/
bool
  operator== ( const IBidiSettings& settings ) const;

protected:
/*------------------------------- Constructors -------------------------------*/
  IBidiSettings ( );

private:
/*--------------------------------- Private ----------------------------------*/
#ifndef IC_PM
static IBidiSettings
  fgApplicationDefaults;
#endif

void
  initialize         ( const IPresSpaceHandle& presSpace ),
  initialize         ( const IWindowHandle&    window );
void
  applyToWindow      ( IWindowHandle&          windowHandle,
                       bool                    childInherit,
                       bool                    refresh ) const,
  applyToFrameWindow ( IWindow&                frameWindow,
                       bool                    childInherit,
                       bool                    refresh ) const;
IBidiSettingsData
 *fBidiSettingsData;

/*----------------------- Obsolete Data and Functions ------------------------*/
#if ( IC_OBSOLETE <= IC_OBSOLETE_3 )
#ifdef IC_PMWIN
public:
  IBidiSettings ( const IGraphicContext& graphicContext );

  IBidiSettings
   &apply ( const IGraphicContext& graphicContext ) const;
#endif
#endif // IC_OBSOLETE

}; // IBidiSettings

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#endif /* _IBIDISET_ */
