// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 12 1.4.1.3 source/core/collect/ibcllct.h, collection, ioc.v400, 980918 
#ifndef _IBCLLCT_
#define _IBCLLCT_






#include <imcllct.h>
#include <iglobals.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#pragma pack(push,4)
#pragma enum(4)

class IC_EXPORTC ICursor 
{
  typedef  ICursorImpl Implementation;

public:

  virtual  ~ICursor          ();

  void     copy             (ICursor const&);

  void     invalidate       ();







  bool isValid          () const;

  bool setToFirst       ();

  bool setToNext        ();

  void     operator=        (ICursor const&);

  bool operator==       (ICursor const&) const;

  bool operator!=       (ICursor const&) const;

protected:

           ICursor          (Implementation*);

           ICursor          (ICursor const&);

  static
  inline
  Implementation&
           ImplOf           (ICursor const&);

private:

  Implementation*
           ivImpl;

  friend
  class    IACollectionBase;


  friend
  class    IVCollectionImpl;

















};

#define forICursor(c) \
  for ((c).setToFirst (); (c).isValid (); (c).setToNext ())

// for backward compatibility
#define forCursor(c) \
  for ((c).setToFirst (); (c).isValid (); (c).setToNext ())

class IC_EXPORTC IACollectionBase : protected IMetaCollection {
public:

protected:

           IACollectionBase ();

           IACollectionBase (IACollectionBase const&);

          ~IACollectionBase ();

  static
  ICursorImpl&
           CrsrImplOf       (ICursor& cursor);

  static
  ICursorImpl const&
           CrsrImplOf       (ICursor const& cursor);

  static
  ICursor* InterfaceFor     (ICursorImpl* cursor);
 







};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif





#include <ibcllct.inl>


#pragma info (restore)


#endif // _IBCLLCT_
