// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 09 1.5.1.4 source/core/collect/ibagtab.h, collection, ioc.v400, 980918 
#ifndef _IBAGTAB_
#define _IBAGTAB_

#include <ilanglvl.hpp>
#include <iabag.h>
#include <iicbag.h>

#include <iivbag.h>

#include <iibagtab.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

template <class Element, class ElementOps>
class IGBagAsTable;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class ElementOps>
class IGBagAsTableCursor :
  public IElementCursor <Element> {

  typedef  IElementCursor <Element> Inherited;

  typedef TYPENAME IGBagAsTable
            <Element, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGBagAsTableCursor
                            (IGBagAsTable
                              <
                               Element, ElementOps> const&);

  IGBagAsTableCursor <Element, ElementOps>&
           operator=        (IGBagAsTableCursor
                              <
                               Element, ElementOps> const&);

protected:

           IGBagAsTableCursor
                            (ICursorImpl*);

private:















};











































template <class Element, class ElementOps>
class IGBagAsTable :
  public IABag <Element> {
protected:

  typedef  IGBagAsTable <Element, ElementOps> Self;

  typedef  IBagAsTableImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICBagImpl
            <PureImplementation> Implementation;
#endif

#define IGBagAsTableTypedef(Element, ElementOps)\
  typedef  IBagAsTableOps\
            <Element,\
             IWCOps <Element, ElementOps>,\
             Implementation> Instantiation

           IGBagAsTableTypedef (Element, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

  typedef  IGBagAsTableCursor
            <Element, ElementOps> Cursor;




           IGBagAsTable
                            (INumber = 100);

           IGBagAsTable
                            (IGBagAsTable
                              <
                               Element, ElementOps> const&);

  IGBagAsTable <Element, ElementOps>&
           operator=        (IGBagAsTable
                              <
                               Element, ElementOps> const&);



















protected:

           IGBagAsTable
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGBagAsTable
                              <
                               Element, ElementOps> const&);

private:

  friend
  class    IGBagAsTableCursor <Element, ElementOps>;






















};

template <class Element>
class IBagAsTable :
  public IGBagAsTable
          <Element, ICOps <Element> > {

  typedef  IGBagAsTable
            <Element,
             ICOps <Element> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IBagAsTable <Element> Self;

#define IBagAsTableTypedef(Element)\
  typedef  IBagAsTableOps\
            <Element,\
             IWCOps <Element, ICOps <Element> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           IBagAsTable
                            (INumber = 100);

















protected:

           IBagAsTable
                              (PureImplementation&);

private:












};


template <class Element, class ElementOps>
class IVGBagAsTable :
  public IGBagAsTable
          <Element, ElementOps > {

  typedef  IVGBagAsTable
            <Element, ElementOps> Inherited;

protected:

  typedef TYPENAME
           IGBagAsTable
            <Element, ElementOps>::PureImplementation PureImplementation;

#if defined (INO_CHECKS)
  typedef  IVBagImpl
            <PureImplementation> Implementation;
#else
  typedef  ICBagImpl
            <IVBagImpl
              <PureImplementation> > Implementation;
#endif

#define IVGBagAsTableTypedef(Element, ElementOps)\
  typedef  IBagAsTableOps\
            <Element,\
             IWCOps <Element, ElementOps>,\
             Implementation> Instantiation

           IVGBagAsTableTypedef (Element, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

           IVGBagAsTable
                            (INumber = 100);

















protected:

           IVGBagAsTable
                              (PureImplementation&);

private:












};

template <class Element>
class IVBagAsTable :
  public IVGBagAsTable
          <Element, ICOps <Element> > {

  typedef  IVGBagAsTable
            <Element,
             ICOps <Element> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IVBagAsTable <Element> Self;

#define IVBagAsTableTypedef(Element)\
  typedef  IVBagAsTableOps\
            <Element,\
             IWCOps <Element, ICOps <Element> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           IVBagAsTable
                            (INumber = 100);

















protected:

           IVBagAsTable
                              (PureImplementation&);

private:












};



#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif





#include <ibagtab.inl>


#pragma info (restore)


#endif // _IBAGTAB_
