// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 04 1.5.1.5 source/core/collect/ibaglst.h, collection, ioc.v400, 980918 
#ifndef _IBAGLST_
#define _IBAGLST_

#include <ilanglvl.hpp>
#include <iabag.h>
#include <iicbag.h>

#include <iivbag.h>

#include <iibaglst.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

template <class Element, class ElementOps>
class IGBagAsList;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class ElementOps>
class IGBagAsListCursor :
  public IElementCursor <Element> {

  typedef  IElementCursor <Element> Inherited;

  typedef TYPENAME IGBagAsList
            <Element, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGBagAsListCursor
                            (IGBagAsList
                              <
                               Element, ElementOps> const&);

  IGBagAsListCursor <Element, ElementOps>&
           operator=        (IGBagAsListCursor
                              <
                               Element, ElementOps> const&);

protected:

           IGBagAsListCursor
                            (ICursorImpl*);

private:















};











































template <class Element, class ElementOps>
class IGBagAsList :
  public IABag <Element> {
protected:

  typedef  IGBagAsList <Element, ElementOps> Self;

  typedef  IBagAsListImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICBagImpl
            <PureImplementation> Implementation;
#endif

#define IGBagAsListTypedef(Element, ElementOps)\
  typedef  IBagAsListOps\
            <Element,\
             IWCOps <Element, ElementOps>,\
             Implementation> Instantiation

           IGBagAsListTypedef (Element, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

  typedef  IGBagAsListCursor
            <Element, ElementOps> Cursor;




           IGBagAsList
                            (INumber = 100);

           IGBagAsList
                            (IGBagAsList
                              <
                               Element, ElementOps> const&);

  IGBagAsList <Element, ElementOps>&
           operator=        (IGBagAsList
                              <
                               Element, ElementOps> const&);



















protected:

           IGBagAsList
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGBagAsList
                              <
                               Element, ElementOps> const&);

private:

  friend
  class    IGBagAsListCursor <Element, ElementOps>;






















};

template <class Element>
class IBagAsList :
  public IGBagAsList
          <Element, ICOps <Element> > {

  typedef  IGBagAsList
            <Element,
             ICOps <Element> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IBagAsList <Element> Self;

#define IBagAsListTypedef(Element)\
  typedef  IBagAsListOps\
            <Element,\
             IWCOps <Element, ICOps <Element> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           IBagAsList
                            (INumber = 100);

















protected:

           IBagAsList
                              (PureImplementation&);

private:












};


template <class Element, class ElementOps>
class IVGBagAsList :
  public IGBagAsList
          <Element, ElementOps > {

  typedef  IVGBagAsList
            <Element, ElementOps> Inherited;

protected:

  typedef TYPENAME
           IGBagAsList
            <Element, ElementOps>::PureImplementation PureImplementation;

#if defined (INO_CHECKS)
  typedef  IVBagImpl
            <PureImplementation> Implementation;
#else
  typedef  ICBagImpl
            <IVBagImpl
              <PureImplementation> > Implementation;
#endif

#define IVGBagAsListTypedef(Element, ElementOps)\
  typedef  IBagAsListOps\
            <Element,\
             IWCOps <Element, ElementOps>,\
             Implementation> Instantiation

           IVGBagAsListTypedef (Element, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

           IVGBagAsList
                            (INumber = 100);

















protected:

           IVGBagAsList
                              (PureImplementation&);

private:












};

template <class Element>
class IVBagAsList :
  public IVGBagAsList
          <Element, ICOps <Element> > {

  typedef  IVGBagAsList
            <Element,
             ICOps <Element> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IVBagAsList <Element> Self;

#define IVBagAsListTypedef(Element)\
  typedef  IVBagAsListOps\
            <Element,\
             IWCOps <Element, ICOps <Element> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           IVBagAsList
                            (INumber = 100);

















protected:

           IVBagAsList
                              (PureImplementation&);

private:












};



#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif





#include <ibaglst.inl>


#pragma info (restore)


#endif // _IBAGLST_
