// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 02 1.5.1.5 source/core/collect/ibaghsh.h, collection, ioc.v400, 980918 
#ifndef _IBAGHSH_
#define _IBAGHSH_

#include <ilanglvl.hpp>
#include <iabag.h>
#include <iicbag.h>

#include <iivbag.h>

#include <iibaghsh.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

template <class Element, class ElementOps>
class IGBagAsHshTable;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class ElementOps>
class IGBagAsHshTableCursor :
  public IElementCursor <Element> {

  typedef  IElementCursor <Element> Inherited;

  typedef TYPENAME IGBagAsHshTable
            <Element, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGBagAsHshTableCursor
                            (IGBagAsHshTable
                              <
                               Element, ElementOps> const&);

  IGBagAsHshTableCursor <Element, ElementOps>&
           operator=        (IGBagAsHshTableCursor
                              <
                               Element, ElementOps> const&);

protected:

           IGBagAsHshTableCursor
                            (ICursorImpl*);

private:















};











































template <class Element, class ElementOps>
class IGBagAsHshTable :
  public IABag <Element> {
protected:

  typedef  IGBagAsHshTable <Element, ElementOps> Self;

  typedef  IBagAsHshTableImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICBagImpl
            <PureImplementation> Implementation;
#endif

#define IGBagAsHshTableTypedef(Element, ElementOps)\
  typedef  IBagAsHshTableOps\
            <Element,\
             IWEHOps <Element, ElementOps>,\
             Implementation> Instantiation

           IGBagAsHshTableTypedef (Element, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

  typedef  IGBagAsHshTableCursor
            <Element, ElementOps> Cursor;




           IGBagAsHshTable
                            (INumber = 100);

           IGBagAsHshTable
                            (IGBagAsHshTable
                              <
                               Element, ElementOps> const&);

  IGBagAsHshTable <Element, ElementOps>&
           operator=        (IGBagAsHshTable
                              <
                               Element, ElementOps> const&);



















protected:

           IGBagAsHshTable
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGBagAsHshTable
                              <
                               Element, ElementOps> const&);

private:

  friend
  class    IGBagAsHshTableCursor <Element, ElementOps>;






















};

template <class Element>
class IBagAsHshTable :
  public IGBagAsHshTable
          <Element, IEHOps <Element> > {

  typedef  IGBagAsHshTable
            <Element,
             IEHOps <Element> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IBagAsHshTable <Element> Self;

#define IBagAsHshTableTypedef(Element)\
  typedef  IBagAsHshTableOps\
            <Element,\
             IWEHOps <Element, IEHOps <Element> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           IBagAsHshTable
                            (INumber = 100);

















protected:

           IBagAsHshTable
                              (PureImplementation&);

private:












};


template <class Element, class ElementOps>
class IVGBagAsHshTable :
  public IGBagAsHshTable
          <Element, ElementOps > {

  typedef  IVGBagAsHshTable
            <Element, ElementOps> Inherited;

protected:

  typedef TYPENAME
           IGBagAsHshTable
            <Element, ElementOps>::PureImplementation PureImplementation;

#if defined (INO_CHECKS)
  typedef  IVBagImpl
            <PureImplementation> Implementation;
#else
  typedef  ICBagImpl
            <IVBagImpl
              <PureImplementation> > Implementation;
#endif

#define IVGBagAsHshTableTypedef(Element, ElementOps)\
  typedef  IBagAsHshTableOps\
            <Element,\
             IWEHOps <Element, ElementOps>,\
             Implementation> Instantiation

           IVGBagAsHshTableTypedef (Element, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

           IVGBagAsHshTable
                            (INumber = 100);

















protected:

           IVGBagAsHshTable
                              (PureImplementation&);

private:












};

template <class Element>
class IVBagAsHshTable :
  public IVGBagAsHshTable
          <Element, IEHOps <Element> > {

  typedef  IVGBagAsHshTable
            <Element,
             IEHOps <Element> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IVBagAsHshTable <Element> Self;

#define IVBagAsHshTableTypedef(Element)\
  typedef  IVBagAsHshTableOps\
            <Element,\
             IWEHOps <Element, IEHOps <Element> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           IVBagAsHshTable
                            (INumber = 100);

















protected:

           IVBagAsHshTable
                              (PureImplementation&);

private:












};



#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif





#include <ibaghsh.inl>


#pragma info (restore)


#endif // _IBAGHSH_
