// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 99 1.5.1.5 source/core/collect/ibagdil.h, collection, ioc.v400, 980918 
#ifndef _IBAGDIL_
#define _IBAGDIL_

#include <ilanglvl.hpp>
#include <iabag.h>
#include <iicbag.h>

#include <iivbag.h>

#include <iibagdil.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

template <class Element, class ElementOps>
class IGBagAsDilTable;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class ElementOps>
class IGBagAsDilTableCursor :
  public IElementCursor <Element> {

  typedef  IElementCursor <Element> Inherited;

  typedef TYPENAME IGBagAsDilTable
            <Element, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGBagAsDilTableCursor
                            (IGBagAsDilTable
                              <
                               Element, ElementOps> const&);

  IGBagAsDilTableCursor <Element, ElementOps>&
           operator=        (IGBagAsDilTableCursor
                              <
                               Element, ElementOps> const&);

protected:

           IGBagAsDilTableCursor
                            (ICursorImpl*);

private:















};











































template <class Element, class ElementOps>
class IGBagAsDilTable :
  public IABag <Element> {
protected:

  typedef  IGBagAsDilTable <Element, ElementOps> Self;

  typedef  IBagAsDilTableImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICBagImpl
            <PureImplementation> Implementation;
#endif

#define IGBagAsDilTableTypedef(Element, ElementOps)\
  typedef  IBagAsDilTableOps\
            <Element,\
             IWCOps <Element, ElementOps>,\
             Implementation> Instantiation

           IGBagAsDilTableTypedef (Element, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

  typedef  IGBagAsDilTableCursor
            <Element, ElementOps> Cursor;




           IGBagAsDilTable
                            (INumber = 100);

           IGBagAsDilTable
                            (IGBagAsDilTable
                              <
                               Element, ElementOps> const&);

  IGBagAsDilTable <Element, ElementOps>&
           operator=        (IGBagAsDilTable
                              <
                               Element, ElementOps> const&);



















protected:

           IGBagAsDilTable
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGBagAsDilTable
                              <
                               Element, ElementOps> const&);

private:

  friend
  class    IGBagAsDilTableCursor <Element, ElementOps>;






















};

template <class Element>
class IBagAsDilTable :
  public IGBagAsDilTable
          <Element, ICOps <Element> > {

  typedef  IGBagAsDilTable
            <Element,
             ICOps <Element> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IBagAsDilTable <Element> Self;

#define IBagAsDilTableTypedef(Element)\
  typedef  IBagAsDilTableOps\
            <Element,\
             IWCOps <Element, ICOps <Element> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           IBagAsDilTable
                            (INumber = 100);

















protected:

           IBagAsDilTable
                              (PureImplementation&);

private:












};


template <class Element, class ElementOps>
class IVGBagAsDilTable :
  public IGBagAsDilTable
          <Element, ElementOps > {

  typedef  IVGBagAsDilTable
            <Element, ElementOps> Inherited;

protected:

  typedef TYPENAME
           IGBagAsDilTable
            <Element, ElementOps>::PureImplementation PureImplementation;

#if defined (INO_CHECKS)
  typedef  IVBagImpl
            <PureImplementation> Implementation;
#else
  typedef  ICBagImpl
            <IVBagImpl
              <PureImplementation> > Implementation;
#endif

#define IVGBagAsDilTableTypedef(Element, ElementOps)\
  typedef  IBagAsDilTableOps\
            <Element,\
             IWCOps <Element, ElementOps>,\
             Implementation> Instantiation

           IVGBagAsDilTableTypedef (Element, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

           IVGBagAsDilTable
                            (INumber = 100);

















protected:

           IVGBagAsDilTable
                              (PureImplementation&);

private:












};

template <class Element>
class IVBagAsDilTable :
  public IVGBagAsDilTable
          <Element, ICOps <Element> > {

  typedef  IVGBagAsDilTable
            <Element,
             ICOps <Element> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IVBagAsDilTable <Element> Self;

#define IVBagAsDilTableTypedef(Element)\
  typedef  IVBagAsDilTableOps\
            <Element,\
             IWCOps <Element, ICOps <Element> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           IVBagAsDilTable
                            (INumber = 100);

















protected:

           IVBagAsDilTable
                              (PureImplementation&);

private:












};



#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif





#include <ibagdil.inl>


#pragma info (restore)


#endif // _IBAGDIL_
