// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 97 1.5.1.5 source/core/collect/ibagbst.h, collection, ioc.v400, 980918 
#ifndef _IBAGBST_
#define _IBAGBST_

#include <ilanglvl.hpp>
#include <iabag.h>
#include <iicbag.h>

#include <iivbag.h>

#include <iibaglst.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

template <class Element, class ElementOps>
class IGBagAsBstTree;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class ElementOps>
class IGBagAsBstTreeCursor :
  public IElementCursor <Element> {

  typedef  IElementCursor <Element> Inherited;

  typedef TYPENAME IGBagAsBstTree
            <Element, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGBagAsBstTreeCursor
                            (IGBagAsBstTree
                              <
                               Element, ElementOps> const&);

  IGBagAsBstTreeCursor <Element, ElementOps>&
           operator=        (IGBagAsBstTreeCursor
                              <
                               Element, ElementOps> const&);

protected:

           IGBagAsBstTreeCursor
                            (ICursorImpl*);

private:















};











































template <class Element, class ElementOps>
class IGBagAsBstTree :
  public IABag <Element> {
protected:

  typedef  IGBagAsBstTree <Element, ElementOps> Self;

  typedef  IBagAsListImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICBagImpl
            <PureImplementation> Implementation;
#endif

#define IGBagAsBstTreeTypedef(Element, ElementOps)\
  typedef  IBagAsListOps\
            <Element,\
             IWCOps <Element, ElementOps>,\
             Implementation> Instantiation

           IGBagAsBstTreeTypedef (Element, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

  typedef  IGBagAsBstTreeCursor
            <Element, ElementOps> Cursor;




           IGBagAsBstTree
                            (INumber = 100);

           IGBagAsBstTree
                            (IGBagAsBstTree
                              <
                               Element, ElementOps> const&);

  IGBagAsBstTree <Element, ElementOps>&
           operator=        (IGBagAsBstTree
                              <
                               Element, ElementOps> const&);



















protected:

           IGBagAsBstTree
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGBagAsBstTree
                              <
                               Element, ElementOps> const&);

private:

  friend
  class    IGBagAsBstTreeCursor <Element, ElementOps>;






















};

template <class Element>
class IBagAsBstTree :
  public IGBagAsBstTree
          <Element, ICOps <Element> > {

  typedef  IGBagAsBstTree
            <Element,
             ICOps <Element> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IBagAsBstTree <Element> Self;

#define IBagAsBstTreeTypedef(Element)\
  typedef  IBagAsListOps\
            <Element,\
             IWCOps <Element, ICOps <Element> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           IBagAsBstTree
                            (INumber = 100);

















protected:

           IBagAsBstTree
                              (PureImplementation&);

private:












};


template <class Element, class ElementOps>
class IVGBagAsBstTree :
  public IGBagAsBstTree
          <Element, ElementOps > {

  typedef  IVGBagAsBstTree
            <Element, ElementOps> Inherited;

protected:

  typedef TYPENAME
           IGBagAsBstTree
            <Element, ElementOps>::PureImplementation PureImplementation;

#if defined (INO_CHECKS)
  typedef  IVBagImpl
            <PureImplementation> Implementation;
#else
  typedef  ICBagImpl
            <IVBagImpl
              <PureImplementation> > Implementation;
#endif

#define IVGBagAsBstTreeTypedef(Element, ElementOps)\
  typedef  IBagAsListOps\
            <Element,\
             IWCOps <Element, ElementOps>,\
             Implementation> Instantiation

           IVGBagAsBstTreeTypedef (Element, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

           IVGBagAsBstTree
                            (INumber = 100);

















protected:

           IVGBagAsBstTree
                              (PureImplementation&);

private:












};

template <class Element>
class IVBagAsBstTree :
  public IVGBagAsBstTree
          <Element, ICOps <Element> > {

  typedef  IVGBagAsBstTree
            <Element,
             ICOps <Element> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IVBagAsBstTree <Element> Self;

#define IVBagAsBstTreeTypedef(Element)\
  typedef  IVBagAsListOps\
            <Element,\
             IWCOps <Element, ICOps <Element> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           IVBagAsBstTree
                            (INumber = 100);

















protected:

           IVBagAsBstTree
                              (PureImplementation&);

private:












};



#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif





#include <ibagbst.inl>


#pragma info (restore)


#endif // _IBAGBST_
