// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 95 1.5.1.5 source/core/collect/ibagavl.h, collection, ioc.v400, 980918 
#ifndef _IBAGAVL_
#define _IBAGAVL_

#include <ilanglvl.hpp>
#include <iabag.h>
#include <iicbag.h>

#include <iivbag.h>

#include <iibaglst.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

template <class Element, class ElementOps>
class IGBagAsAvlTree;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class ElementOps>
class IGBagAsAvlTreeCursor :
  public IElementCursor <Element> {

  typedef  IElementCursor <Element> Inherited;

  typedef TYPENAME IGBagAsAvlTree
            <Element, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGBagAsAvlTreeCursor
                            (IGBagAsAvlTree
                              <
                               Element, ElementOps> const&);

  IGBagAsAvlTreeCursor <Element, ElementOps>&
           operator=        (IGBagAsAvlTreeCursor
                              <
                               Element, ElementOps> const&);

protected:

           IGBagAsAvlTreeCursor
                            (ICursorImpl*);

private:















};











































template <class Element, class ElementOps>
class IGBagAsAvlTree :
  public IABag <Element> {
protected:

  typedef  IGBagAsAvlTree <Element, ElementOps> Self;

  typedef  IBagAsListImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICBagImpl
            <PureImplementation> Implementation;
#endif

#define IGBagAsAvlTreeTypedef(Element, ElementOps)\
  typedef  IBagAsListOps\
            <Element,\
             IWCOps <Element, ElementOps>,\
             Implementation> Instantiation

           IGBagAsAvlTreeTypedef (Element, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

  typedef  IGBagAsAvlTreeCursor
            <Element, ElementOps> Cursor;




           IGBagAsAvlTree
                            (INumber = 100);

           IGBagAsAvlTree
                            (IGBagAsAvlTree
                              <
                               Element, ElementOps> const&);

  IGBagAsAvlTree <Element, ElementOps>&
           operator=        (IGBagAsAvlTree
                              <
                               Element, ElementOps> const&);



















protected:

           IGBagAsAvlTree
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGBagAsAvlTree
                              <
                               Element, ElementOps> const&);

private:

  friend
  class    IGBagAsAvlTreeCursor <Element, ElementOps>;






















};

template <class Element>
class IBagAsAvlTree :
  public IGBagAsAvlTree
          <Element, ICOps <Element> > {

  typedef  IGBagAsAvlTree
            <Element,
             ICOps <Element> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IBagAsAvlTree <Element> Self;

#define IBagAsAvlTreeTypedef(Element)\
  typedef  IBagAsListOps\
            <Element,\
             IWCOps <Element, ICOps <Element> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           IBagAsAvlTree
                            (INumber = 100);

















protected:

           IBagAsAvlTree
                              (PureImplementation&);

private:












};


template <class Element, class ElementOps>
class IVGBagAsAvlTree :
  public IGBagAsAvlTree
          <Element, ElementOps > {

  typedef  IVGBagAsAvlTree
            <Element, ElementOps> Inherited;

protected:

  typedef TYPENAME
           IGBagAsAvlTree
            <Element, ElementOps>::PureImplementation PureImplementation;

#if defined (INO_CHECKS)
  typedef  IVBagImpl
            <PureImplementation> Implementation;
#else
  typedef  ICBagImpl
            <IVBagImpl
              <PureImplementation> > Implementation;
#endif

#define IVGBagAsAvlTreeTypedef(Element, ElementOps)\
  typedef  IBagAsListOps\
            <Element,\
             IWCOps <Element, ElementOps>,\
             Implementation> Instantiation

           IVGBagAsAvlTreeTypedef (Element, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

           IVGBagAsAvlTree
                            (INumber = 100);

















protected:

           IVGBagAsAvlTree
                              (PureImplementation&);

private:












};

template <class Element>
class IVBagAsAvlTree :
  public IVGBagAsAvlTree
          <Element, ICOps <Element> > {

  typedef  IVGBagAsAvlTree
            <Element,
             ICOps <Element> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IVBagAsAvlTree <Element> Self;

#define IVBagAsAvlTreeTypedef(Element)\
  typedef  IVBagAsListOps\
            <Element,\
             IWCOps <Element, ICOps <Element> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           IVBagAsAvlTree
                            (INumber = 100);

















protected:

           IVBagAsAvlTree
                              (PureImplementation&);

private:












};



#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif





#include <ibagavl.inl>


#pragma info (restore)


#endif // _IBAGAVL_
