// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 93 1.5.1.5 source/core/collect/ibag.h, collection, ioc.v400, 980918 
#ifndef _IBAG_
#define _IBAG_

#include <ilanglvl.hpp>
#include <iabag.h>
#include <iicbag.h>

#include <iivbag.h>

#include <iibaglst.h>







#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

template <class Element, class ElementOps>
class IGBag;

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class ElementOps>
class IGBagCursor :
  public IElementCursor <Element> {

  typedef  IElementCursor <Element> Inherited;

  typedef TYPENAME IGBag
            <Element, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGBagCursor
                            (IGBag
                              <
                               Element, ElementOps> const&);

  IGBagCursor <Element, ElementOps>&
           operator=        (IGBagCursor
                              <
                               Element, ElementOps> const&);

protected:

           IGBagCursor
                            (ICursorImpl*);

private:















};











































template <class Element, class ElementOps>
class IGBag :
  public IABag <Element> {
protected:

  typedef  IGBag <Element, ElementOps> Self;

  typedef  IBagAsListImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICBagImpl
            <PureImplementation> Implementation;
#endif

#define IGBagTypedef(Element, ElementOps)\
  typedef  IBagAsListOps\
            <Element,\
             IWCOps <Element, ElementOps>,\
             Implementation> Instantiation

           IGBagTypedef (Element, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

  typedef  IGBagCursor
            <Element, ElementOps> Cursor;




           IGBag
                            (INumber = 100);

           IGBag
                            (IGBag
                              <
                               Element, ElementOps> const&);

  IGBag <Element, ElementOps>&
           operator=        (IGBag
                              <
                               Element, ElementOps> const&);



















protected:

           IGBag
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGBag
                              <
                               Element, ElementOps> const&);

private:

  friend
  class    IGBagCursor <Element, ElementOps>;






















};

template <class Element>
class IBag :
  public IGBag
          <Element, ICOps <Element> > {

  typedef  IGBag
            <Element,
             ICOps <Element> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IBag <Element> Self;

#define IBagTypedef(Element)\
  typedef  IBagAsListOps\
            <Element,\
             IWCOps <Element, ICOps <Element> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           IBag
                            (INumber = 100);

















protected:

           IBag
                              (PureImplementation&);

private:












};


template <class Element, class ElementOps>
class IVGBag :
  public IGBag
          <Element, ElementOps > {

  typedef  IVGBag
            <Element, ElementOps> Inherited;

protected:

  typedef TYPENAME
           IGBag
            <Element, ElementOps>::PureImplementation PureImplementation;

#if defined (INO_CHECKS)
  typedef  IVBagImpl
            <PureImplementation> Implementation;
#else
  typedef  ICBagImpl
            <IVBagImpl
              <PureImplementation> > Implementation;
#endif

#define IVGBagTypedef(Element, ElementOps)\
  typedef  IBagAsListOps\
            <Element,\
             IWCOps <Element, ElementOps>,\
             Implementation> Instantiation

           IVGBagTypedef (Element, ElementOps);

public:

  typedef ICollectionGuard<Element> Guard;

           IVGBag
                            (INumber = 100);

















protected:

           IVGBag
                              (PureImplementation&);

private:












};

template <class Element>
class IVBag :
  public IVGBag
          <Element, ICOps <Element> > {

  typedef  IVGBag
            <Element,
             ICOps <Element> > Inherited;

protected:

  typedef TYPENAME Inherited::PureImplementation PureImplementation;

  typedef  IVBag <Element> Self;

#define IVBagTypedef(Element)\
  typedef  IVBagAsListOps\
            <Element,\
             IWCOps <Element, ICOps <Element> >,\
             Implementation> Instantiation

public:

  typedef ICollectionGuard<Element> Guard;

           IVBag
                            (INumber = 100);

















protected:

           IVBag
                              (PureImplementation&);

private:












};



#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif





#include <ibag.inl>


#pragma info (restore)


#endif // _IBAG_
