// Revision: 13 1.4.1.5 source/core/attrib/iattribt.hpp, attributes, ioc.v400, 980918 
/*******************************************************************************
* FILE NAME: iattribt.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IAttribute                                                               *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1997       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*                                                                              *
*******************************************************************************/


#ifndef _IATTRIBT_
#define _IATTRIBT_

#include <iprimtyp.hpp> // bool
#include <ilanglvl.hpp>
#include <ibasepl.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#pragma enum(4)
#pragma pack(push,4)

// Attribute is an abstract base class for user defined attributes.

class IAttribute
{
public:
    virtual                    ~IAttribute() {}

   /**
    * Tests two IAttributes for equality. This is an abstract member function.
    * @param     (const IAttribute&)     The IAttribute to be compared with this one.
    * @return    True if this IAttribute and the argument are equal.
    * @exception None
    */
    virtual bool               operator==(const IAttribute& anAttribute) const = 0;
   /**
    * Tests two IAttributes for inequality.
    * @param     (const IAttribute&)     The IAttribute to be compared with this one.
    * @return    True if this IAttribute and the argument are not equal.
    * @exception None
    */
    bool                       operator!=(const IAttribute& anAttribute) const;

    /**
     * Returns a polymorphic copy of the attribute.
     * @return          A polymorphic copy of the attribute.
     * @exception       None
     */
    virtual IAttribute*        clone() const = 0;  // in lieu of ::Copy()

};

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

// NOTE: collections require an operator= and operator== methods.
//  It would be nice to make both pure virtual so that the user
//  is forced to define them, but this doesn't work for the
//  operator= case so we will just have to document this requirement.

#endif
