// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 90 1.7.1.3 source/core/collect/iatree.h, collection, ioc.v400, 980918 
#ifndef _IATREE_
#define _IATREE_

#include <ibtree.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#pragma pack(push,4)
#pragma enum(4)


template <class Element>
class ITreeCollectionGuard 
{
public:
  ITreeCollectionGuard (IATree<Element>&, long timeout=-1);

  ~ITreeCollectionGuard ();

private:
  IATree<Element>& ivCollection;

  ITreeCollectionGuard (const ITreeCollectionGuard<Element>&);

         ITreeCollectionGuard<Element>
          &operator=          (const ITreeCollectionGuard<Element>&);











};


template <class Element>
class IElementTreeCursor : public ITreeCursor 
{
  typedef  ITreeCursorImpl Implementation;

public:

  Element const&
           element          () const;

protected:

           IElementTreeCursor
                            (Implementation*);










};

template <class Element> class IATree : protected IATreeBase 
{
  typedef  IATreeImpl Implementation;

public:

          ~IATree           ();

  void     addAsChild       (ITreeCursor const&,
                             IPosition, Element const&);

  void     addAsRoot        (Element const&);

  bool allElementsDo    (bool (*applicatorFunction)
                              (Element&, void*),
                             ITreeIterationOrder,
                             void* additionalArgument = 0);

  bool allElementsDo    (bool (*applicatorFunction)
                              (Element const&, void*),
                             ITreeIterationOrder,
                             void* additionalArgument = 0) const;

  bool allElementsDo    (IApplicator <Element>&,
                             ITreeIterationOrder);

  bool allElementsDo    (IConstantApplicator <Element>&,
                             ITreeIterationOrder) const;

  bool allSubtreeElementsDo
                            (ITreeCursor const&,
                             bool (*applicatorFunction)
                              (Element&, void*),
                             ITreeIterationOrder,
                             void* additionalArgument = 0);

  bool allSubtreeElementsDo
                            (ITreeCursor const&,
                             bool (*applicatorFunction)
                              (Element const&, void*),
                             ITreeIterationOrder,
                             void* additionalArgument = 0) const;

  bool allSubtreeElementsDo
                            (ITreeCursor const&,
                             IApplicator <Element>&,
                             ITreeIterationOrder);

  bool allSubtreeElementsDo
                            (ITreeCursor const&,
                             IConstantApplicator <Element>&,
                             ITreeIterationOrder) const;

  IPosition
           childPositionAt  (ITreeCursor const&) const;

  Element& elementAt        (ITreeCursor const&);

  Element const&
           elementAt        (ITreeCursor const&) const;

  bool isConsistent     () const;

  bool isEmpty          () const;

  bool isLeaf           (ITreeCursor const&) const;

  bool isRoot           (ITreeCursor const&) const;

  ITreeCursor*
           newCursor        () const;

  INumber  numberOfElements () const;

  INumber  numberOfLeaves   () const;

  INumber  numberOfSubtreeElements
                            (ITreeCursor const&) const;

  INumber  numberOfSubtreeLeaves
                            (ITreeCursor const&) const;

  INumber  removeAll        ();

  INumber  removeSubtree    (ITreeCursor&);

  void     replaceAt        (ITreeCursor const&, Element const&);

  bool setToChild       (IPosition, ITreeCursor&) const;

  bool setToFirst       (ITreeCursor&, ITreeIterationOrder) const;

  bool setToFirstExistingChild
                            (ITreeCursor&) const;

  bool setToLast        (ITreeCursor&, ITreeIterationOrder) const;

  bool setToLastExistingChild
                            (ITreeCursor&) const;

  bool setToNext        (ITreeCursor&, ITreeIterationOrder) const;

  bool setToNextExistingChild
                            (ITreeCursor&) const;

  bool setToParent      (ITreeCursor&) const;

  bool setToPrevious    (ITreeCursor&, ITreeIterationOrder) const;

  bool setToPreviousExistingChild
                            (ITreeCursor&) const;

  bool setToRoot        (ITreeCursor&) const;

  // for backward compatibility
  IPosition
           position         (ITreeCursor const&) const;

protected:


         friend class ITreeCollectionGuard<Element>;


           IATree           ();

           IATree           (IATree <Element> const&);

  static
  Implementation&
           ImplOf           (IATree <Element> const&);

private:

#if ! defined(__INO_STREAMING__)
public:
  void   operator<<=      (IDataStream&);

  void   operator>>=      (IDataStream&);

  void   adoptStreamer    (IACollectionStreamer*);
#endif

















};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif





#include <iatree.inl>


#pragma info (restore)


#endif // _IATREE_
