// Revision: 16 1.5.1.5 source/core/attrib/iatname.hpp, attributes, ioc.v400, 980918 
/*******************************************************************************
* FILE NAME: iatname.hpp                                                       *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IAttributeName                                                           *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1997       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*                                                                              *
*******************************************************************************/


#ifndef _IATNAME_
#define _IATNAME_

#include <iprimtyp.hpp> // bool
#include <ibasepl.hpp>

#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#pragma enum(4)
#pragma pack(push,4)

// IAttributeName is a simple token class used to tag attributes.

class IAttributeName {
public:
                            IAttributeName(const IAttributeName&);
                            IAttributeName(const char*);
                            ~IAttributeName();

    /**
     * Assignment operator.
     * @param     (const IAttributeName&)     The IAttributeName to be copied from.
     * @return    A reference to the left-hand side object.
     */
    IAttributeName&         operator=(const IAttributeName& rhs);          // required by collections
    /**
     * Tests two IAttributeNames for equality.
     * @param     (const IAttributeName&)     The IAttributeName to be compared with this one.
     * @return    True if this IAttributeName and the argument are equal.
     * @exception None
     */
    bool                    operator==(const IAttributeName& rhs) const;   // required by collections
    /**
     * Tests two IAttributeNames for inequality.
     * @param     (const IAttributeName&)     The IAttributeName to be compared with this one.
     * @return    True if this IAttributeName and the argument are not equal.
     * @exception None
     */
    bool                    operator!=(const IAttributeName& rhs) const;

    /**
     * Returns the attribute name as a hash value for quick comparisons.
     * @return          the hash value
     * @exception       None
     */
    unsigned long           hash() const;
    /**
     * Returns the attribute name.
     * @return          The attribute name
     * @exception       None
     */
    const char*             getString() const;

private:
                            // no default constructor
                            IAttributeName() {}

    // IPrivateToken is used for reference counting on the actual char* data.
    struct IPrivateToken {
                            IPrivateToken(const char* s);
                            ~IPrivateToken();

        unsigned long       fHashValue;
        char*               fString;
        int                 fRefCount;
    };

    IPrivateToken*          fData;
};

#pragma pack(pop)
#pragma enum(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#include <iatname.inl>

#endif // _IATNAME_
