// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 88 1.4.1.3 source/core/collect/iastk.h, collection, ioc.v400, 980918 
#ifndef _IASTK_
#define _IASTK_

#include <iarstrct.h>
#include <iaorder.h>
#include <iiaseq.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#pragma pack(push,4)
#pragma enum(4)

template <class Element>
class IAStack :
  public IARestrictedAccessCollection <Element> {

  typedef  IARestrictedAccessCollection <Element> Inherited;

  typedef  IASequenceImpl Implementation;

public:


           IAStack
                            (INotifier&);


          ~IAStack
                            ();




  void     addAsLast        (Element const&);




  void     addAsLast        (Element const&, ICursor&);

  long     compare          (IAStack <Element> const&,
                             long (*comparisonFunction)
                              (Element const&, Element const&)) const;
 



  void     pop              ();




  void     pop              (Element&);




  void     push             (Element const&);




  void     push             (Element const&, ICursor&);




  void     removeLast       ();

  Element const&
           top              () const;

protected:

           IAStack
                            ();

           IAStack
                            (IAStack <Element> const&);

private:

  static
  Implementation&
           ImplOf           (IAStack <Element> const&);




















};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#include <iastk.inl>






#pragma info (restore)


#endif // _IASTK_
