// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 85 1.5.1.3 source/core/collect/iass.h, collection, ioc.v400, 980918 
#ifndef _IASS_
#define _IASS_

#include <iaeqsrt.h>
#include <iiass.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#pragma pack(push,4)
#pragma enum(4)

template <class Element>
class IASortedSet :
  public IAEqualitySortedCollection <Element> {

  typedef  IAEqualitySortedCollection <Element> Inherited;

  typedef  IASortedSetImpl Implementation;

public:


           IASortedSet
                            (INotifier&);


          ~IASortedSet
                            ();




  void     addDifference    (IASortedSet <Element> const&,
                             IASortedSet <Element> const&); 




  void     addIntersection  (IASortedSet <Element> const&,
                             IASortedSet <Element> const&);




  void     addUnion         (IASortedSet <Element> const&,
                             IASortedSet <Element> const&);

  long     compare          (IASortedSet <Element> const&,
                             long (*comparisonFunction)
                              (Element const&, Element const&)) const;
 



  void     differenceWith   (IASortedSet <Element> const&);




  void     intersectionWith (IASortedSet <Element> const&);




  void     unionWith        (IASortedSet <Element> const&);

  bool     operator==       (IASortedSet
                              <Element> const&) const;

  bool     operator!=       (IASortedSet
                              <Element> const&) const;

protected:

           IASortedSet
                            ();

           IASortedSet
                            (IASortedSet <Element> const&);

  INumber  numberOfOccurrences
                            (Element const&) const;

  INumber  removeAllOccurrences
                            (Element const&);

private:

  static
  Implementation&
           ImplOf           (IASortedSet <Element> const&);













};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#include <iass.inl>






#pragma info (restore)


#endif // _IASS_
