// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 77 1.5.1.3 source/core/collect/iasr.h, collection, ioc.v400, 980918 
#ifndef _IASR_
#define _IASR_

#include <iaeqksrt.h>
#include <iiasr.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class Key>
class IASortedRelation :
  public IAEqualityKeySortedCollection <Element, Key> {

  typedef  IAEqualityKeySortedCollection <Element, Key> Inherited;

  typedef  IASortedRelationImpl Implementation;

public:


           IASortedRelation
                            (INotifier&);


          ~IASortedRelation
                            ();




  void     addDifference    (IASortedRelation <Element, Key> const&,
                             IASortedRelation <Element, Key> const&); 




  void     addIntersection  (IASortedRelation <Element, Key> const&,
                             IASortedRelation <Element, Key> const&);




  void     addUnion         (IASortedRelation <Element, Key> const&,
                             IASortedRelation <Element, Key> const&);

  long     compare          (IASortedRelation <Element, Key> const&,
                             long (*comparisonFunction)
                              (Element const&, Element const&)) const;
 



  void     differenceWith   (IASortedRelation <Element, Key> const&);




  void     intersectionWith (IASortedRelation <Element, Key> const&);




  void     unionWith        (IASortedRelation <Element, Key> const&);

  bool     operator==       (IASortedRelation
                              <Element, Key> const&) const;

  bool     operator!=       (IASortedRelation
                              <Element, Key> const&) const;

protected:

           IASortedRelation
                            ();

           IASortedRelation
                            (IASortedRelation <Element, Key> const&);

  INumber  numberOfOccurrences
                            (Element const&) const;

  INumber  removeAllOccurrences
                            (Element const&);

private:

  static
  Implementation&
           ImplOf           (IASortedRelation <Element, Key> const&);













};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#include <iasr.inl>






#pragma info (restore)


#endif // _IASR_
