// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 75 1.4.1.3 source/core/collect/iasqntl.h, collection, ioc.v400, 980918 
#ifndef _IASQNTL_
#define _IASQNTL_

#include <iaorder.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#pragma pack(push,4)
#pragma enum(4)

template  <class Element>
class IASequentialCollection : public IAOrderedCollection <Element> 
{
  typedef IACollectionImpl Implementation;

public:


           IASequentialCollection
                            (INotifier&);


          ~IASequentialCollection
                            ();




  void     addAsFirst       (Element const&);




  void     addAsFirst       (Element const&, ICursor&);




  void     addAsLast        (Element const&);




  void     addAsLast        (Element const&, ICursor&);




  void     addAsNext        (Element const&, ICursor&);




  void     addAsPrevious    (Element const&, ICursor&);




  void     addAtPosition    (IPosition, Element const&);




  void     addAtPosition    (IPosition, Element const&, ICursor&);

  Element& any              ();

  Element const&
           any              () const;

  Element& elementAtPosition
                            (IPosition);

  Element const&
           elementAtPosition
                            (IPosition) const;

  Element& first            ();

  Element const&
           first            () const;

  Element& last             ();

  Element const&
           last             () const;




  void     reverse          ();




  void     sort             (long (*comparisonFunction)
                              (Element const&, Element const&));

protected:

           IASequentialCollection
                            ();

           IASequentialCollection
                            (IASequentialCollection <Element> const&);

private:

  static
  Implementation&
           ImplOf           (IASequentialCollection <Element> const&);


















};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif





#include <iasqntl.inl>


#pragma info (restore)


#endif // _IASQNTL_
