// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 73 1.5.1.3 source/core/collect/iasm.h, collection, ioc.v400, 980918 
#ifndef _IASM_
#define _IASM_

#include <iaeqksrt.h>
#include <iiasm.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#pragma pack(push,4)
#pragma enum(4)

template <class Element, class Key>
class IASortedMap :
  public IAEqualityKeySortedCollection <Element, Key> {

  typedef  IAEqualityKeySortedCollection <Element, Key> Inherited;

  typedef  IASortedMapImpl Implementation;

public:


           IASortedMap
                            (INotifier&);


          ~IASortedMap
                            ();




  void     addDifference    (IASortedMap <Element, Key> const&,
                             IASortedMap <Element, Key> const&); 




  void     addIntersection  (IASortedMap <Element, Key> const&,
                             IASortedMap <Element, Key> const&);




  void     addUnion         (IASortedMap <Element, Key> const&,
                             IASortedMap <Element, Key> const&);

  long     compare          (IASortedMap <Element, Key> const&,
                             long (*comparisonFunction)
                              (Element const&, Element const&)) const;
 



  void     differenceWith   (IASortedMap <Element, Key> const&);




  void     intersectionWith (IASortedMap <Element, Key> const&);




  void     unionWith        (IASortedMap <Element, Key> const&);

  bool     operator==       (IASortedMap
                              <Element, Key> const&) const;

  bool     operator!=       (IASortedMap
                              <Element, Key> const&) const;

protected:

           IASortedMap
                            ();

           IASortedMap
                            (IASortedMap <Element, Key> const&);

  INumber  numberOfDifferentKeys
                            () const;

  INumber  numberOfElementsWithKey
                            (Key const&) const;

  INumber  numberOfOccurrences
                            (Element const&) const;

  INumber  removeAllOccurrences
                            (Element const&);

  INumber  removeAllElementsWithKey
                            (Key const&);

  bool     setToNextWithDifferentKey
                            (ICursor&) const;

private:

  static
  Implementation&
           ImplOf           (IASortedMap <Element, Key> const&);













};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#include <iasm.inl>






#pragma info (restore)


#endif // _IASM_
