// IBM Open Class Library
//
// Licensed Materials - Property of IBM
//
// (C) Copyright IBM Corporation, 1992, 1997 All Rights Reserved
//
// Revision: 71 1.5.1.3 source/core/collect/iaset.h, collection, ioc.v400, 980918 
#ifndef _IASET_
#define _IASET_

#include <iaequal.h>
#include <iiaset.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)










#if __IBMCPP__ >= 400
#pragma namemangling(compat)
#endif

#pragma pack(push,4)
#pragma enum(4)

template <class Element>
class IASet :
  public IAEqualityCollection <Element> {

  typedef  IAEqualityCollection <Element> Inherited;

  typedef  IASetImpl Implementation;

public:


           IASet
                            (INotifier&);


          ~IASet
                            ();




  void     addDifference    (IASet <Element> const&,
                             IASet <Element> const&); 




  void     addIntersection  (IASet <Element> const&,
                             IASet <Element> const&);




  void     addUnion         (IASet <Element> const&,
                             IASet <Element> const&);




  void     differenceWith   (IASet <Element> const&);




  void     intersectionWith (IASet <Element> const&);




  void     unionWith        (IASet <Element> const&);

  bool     operator==       (IASet
                              <Element> const&) const;

  bool     operator!=       (IASet
                              <Element> const&) const;

protected:

           IASet
                            ();

           IASet
                            (IASet <Element> const&);

  bool     locateNext       (Element const&, ICursor&) const;

  INumber  numberOfOccurrences
                            (Element const&) const;

  INumber  removeAllOccurrences
                            (Element const&);

private:

  static
  Implementation&
           ImplOf           (IASet <Element> const&);













};

#pragma enum(pop)
#pragma pack(pop)

#if __IBMCPP__ >= 400
#pragma namemangling()
#endif

#include <iaset.inl>






#pragma info (restore)


#endif // _IASET_
